/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.craft.stat;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapLike;
import com.redpxnda.nucleus.util.PriorityMultiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_5699;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.craft.stat.CraftingStat;
import smartin.miapi.craft.stat.StatActorType;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.registries.RegistryInventory;

public class StatProvidersMap {
    protected Map<CraftingStat<?>, Map<StatActorType, PriorityMultiMap<?>>> raw = new HashMap();
    public static final Codec MODULELESS_CODEC = new Codec();

    public <T> T evaluate(CraftingStat<T> stat) {
        return StatActorType.evaluate(stat, this.get(stat));
    }

    public <T> Map<CraftingStat<T>, T> evaluateAll() {
        HashMap result = new HashMap();
        this.raw.forEach((stat, map) -> result.put(stat, StatActorType.evaluate(stat, map)));
        return result;
    }

    public <T> Map<StatActorType, PriorityMultiMap<T>> get(CraftingStat<T> stat) {
        return this.raw.get(stat);
    }

    public <T> void put(CraftingStat<T> stat, Map<StatActorType, PriorityMultiMap<T>> map) {
        this.raw.put(stat, map);
    }

    public <T> StatProvidersMap set(CraftingStat<T> stat, StatActorType type, T instance) {
        this.put(stat, type, instance);
        return this;
    }

    public <T> StatProvidersMap set(CraftingStat<T> stat, StatActorType type, T instance, float prio) {
        this.put(stat, type, instance, prio);
        return this;
    }

    public <T> void put(CraftingStat<T> stat, StatActorType type, T instance, float prio) {
        PriorityMultiMap instances;
        Map<StatActorType, PriorityMultiMap<T>> map = this.get(stat);
        if (map == null) {
            map = new HashMap<StatActorType, PriorityMultiMap<T>>();
            this.put(stat, map);
        }
        if ((instances = map.get(type)) == null) {
            instances = new PriorityMultiMap();
            map.put(type, instances);
        }
        instances.put(instance, Float.valueOf(prio));
    }

    public void putAll(StatProvidersMap map) {
        map.raw.forEach((stat, inner) -> inner.forEach((actor, prioMap) -> prioMap.forEach((inst, prio) -> this.put((CraftingStat)stat, (StatActorType)actor, (Object)inst, prio.floatValue()))));
    }

    <T> void put(CraftingStat<T> stat, StatActorType type, T instance) {
        this.put(stat, type, instance, 0.0f);
    }

    public Map<CraftingStat<?>, Map<StatActorType, PriorityMultiMap<?>>> getRaw() {
        return this.raw;
    }

    public static class Codec
    implements com.mojang.serialization.Codec<StatProvidersMap> {
        @Nullable
        private final ModuleInstance modules;

        public Codec() {
            this.modules = null;
        }

        public Codec(@Nullable ModuleInstance modules) {
            this.modules = modules;
        }

        public <T> DataResult<Pair<StatProvidersMap, T>> decode(DynamicOps<T> ops, T input) {
            StatProvidersMap result = new StatProvidersMap();
            MapLike map = (MapLike)ops.getMap(input).getOrThrow(s -> new RuntimeException("Failed to create base map in StatProvidersMapCodec! -> {}"));
            map.entries().forEach(p -> {
                String str = (String)ops.getStringValue(p.getFirst()).getOrThrow(s -> new RuntimeException("Failed to create string value in StatRequirementMapCodec! -> {}"));
                CraftingStat stat = RegistryInventory.CRAFTING_STATS_REGISTRY.get(str);
                if (stat == null) {
                    return;
                }
                ((Stream)ops.getStream(p.getSecond()).getOrThrow(s -> new RuntimeException("Failed to getVertexConsumer data as a list for stat '{}' in StatProvidersMapCodec! -> {}"))).forEach(val -> {
                    MapLike details = (MapLike)ops.getMap(val).getOrThrow(s -> new RuntimeException("Failed to parse details for stat '{}' in StatProvidersMapCodec! -> {}"));
                    Object actorTypeRaw = details.get("type");
                    String actorType = actorTypeRaw == null ? "anchor" : (String)ops.getStringValue(actorTypeRaw).getOrThrow(s -> new RuntimeException("Failed to parse actor type '{}' in StatProvidersMapCodec! -> {}"));
                    StatActorType actor = (StatActorType)StatActorType.REGISTERED.get((Object)actorType);
                    if (actor != null) {
                        Object prioRaw = details.get("priority");
                        float prio = prioRaw == null ? 0.0f : ((Number)ops.getNumberValue(prioRaw).getOrThrow(s -> new RuntimeException("Failed to parse priority for actor in StatProvidersMapCodec! -> {}"))).floatValue();
                        Object valueRaw = details.get("value");
                        if (valueRaw instanceof JsonElement) {
                            JsonElement element = (JsonElement)valueRaw;
                            if (this.modules == null) {
                                Miapi.LOGGER.error("Cannot decode JSON for a stat provider actor without modules context!");
                                throw new RuntimeException("Cannot decode JSON for a stat provider actor without modules context!");
                            }
                            result.put(stat, actor, stat.createFromJson(element, this.modules), prio);
                        } else if (valueRaw instanceof class_2520) {
                            class_2520 element = (class_2520)valueRaw;
                            result.put(stat, actor, stat.createFromNbt(element));
                        } else {
                            if (this.modules == null) {
                                Miapi.LOGGER.error("Cannot decode non-JSON/non-NBT for a stat provider actor without modules context!");
                                throw new RuntimeException("Cannot decode non-JSON/non-NBT for a stat provider actor without modules context!");
                            }
                            result.put(stat, actor, stat.createFromJson((JsonElement)class_5699.field_40721.parse(ops, valueRaw).getOrThrow(s -> new RuntimeException("Failed to turn value into a JsonElement while decoding a StatProviderMap! -> {}")), this.modules), prio);
                        }
                    }
                });
            });
            return DataResult.success((Object)Pair.of((Object)result, input));
        }

        public <T> DataResult<T> encode(StatProvidersMap input, DynamicOps<T> ops, T prefix) {
            HashMap map = new HashMap();
            input.raw.forEach((stat, actors) -> {
                ArrayList objects = new ArrayList();
                actors.forEach((actor, prioMap) -> prioMap.forEach((instance, prio) -> {
                    HashMap<Object, Object> details = new HashMap<Object, Object>();
                    details.put(ops.createString("type"), ops.createString((String)StatActorType.REGISTERED.inverse().get(actor)));
                    details.put(ops.createString("priority"), ops.createFloat(prio.floatValue()));
                    if (ops instanceof JsonOps) {
                        details.put(ops.createString("value"), stat.saveToJson(instance));
                    } else if (ops instanceof class_2509) {
                        details.put(ops.createString("value"), stat.saveToNbt(instance));
                    } else {
                        details.put(ops.createString("value"), class_5699.field_40721.encodeStart(ops, (Object)stat.saveToJson(instance)).getOrThrow());
                    }
                    objects.add(ops.createMap(details));
                }));
                map.put(ops.createString(RegistryInventory.CRAFTING_STATS_REGISTRY.findKey((CraftingStat)stat).toString()), ops.createList(objects.stream()));
            });
            return DataResult.success((Object)ops.createMap(map));
        }
    }
}

