/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.datapack;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.handler.codec.DecoderException;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import smartin.miapi.Miapi;
import smartin.miapi.blueprint.BlueprintComponent;
import smartin.miapi.blueprint.BlueprintManager;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.editor.DocPage;
import smartin.miapi.item.ItemToModularConverter;
import smartin.miapi.material.CodecMaterial;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.composite.material.DatapackComposite;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ItemModuleExtension;
import smartin.miapi.modules.abilities.key.KeyBindManager;
import smartin.miapi.modules.edit_options.CreateItemOption.CreateItemOption;
import smartin.miapi.modules.edit_options.skins.SkinOptions;
import smartin.miapi.modules.synergies.SynergyManager;
import smartin.miapi.registries.MiapiRegistry;
import smartin.miapi.registries.RegistryInventory;

public class ReloadHelpers {
    public static void registerReloadHandlers() {
        ReloadHelpers.registerReloadHandler("miapi/modules", RegistryInventory.ITEM_MODULE_MIAPI_REGISTRY, ItemModule::loadFromData, -0.5f);
        ReloadHelpers.registerReloadHandler("miapi/module_extensions", () -> {}, (boolean isClient, class_2960 path, JsonElement data, class_5455 access) -> ItemModuleExtension.loadModuleExtension(path, data, isClient), (boolean isClient, class_2960 path, T data, class_5455 access) -> data.apply(), -0.4f);
        ReloadHelpers.registerReloadHandler("miapi/synergies", SynergyManager::clear, (boolean isClient, class_2960 path, JsonElement data, class_5455 access) -> (SynergyManager.Synergy)((Pair)SynergyManager.SYNERGY_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)data).getOrThrow(string -> new DecoderException("Could not decode Synergy " + String.valueOf(path) + string))).getFirst(), (boolean isClient, class_2960 path, T data, class_5455 access) -> data.register(), 2.0f);
        ReloadHelpers.registerReloadHandler("miapi/wiki", () -> DocPage.PAGE_LOOKUP.clear(), (boolean isClient, class_2960 path, JsonElement data, class_5455 registryAccess) -> (DocPage)((Pair)DocPage.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)data).getOrThrow(s -> new DecoderException("could not decode wiki info" + s))).getFirst(), (boolean isClient, class_2960 path, T data, class_5455 registryAccess) -> DocPage.setupLookup(data), 0.0f);
        ReloadHelpers.registerReloadHandler(ReloadEvents.MAIN, "miapi/skins/module", SkinOptions.skins, (boolean isClient, class_2960 path, String data, class_5455 registryAccess) -> SkinOptions.load(path, data), 1.0f);
        ReloadHelpers.registerReloadHandler(ReloadEvents.MAIN, "miapi/skins/tab", SkinOptions.tabMap, (boolean isClient, class_2960 path, String data, class_5455 registryAccess) -> SkinOptions.loadTabData(data), 1.0f);
        ReloadHelpers.registerReloadHandler(ReloadEvents.END, "miapi/create_options", (Boolean isClient) -> CreateItemOption.createAbleItems.clear(), (boolean isClient, class_2960 path, String data, class_5455 registryAccess) -> {
            if (isClient) {
                CreateItemOption.CreateItem createItem = (CreateItemOption.CreateItem)Miapi.gson.fromJson(data, CreateItemOption.JsonCreateItem.class);
                if (createItem.getBaseModule() != null && createItem.getItem() != null) {
                    CreateItemOption.createAbleItems.add(createItem);
                } else {
                    Miapi.LOGGER.error("could not find module or item for create option " + String.valueOf(path));
                    Miapi.LOGGER.error(data);
                }
            }
        }, 0.0f);
        ReloadHelpers.registerReloadHandler(ReloadEvents.MAIN, "miapi/key_binding", true, isClient -> {}, (isClient, id, data, registryAccess) -> KeyBindManager.processKeybind(isClient, id, data), 0.0f);
        ReloadHelpers.registerReloadHandler("miapi/data_composite", DatapackComposite.DATA_COMPOSITE_REGISTRY, DatapackComposite.DATA_PACK_CODEC, 0.0f);
        ReloadHelpers.registerReloadHandler(ReloadEvents.MAIN, "miapi/material_extensions", (Boolean isClient) -> {}, (boolean isClient, class_2960 path, String data, class_5455 registryAccess) -> MaterialProperty.loadMaterialExtention(path, data, registryAccess), -1.5f);
        ReloadHelpers.registerReloadHandler("miapi/materials", () -> MaterialProperty.MATERIAL_REGISTRY.clear(), (class_2960 id, T mat) -> {
            mat.setID((class_2960)id);
            MaterialProperty.MATERIAL_REGISTRY.register((class_2960)id, (Material)mat);
        }, CodecMaterial.CODEC, -2.0f);
        ReloadHelpers.registerReloadHandler(ReloadEvents.MAIN, "miapi/modular_converter", ItemToModularConverter.regexes, (boolean isClient, class_2960 path, String data, class_5455 registryAccess) -> ItemToModularConverter.setupModularConverter(path, data), 1.0f);
        ReloadHelpers.registerReloadHandler(ReloadEvents.MAIN, "miapi/blueprint", BlueprintManager.reloadedBlueprints, (boolean isClient, class_2960 id, String data, class_5455 registryAccess) -> {
            Miapi.LOGGER.info("loaded Blueprint " + String.valueOf(id));
            JsonElement element = (JsonElement)Miapi.gson.fromJson(data, JsonElement.class);
            BlueprintComponent component = (BlueprintComponent)((Pair)BlueprintComponent.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).getOrThrow()).getFirst();
            if (component.ingredient.left().isPresent() && ((Boolean)component.ingredient.left().get()).booleanValue()) {
                Miapi.LOGGER.warn("Datapack Blueprints cannot set the Ingredient to True!, either use false ur a Ingredient with count");
            } else {
                BlueprintManager.reloadedBlueprints.put(id, (BlueprintComponent)((Pair)BlueprintComponent.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).getOrThrow()).getFirst());
            }
        });
    }

    public static void registerReloadHandler(ReloadEvents.ReloadEvent event, String location, boolean syncToClient, Consumer<Boolean> beforeLoop, SingleFileHandler handler, float priority) {
        if (syncToClient) {
            ReloadEvents.registerDataPackPathToSync("miapi", location);
        }
        event.subscribe((isClient, registryAccess) -> {
            beforeLoop.accept(isClient);
            ReloadEvents.DATA_PACKS.forEach((path, data) -> {
                if (path.method_12832().startsWith(location + "/")) {
                    try {
                        handler.reloadFile(isClient, (class_2960)path, (String)data, registryAccess);
                    }
                    catch (RuntimeException e) {
                        Miapi.LOGGER.warn("could not load " + String.valueOf(path), (Throwable)e);
                    }
                }
            });
        }, priority);
    }

    public static void registerReloadHandler(ReloadEvents.ReloadEvent event, String location, Consumer<Boolean> beforeLoop, SingleFileHandler handler, float priority) {
        ReloadHelpers.registerReloadHandler(event, location, true, beforeLoop, handler, priority);
    }

    public static void registerReloadHandler(ReloadEvents.ReloadEvent event, String location, MiapiRegistry<?> toClear, SingleFileHandler handler) {
        ReloadHelpers.registerReloadHandler(event, location, true, bl -> toClear.clear(), handler, 0.0f);
    }

    public static void registerReloadHandler(ReloadEvents.ReloadEvent event, String location, MiapiRegistry<?> toClear, SingleFileHandler handler, float prio) {
        ReloadHelpers.registerReloadHandler(event, location, true, bl -> toClear.clear(), handler, prio);
    }

    public static void registerReloadHandler(ReloadEvents.ReloadEvent event, String location, Map<?, ?> toClear, SingleFileHandler handler) {
        ReloadHelpers.registerReloadHandler(event, location, true, bl -> toClear.clear(), handler, 0.0f);
    }

    public static void registerReloadHandler(ReloadEvents.ReloadEvent event, String location, Map<?, ?> toClear, SingleFileHandler handler, float prio) {
        ReloadHelpers.registerReloadHandler(event, location, true, bl -> toClear.clear(), handler, prio);
    }

    public static <T> void registerReloadHandler(String location, Map<class_2960, T> registry, Codec<T> codec, float priority) {
        ReloadHelpers.registerReloadHandler(location, registry::clear, registry::put, codec, priority);
    }

    public static <T> void registerReloadHandler(String location, MiapiRegistry<T> registry, Codec<T> codec, float priority) {
        ReloadHelpers.registerReloadHandler(location, registry::clear, registry::register, codec, priority);
    }

    public static <T> void registerReloadHandler(String location, MiapiRegistry<T> registry, SimpleDecoder<T> decoder, float prio) {
        ReloadHelpers.registerReloadHandler(location, registry::clear, decoder, (boolean isClient, class_2960 path, T data, class_5455 registryAccess) -> registry.register(path, data), prio);
    }

    public static <T> void registerReloadHandler(final String location, Runnable clear, final SimpleDecoder<T> decoder, final SingleDecodedFileHandler<T> onDecode, float prio) {
        ReloadHelpers.registerReloadHandler(ReloadEvents.MAIN, location, true, a -> {}, new SingleFileHandler(){

            @Override
            public void reloadFile(boolean isClient, class_2960 path, String data, class_5455 registryAccess) {
                try {
                    JsonElement element = (JsonElement)Miapi.gson.fromJson(data, JsonObject.class);
                    class_2960 shortened = Miapi.id(path.toString().replace(":" + location + "/", ":").replace(".json", ""));
                    Object decoded = decoder.decode(isClient, shortened, element, registryAccess);
                    onDecode.reloadFile(isClient, shortened, decoded, registryAccess);
                }
                catch (RuntimeException e) {
                    Miapi.LOGGER.error("could not decode " + String.valueOf(path) + " for full-path " + String.valueOf(path), (Throwable)e);
                    Miapi.LOGGER.error("raw data :");
                    Miapi.LOGGER.error(data);
                }
            }
        }, prio);
        ReloadEvents.START.subscribe((isClient, registryAccess) -> clear.run());
    }

    public static <T> void registerReloadHandler(String location, Runnable clear, BiConsumer<class_2960, T> onDecode, Codec<T> codec, float priority) {
        CodecOptimisedFileHandler<Object> handler = new CodecOptimisedFileHandler<Object>(codec, (isClient, path, data, registryAccess) -> {
            class_2960 shortened = Miapi.id(path.toString().replace(":" + location + "/", ":").replace(".json", ""));
            onDecode.accept(shortened, data);
        }, location);
        ReloadHelpers.registerReloadHandler(ReloadEvents.MAIN, location, true, a -> {}, handler, priority);
        ReloadEvents.START.subscribe((isClient, registryAccess) -> clear.run());
    }

    public static interface SimpleDecoder<T> {
        public T decode(boolean var1, class_2960 var2, JsonElement var3, class_5455 var4) throws DecoderException;
    }

    @FunctionalInterface
    public static interface SingleDecodedFileHandler<T> {
        public void reloadFile(boolean var1, class_2960 var2, T var3, class_5455 var4);
    }

    @FunctionalInterface
    public static interface SingleFileHandler {
        public void reloadFile(boolean var1, class_2960 var2, String var3, class_5455 var4);
    }

    public record CodecOptimisedFileHandler<T>(Codec<T> codec, SingleDecodedFileHandler<T> handler, String path) implements SingleFileHandler
    {
        @Override
        public void reloadFile(boolean isClient, class_2960 path, String data, class_5455 registryAccess) {
            try {
                DataResult result = this.codec().decode((DynamicOps)class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)registryAccess), (Object)((JsonElement)Miapi.gson.fromJson(data, JsonElement.class)));
                this.handler().reloadFile(isClient, path, ((Pair)result.getOrThrow(s -> new DecoderException("Could not decode " + String.valueOf(path) + " " + s))).getFirst(), registryAccess);
            }
            catch (RuntimeException e) {
                Miapi.LOGGER.error("could not decode " + this.path() + " for full-path " + String.valueOf(path), (Throwable)e);
                Miapi.LOGGER.error("raw data :");
                Miapi.LOGGER.error(data);
            }
        }
    }
}

