/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.editor.registry;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import imgui.ImGui;
import imgui.type.ImBoolean;
import imgui.type.ImString;
import java.util.Map;
import net.minecraft.class_2960;
import smartin.miapi.Miapi;
import smartin.miapi.editor.registry.RegistryViewer;
import smartin.miapi.modules.properties.util.ModuleProperty;
import smartin.miapi.registries.RegistryInventory;

public class PropertyRegistryViewer
extends RegistryViewer<ModuleProperty> {
    private final ImBoolean showTestEditor = new ImBoolean(false);
    private final ImString testJson = new ImString(1024);
    private final ImString testResult = new ImString(1024);
    private final ImBoolean testSuccess = new ImBoolean(false);

    public PropertyRegistryViewer() {
        super(RegistryInventory.MODULE_PROPERTY_MIAPI_REGISTRY);
        this.testJson.set("{\n  \"test\": \"value\"\n}");
    }

    @Override
    protected String getWindowTitle() {
        return "Property Registry";
    }

    @Override
    protected void renderEntry(Map.Entry<class_2960, ModuleProperty> entry) {
        super.renderEntry(entry);
        if (ImGui.isItemClicked()) {
            this.showTestEditor.set(true);
            this.selectedValue = entry.getValue();
            this.selectedEntry.set(entry.getKey().toString());
        }
    }

    @Override
    protected void renderDetails(ModuleProperty property) {
        ImGui.text((String)("Property: " + this.selectedEntry.get()));
        ImGui.text((String)("Type: " + property.getClass().getSimpleName()));
        if (ImGui.button((String)"Test Property")) {
            this.showTestEditor.set(true);
        }
        if (this.showTestEditor.get()) {
            this.renderTestEditor(property);
        }
    }

    private void renderTestEditor(ModuleProperty property) {
        ImGui.setNextWindowSize((float)400.0f, (float)300.0f, (int)4);
        if (ImGui.begin((String)("Test Property: " + this.selectedEntry.get()), (ImBoolean)this.showTestEditor)) {
            ImGui.text((String)"Enter JSON to test property parsing:");
            if (ImGui.inputTextMultiline((String)"##testJson", (ImString)this.testJson, (float)(ImGui.getWindowWidth() - ImGui.getStyle().getWindowPaddingX() * 2.0f), (float)100.0f, (int)1024)) {
                this.testProperty(property);
            }
            ImGui.separator();
            if (this.testSuccess.get()) {
                ImGui.textColored((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f, (String)"Test successful!");
            } else {
                ImGui.textColored((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f, (String)"Test failed!");
            }
            ImGui.text((String)"Result:");
            ImGui.inputTextMultiline((String)"##testResult", (ImString)this.testResult, (float)(ImGui.getWindowWidth() - ImGui.getStyle().getWindowPaddingX() * 2.0f), (float)100.0f, (int)16384);
            if (ImGui.button((String)"Close")) {
                this.showTestEditor.set(false);
            }
        }
        ImGui.end();
    }

    private void testProperty(ModuleProperty property) {
        try {
            JsonElement json = JsonParser.parseString((String)this.testJson.get());
            if (property.load(Miapi.id("runtime_test"), json, true)) {
                Object result = property.decode(json);
                this.testResult.set(result != null ? result.toString() : "null");
                this.testSuccess.set(true);
            }
            this.testResult.set("property does not want to be loaded!\u00b0");
            this.testSuccess.set(false);
        }
        catch (Exception e) {
            this.testResult.set("Error: " + e.getMessage());
            this.testSuccess.set(false);
        }
    }
}

