/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.entity;

import dev.architectury.event.EventResult;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1538;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1744;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3483;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9109;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.entity.arrowhitbehaviours.EntityBounceBehaviour;
import smartin.miapi.entity.arrowhitbehaviours.EntityPierceBehaviour;
import smartin.miapi.entity.arrowhitbehaviours.ProjectileHitBehaviour;
import smartin.miapi.events.MiapiProjectileEvents;
import smartin.miapi.mixin.AbstractArrowAccessor;
import smartin.miapi.modules.abilities.util.WrappedSoundEvent;
import smartin.miapi.modules.properties.attributes.AttributeUtil;
import smartin.miapi.modules.properties.projectile.AirDragProperty;
import smartin.miapi.modules.properties.projectile.ChannelingProperty;
import smartin.miapi.modules.properties.projectile.MakesImpactSoundProperty;
import smartin.miapi.registries.RegistryInventory;

public class ItemProjectileEntity
extends class_1665 {
    public static final class_2940<Byte> LOYALTY = class_2945.method_12791(ItemProjectileEntity.class, (class_2941)class_2943.field_13319);
    public static final class_2940<Boolean> ENCHANTED = class_2945.method_12791(ItemProjectileEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<Boolean> SPEED_DAMAGE = class_2945.method_12791(ItemProjectileEntity.class, (class_2941)class_2943.field_13323);
    public static final class_2940<class_1799> THROWING_STACK = class_2945.method_12791(ItemProjectileEntity.class, (class_2941)class_2943.field_13322);
    public static final class_2940<class_1799> BOW_ITEM_STACK = class_2945.method_12791(ItemProjectileEntity.class, (class_2941)class_2943.field_13322);
    public static final class_2940<Float> WATER_DRAG = class_2945.method_12791(ItemProjectileEntity.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Integer> PREFERRED_SLOT = class_2945.method_12791(ItemProjectileEntity.class, (class_2941)class_2943.field_13327);
    public class_1799 thrownStack = class_1799.field_8037;
    protected boolean dealtDamage;
    public int returnTimer;
    public float waterDrag = 0.99f;
    public WrappedSoundEvent hitEntitySound = new WrappedSoundEvent(this.method_7440(), 1.0f, 1.0f);
    public ProjectileHitBehaviour projectileHitBehaviour = new EntityBounceBehaviour();

    public ItemProjectileEntity(class_1299<? extends class_1297> entityType, class_1937 world) {
        super(entityType, world);
    }

    public ItemProjectileEntity(class_1937 world, class_2374 position, class_1799 itemStack) {
        super(RegistryInventory.registeredItemProjectileType, world);
        class_1799 stack = itemStack.method_7972();
        stack.method_7939(1);
        this.thrownStack = stack;
        this.field_6011.method_12778(THROWING_STACK, (Object)this.thrownStack);
        this.field_6011.method_12778(LOYALTY, (Object)this.getLoyaltyFromItem(stack));
        this.field_6011.method_12778(ENCHANTED, (Object)stack.method_7958());
        this.method_5982();
        this.setup();
    }

    public ItemProjectileEntity(class_1937 world, class_1309 owner, class_1799 itemStack, class_1799 weapon) {
        super(RegistryInventory.registeredItemProjectileType, owner, world, itemStack, weapon);
        class_1799 stack = itemStack.method_7972();
        stack.method_7939(1);
        this.thrownStack = stack.method_7972();
        this.field_6011.method_12778(LOYALTY, (Object)this.getLoyaltyFromItem(stack));
        this.field_6011.method_12778(ENCHANTED, (Object)stack.method_7958());
        this.field_6011.method_12778(THROWING_STACK, (Object)this.thrownStack);
        this.field_6011.method_12778(BOW_ITEM_STACK, (Object)weapon);
        this.field_6011.method_12778(WATER_DRAG, (Object)Float.valueOf(this.waterDrag));
        this.field_6011.method_12778(SPEED_DAMAGE, (Object)true);
        this.field_6011.method_12778(PREFERRED_SLOT, (Object)-1);
        if (this.getBowItem().method_7960() && owner != null) {
            this.setBowItem(owner.method_6030());
        }
        this.setup();
        ((MiapiProjectileEvents.ItemProjectileDataTracker)MiapiProjectileEvents.MODULAR_PROJECTILE_DATA_TRACKER_SET.invoker()).dataTracker(this, this.method_5841());
    }

    private void setup() {
        class_1799 projectileStack = this.method_7445();
        this.method_7438(AttributeUtil.getActualValue(projectileStack, class_1304.field_6173, (class_1320)AttributeRegistry.PROJECTILE_DAMAGE.comp_349()));
        class_1792 class_17922 = projectileStack.method_7909();
        if (class_17922 instanceof class_1744) {
            class_1744 arrowItem = (class_1744)class_17922;
            this.setSpeedDamage(true);
        }
    }

    private byte getLoyaltyFromItem(class_1799 stack) {
        class_1937 var3 = this.method_37908();
        if (var3 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)var3;
            return (byte)class_3532.method_15340((int)class_1890.method_60169((class_3218)serverLevel, (class_1799)stack, (class_1297)this), (int)0, (int)127);
        }
        return 0;
    }

    public void setPreferredSlot(int slotID) {
        this.field_6011.method_12778(PREFERRED_SLOT, (Object)slotID);
    }

    public void setBowItem(class_1799 bowItem) {
        this.field_6011.method_12778(BOW_ITEM_STACK, (Object)bowItem.method_7972());
    }

    public class_1799 getBowItem() {
        return (class_1799)this.field_6011.method_12789(BOW_ITEM_STACK);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(LOYALTY, (Object)0);
        builder.method_56912(ENCHANTED, (Object)false);
        builder.method_56912(THROWING_STACK, (Object)class_1799.field_8037);
        builder.method_56912(BOW_ITEM_STACK, (Object)class_1799.field_8037);
        builder.method_56912(WATER_DRAG, (Object)Float.valueOf(0.99f));
        builder.method_56912(SPEED_DAMAGE, (Object)true);
        builder.method_56912(PREFERRED_SLOT, (Object)0);
        ((MiapiProjectileEvents.ItemProjectileDataTrackerBuilder)MiapiProjectileEvents.MODULAR_PROJECTILE_DATA_TRACKER_INIT.invoker()).dataTracker(builder);
    }

    public boolean getSpeedDamage() {
        return (Boolean)this.field_6011.method_12789(SPEED_DAMAGE);
    }

    public void setSpeedDamage(boolean speedDamage) {
        this.field_6011.method_12778(SPEED_DAMAGE, (Object)speedDamage);
    }

    public void method_5773() {
        class_1799 asItem = this.method_7445();
        if (((MiapiProjectileEvents.ModularProjectileTick)MiapiProjectileEvents.MODULAR_PROJECTILE_TICK.invoker()).tick(this).interruptsFurtherEvaluation()) {
            return;
        }
        if (this.field_7576 > 4) {
            this.method_18799(new class_243(0.0, 0.0, 0.0));
            this.dealtDamage = true;
        }
        if (this.method_24515().method_10264() < this.method_37908().method_31607() - 50 && MiapiConfig.getServerConfig().enchants.betterLoyalty) {
            this.dealtDamage = true;
        }
        class_1297 entity = this.method_24921();
        byte loyaltyLevel = (Byte)this.field_6011.method_12789(LOYALTY);
        if (loyaltyLevel > 0 && (this.dealtDamage || this.method_7441()) && entity != null) {
            if (!this.isOwnerAlive()) {
                if (!this.method_37908().field_9236 && this.field_7572 == class_1665.class_1666.field_7593) {
                    this.method_5699(this.method_7445(), 0.1f);
                }
                this.method_31472();
            } else {
                this.method_7433(true);
                class_243 targetDir = entity.method_33571().method_1020(this.method_19538());
                this.method_23327(this.method_23317(), this.method_23318() + targetDir.field_1351 * 0.015 * (double)loyaltyLevel, this.method_23321());
                if (this.method_37908().field_9236) {
                    this.field_5971 = this.method_23318();
                }
                double speedAdjustment = 0.05 * (double)loyaltyLevel;
                this.method_18799(this.method_18798().method_1021(0.95).method_1019(targetDir.method_1029().method_1021(speedAdjustment)));
                if (this.returnTimer == 0) {
                    this.method_5783(class_3417.field_14698, 10.0f, 1.0f);
                }
                ++this.returnTimer;
            }
        }
        class_243 vec3d = this.method_18798();
        float m = (float)AirDragProperty.property.getValueSafe(asItem);
        if (this.method_5799()) {
            m = 1.0f;
        }
        this.method_18799(vec3d.method_1021((double)m));
        super.method_5773();
    }

    protected void method_7446() {
        ++this.field_6012;
        if (this.field_6012 >= 24000) {
            this.method_31472();
        }
    }

    protected boolean isOwnerAlive() {
        class_1297 entity = this.method_24921();
        if (entity != null && entity.method_5805()) {
            return !(entity instanceof class_3222) || !entity.method_7325();
        }
        return false;
    }

    public class_1799 method_57314() {
        return ((class_1799)this.field_6011.method_12789(THROWING_STACK)).method_7972();
    }

    @Nullable
    protected class_3966 method_7434(class_243 currentPosition, class_243 nextPosition) {
        return this.dealtDamage ? null : super.method_7434(currentPosition, nextPosition);
    }

    public void method_7485(double x, double y, double z, float velocity, float inaccuracy) {
        class_1799 projectileStack = this.method_7445();
        velocity = (float)Math.max(0.1, (double)velocity + AttributeUtil.getActualValue(projectileStack, class_1304.field_6173, (class_1320)AttributeRegistry.PROJECTILE_SPEED.comp_349()));
        class_243 vec3 = this.method_58645(x, y, z, velocity, inaccuracy *= (float)Math.pow(12.0, -AttributeUtil.getActualValue(projectileStack, class_1304.field_6173, (class_1320)AttributeRegistry.PROJECTILE_ACCURACY.comp_349())));
        this.method_18799(vec3);
        this.field_6007 = true;
        double d = vec3.method_37267();
        this.method_36456((float)(class_3532.method_15349((double)vec3.field_1352, (double)vec3.field_1350) * 57.2957763671875));
        this.method_36457((float)(class_3532.method_15349((double)vec3.field_1351, (double)d) * 57.2957763671875));
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
    }

    protected void method_7454(class_3966 entityHitResult) {
        class_1297 defender = entityHitResult.method_17782();
        float damage = this.getProjectileDamage();
        if (this.method_7447() > 0) {
            this.projectileHitBehaviour = new EntityPierceBehaviour();
            ((AbstractArrowAccessor)((Object)this)).callSetPierceLevel((byte)(this.method_7447() - 1));
        } else {
            this.projectileHitBehaviour = new EntityBounceBehaviour();
        }
        class_1297 owner = this.method_24921();
        MiapiProjectileEvents.ModularProjectileEntityHitEvent event = new MiapiProjectileEvents.ModularProjectileEntityHitEvent(entityHitResult, this, this.method_48923().method_48803((class_1665)this, owner), damage);
        EventResult result = ((MiapiProjectileEvents.ModularProjectileEntityHit)MiapiProjectileEvents.MODULAR_PROJECTILE_ENTITY_HIT.invoker()).hit(event);
        if (result.interruptsFurtherEvaluation()) {
            if (this.projectileHitBehaviour != null) {
                this.projectileHitBehaviour.onHit(this, entityHitResult.method_17782(), entityHitResult);
            }
            return;
        }
        damage = event.damage;
        this.dealtDamage = true;
        if (defender.method_5643(event.damageSource, (float)Math.ceil(damage))) {
            if (defender.method_5864() == class_1299.field_6091) {
                return;
            }
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                class_1890.method_60619((class_3218)serverLevel, (class_1297)defender, (class_1282)event.damageSource, (class_1799)this.method_59958());
            }
            if (defender instanceof class_1309) {
                class_1309 victim = (class_1309)defender;
                this.method_59957(victim, event.damageSource);
                this.method_7450(victim);
            }
        }
        if (ChannelingProperty.hasChanneling(this.method_7445())) {
            class_1538 lightningEntity = (class_1538)class_1299.field_6112.method_5883(this.method_37908());
            assert (lightningEntity != null);
            lightningEntity.method_29495(class_243.method_24955((class_2382)entityHitResult.method_17782().method_23312()));
            class_1297 class_12972 = this.method_24921();
            if (class_12972 instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_12972;
                lightningEntity.method_6961(serverPlayer);
            }
            this.method_37908().method_8649((class_1297)lightningEntity);
        }
        if (this.projectileHitBehaviour != null) {
            this.projectileHitBehaviour.onHit(this, entityHitResult.method_17782(), entityHitResult);
        }
        MiapiProjectileEvents.ModularProjectileEntityHitEvent postEvent = new MiapiProjectileEvents.ModularProjectileEntityHitEvent(event.entityHitResult, this, event.damageSource, damage);
        EventResult postResult = ((MiapiProjectileEvents.ModularProjectileEntityHit)MiapiProjectileEvents.MODULAR_PROJECTILE_ENTITY_POST_HIT.invoker()).hit(postEvent);
        if (postResult.interruptsFurtherEvaluation()) {
            return;
        }
        this.method_5783(this.hitEntitySound.event(), this.hitEntitySound.volume(), this.hitEntitySound.pitch());
    }

    public class_1799 method_7445() {
        class_1799 stack = (class_1799)this.field_6011.method_12789(THROWING_STACK);
        if (stack != null && !stack.method_7960()) {
            return stack;
        }
        return class_1799.field_8037;
    }

    protected void method_24920(class_3965 blockHitResult) {
        if (((MiapiProjectileEvents.ModularProjectileBlockHit)MiapiProjectileEvents.MODULAR_PROJECTILE_BLOCK_HIT.invoker()).hit(new MiapiProjectileEvents.ModularProjectileBlockHitEvent(blockHitResult, this)).interruptsFurtherEvaluation()) {
            if (this.projectileHitBehaviour != null) {
                this.projectileHitBehaviour.onBlockHit(this, blockHitResult);
            }
            return;
        }
        if (this.projectileHitBehaviour != null) {
            this.projectileHitBehaviour.onBlockHit(this, blockHitResult);
        }
        super.method_24920(blockHitResult);
    }

    protected void method_7488(class_239 result) {
        this.hitEntitySound = new WrappedSoundEvent(this.method_7440(), 1.0f, 1.0f);
        ((AbstractArrowAccessor)((Object)this)).setSoundEvent(this.hitEntitySound.event());
        class_239.class_240 hitresult$type = result.method_17783();
        boolean makeEvent = MakesImpactSoundProperty.property.isTrue(this.method_7445());
        if (hitresult$type == class_239.class_240.field_1331) {
            class_3966 entityhitresult = (class_3966)result;
            class_1297 entity = entityhitresult.method_17782();
            if (entity.method_5864().method_20210(class_3483.field_51503) && entity instanceof class_1676) {
                class_1676 projectile = (class_1676)entity;
                projectile.method_59859(class_9109.field_51509, this.method_24921(), this.method_24921(), true);
            }
            this.method_7454(entityhitresult);
            this.method_7445();
            if (makeEvent) {
                this.method_37908().method_32888((class_6880)class_5712.field_28162, result.method_17784(), class_5712.class_7397.method_43286((class_1297)this, (class_2680)null));
            }
        } else if (hitresult$type == class_239.class_240.field_1332) {
            class_3965 blockhitresult = (class_3965)result;
            this.method_24920(blockhitresult);
            class_2338 blockpos = blockhitresult.method_17777();
            if (makeEvent) {
                this.method_37908().method_43276((class_6880)class_5712.field_28162, blockpos, class_5712.class_7397.method_43286((class_1297)this, (class_2680)this.method_37908().method_8320(blockpos)));
            }
        }
    }

    public float getProjectileDamage() {
        float damage = (float)this.method_7448();
        if (this.getSpeedDamage()) {
            float speed = (float)this.method_18798().method_1033();
            damage = (float)class_3532.method_15350((double)((double)speed * (double)damage), (double)0.0, (double)2.147483647E9);
        }
        return damage;
    }

    protected boolean method_34713(class_1657 player) {
        int slotId = (Integer)this.field_6011.method_12789(PREFERRED_SLOT);
        if (((MiapiProjectileEvents.PlayerPickupEvent)MiapiProjectileEvents.MODULAR_PROJECTILE_PICK_UP.invoker()).pickup(player, this).interruptsFurtherEvaluation()) {
            return false;
        }
        switch (this.field_7572) {
            case field_7592: {
                return false;
            }
            case field_7594: {
                if (this.getLoyaltyFromItem(this.method_7445()) > 0 && this.method_34714((class_1297)player)) {
                    return true;
                }
                return player.method_31549().field_7477;
            }
            case field_7593: {
                boolean hasLoyalty;
                boolean bl = hasLoyalty = (Byte)this.field_6011.method_12789(LOYALTY) > 0;
                if (hasLoyalty && this.method_24921() != null && !this.method_34714((class_1297)player)) {
                    return false;
                }
                if (slotId == -2 && player.method_6079().method_7960()) {
                    player.method_31548().field_7544.set(0, (Object)this.method_7445());
                    player.method_31548().method_5431();
                    return true;
                }
                if (slotId >= 0 && player.method_31548().method_5438(slotId).method_7960()) {
                    return player.method_31548().method_7367(slotId, this.method_7445());
                }
                return player.method_31548().method_7394(this.method_7445());
            }
        }
        return super.method_34713(player) || this.method_7441() && this.method_34714((class_1297)player) && player.method_31548().method_7394(this.method_7445());
    }

    public void setDamageToDeal(boolean hasDamage) {
        this.dealtDamage = !hasDamage;
    }

    protected class_3414 method_7440() {
        boolean makeEvent = MakesImpactSoundProperty.property.isTrue(this.method_7445());
        if (!makeEvent) {
            return class_3417.field_42593;
        }
        return class_3417.field_15104;
    }

    public void method_5694(class_1657 player) {
        super.method_5694(player);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10573("ThrownItem", 10)) {
            this.thrownStack = (class_1799)class_1799.method_57360((class_7225.class_7874)this.method_56673(), (class_2520)nbt.method_10562("ThrownItem")).get();
            this.field_6011.method_12778(THROWING_STACK, (Object)this.thrownStack);
        } else {
            this.thrownStack = class_1799.field_8037;
            this.field_6011.method_12778(THROWING_STACK, (Object)class_1799.field_8037);
        }
        if (nbt.method_10573("BowItem", 10)) {
            class_1799 bowItem = (class_1799)class_1799.method_57360((class_7225.class_7874)this.method_56673(), (class_2520)nbt.method_10562("BowItem")).get();
            this.field_6011.method_12778(BOW_ITEM_STACK, (Object)bowItem);
        } else {
            this.field_6011.method_12778(BOW_ITEM_STACK, (Object)class_1799.field_8037);
        }
        if (nbt.method_10545("WaterDrag")) {
            this.field_6011.method_12778(WATER_DRAG, (Object)Float.valueOf(nbt.method_10583("WaterDrag")));
        }
        if (nbt.method_10545("SpeedDamage")) {
            this.field_6011.method_12778(SPEED_DAMAGE, (Object)nbt.method_10577("SpeedDamage"));
        }
        if (nbt.method_10545("PreferredSlot")) {
            this.field_6011.method_12778(PREFERRED_SLOT, (Object)nbt.method_10550("PreferredSlot"));
        }
        this.dealtDamage = nbt.method_10577("DealtDamage");
        this.field_6011.method_12778(LOYALTY, (Object)this.getLoyaltyFromItem(this.thrownStack));
        ((MiapiProjectileEvents.ItemProjectileCompound)MiapiProjectileEvents.MODULAR_PROJECTILE_NBT_READ.invoker()).nbtEvent(this, nbt, this.method_56673());
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        if (!this.thrownStack.method_7960()) {
            nbt.method_10566("ThrownItem", this.thrownStack.method_57376((class_7225.class_7874)this.method_56673(), (class_2520)new class_2487()));
        }
        if (!this.getBowItem().method_7960()) {
            nbt.method_10566("BowItem", this.getBowItem().method_57376((class_7225.class_7874)this.method_56673(), (class_2520)new class_2487()));
        }
        nbt.method_10556("DealtDamage", this.dealtDamage);
        nbt.method_10548("WaterDrag", ((Float)this.field_6011.method_12789(WATER_DRAG)).floatValue());
        nbt.method_10556("SpeedDamage", ((Boolean)this.field_6011.method_12789(SPEED_DAMAGE)).booleanValue());
        nbt.method_10569("PreferredSlot", ((Integer)this.field_6011.method_12789(PREFERRED_SLOT)).intValue());
        ((MiapiProjectileEvents.ItemProjectileCompound)MiapiProjectileEvents.MODULAR_PROJECTILE_NBT_WRITE.invoker()).nbtEvent(this, nbt, this.method_56673());
    }

    protected float method_7436() {
        return this.waterDrag;
    }

    public boolean method_5727(double cameraX, double cameraY, double cameraZ) {
        return true;
    }

    public boolean equals(Object other) {
        return super.equals(other);
    }
}

