/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.item.modular;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3665;
import net.minecraft.class_4587;
import net.minecraft.class_4590;
import net.minecraft.class_804;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import smartin.miapi.Miapi;

@JsonAdapter(value=TransformJsonAdapter.class)
public class Transform {
    @CodecBehavior.Optional
    public String origin;
    @CodecBehavior.Optional
    public Vector3f rotation;
    @CodecBehavior.Optional
    public Vector3f translation;
    @CodecBehavior.Optional
    public Vector3f scale;
    public static final Codec<Vector3f> VECTOR_CODEC = Codec.withAlternative((Codec)AutoCodec.of(Vector3f.class).codec(), (Codec)Codec.list((Codec)Codec.DOUBLE).xmap(list -> new Vector3f(((Double)list.getFirst()).floatValue(), ((Double)list.get(1)).floatValue(), ((Double)list.get(2)).floatValue()), vector -> List.of(Double.valueOf(vector.x()), Double.valueOf(vector.y()), Double.valueOf(vector.z()))));
    public static final Codec<Transform> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VECTOR_CODEC.optionalFieldOf("rotation", (Object)new Vector3f()).forGetter(transform -> transform.rotation), (App)VECTOR_CODEC.optionalFieldOf("translation", (Object)new Vector3f()).forGetter(transform -> transform.translation), (App)VECTOR_CODEC.optionalFieldOf("scale", (Object)new Vector3f()).forGetter(transform -> transform.scale), (App)Codec.STRING.optionalFieldOf("origin").forGetter(transform -> Optional.ofNullable(transform.origin))).apply((Applicative)instance, Transform::new));
    public static final Transform IDENTITY = new Transform(new Vector3f(), new Vector3f(), new Vector3f(1.0f, 1.0f, 1.0f));

    public Transform(Vector3f rotation, Vector3f translation, Vector3f scale) {
        this.rotation = new Vector3f((Vector3fc)rotation);
        this.translation = new Vector3f((Vector3fc)translation);
        this.scale = new Vector3f((Vector3fc)scale);
    }

    public Transform(Vector3f rotation, Vector3f translation, Vector3f scale, Optional<String> origin) {
        this(rotation, translation, scale);
        origin.ifPresent(string -> {
            this.origin = string;
        });
    }

    @Environment(value=EnvType.CLIENT)
    public Transform(class_804 transformation) {
        this.rotation = new Vector3f((Vector3fc)transformation.field_4287);
        this.translation = new Vector3f((Vector3fc)transformation.field_4286);
        this.scale = new Vector3f((Vector3fc)transformation.field_4285);
    }

    public Transform merge(Transform child) {
        return Transform.merge(this, child);
    }

    @Environment(value=EnvType.CLIENT)
    public class_804 toTransformation() {
        return new class_804(new Vector3f((Vector3fc)this.rotation), new Vector3f((Vector3fc)new Vector3f((Vector3fc)this.translation).div(16.0f)), new Vector3f((Vector3fc)this.scale));
    }

    public static Transform merge(Transform parent, Transform originalChild) {
        Transform child = originalChild.copy();
        parent = parent.copy();
        Matrix4f parentMatrix = parent.toMatrix();
        Matrix4f childMatrix = child.toMatrix();
        childMatrix.mul((Matrix4fc)parentMatrix);
        Transform merged = Transform.fromMatrix(childMatrix);
        float rotation = merged.rotation.y;
        if (Float.isNaN(rotation)) {
            Miapi.LOGGER.info("FAILURE " + rotation);
        }
        return merged;
    }

    public static void applyPosition(class_4587 matrixStack, Matrix4f matrix4f) {
        matrixStack.method_34425(matrix4f);
    }

    public static void applyPosition(class_4587 matrixStack, Transform transform) {
        Transform.applyPosition(matrixStack, transform.toMatrix());
    }

    public void applyPosition(class_4587 matrixStack) {
        Transform.applyPosition(matrixStack, this);
    }

    public Matrix4f toMatrix() {
        Matrix4f translationMatrix = new Matrix4f().translate((Vector3fc)this.translation);
        Matrix4f rotationMatrix = new Matrix4f().rotateX((float)Math.toRadians(this.rotation.x)).rotateY((float)Math.toRadians(this.rotation.y)).rotateZ((float)Math.toRadians(this.rotation.z));
        Matrix4f scaleMatrix = new Matrix4f().scale((Vector3fc)this.scale);
        return new Matrix4f().mul((Matrix4fc)translationMatrix).mul((Matrix4fc)rotationMatrix).mul((Matrix4fc)scaleMatrix);
    }

    public static Transform fromMatrix(Matrix4f matrix) {
        Vector3f translation = new Vector3f();
        matrix.getTranslation(translation);
        Matrix4f rotationMatrix = new Matrix4f((Matrix4fc)matrix);
        rotationMatrix.normalize3x3();
        Vector3f rotation = rotationMatrix.getEulerAnglesXYZ(new Vector3f());
        rotation.x = (float)Math.toDegrees(rotation.x());
        rotation.y = (float)Math.toDegrees(rotation.y());
        rotation.z = (float)Math.toDegrees(rotation.z());
        Vector3f scale = matrix.getScale(new Vector3f());
        return new Transform(rotation, translation, scale);
    }

    public Transform copy() {
        Transform copy = new Transform(this.rotation != null ? new Vector3f((Vector3fc)this.rotation) : new Vector3f(0.0f, 0.0f, 0.0f), this.translation != null ? new Vector3f((Vector3fc)this.translation) : new Vector3f(0.0f, 0.0f, 0.0f), this.scale != null ? new Vector3f((Vector3fc)this.scale) : new Vector3f(1.0f, 1.0f, 1.0f));
        copy.origin = this.origin;
        return copy;
    }

    public static Transform repair(Transform transformation) {
        Vector3f parentScale;
        Vector3f parentTranslation;
        Vector3f parentRotation = transformation.rotation;
        if (parentRotation == null) {
            parentRotation = new Vector3f(0.0f, 0.0f, 0.0f);
        }
        if ((parentTranslation = transformation.translation) == null) {
            parentTranslation = new Vector3f(0.0f, 0.0f, 0.0f);
        }
        if ((parentScale = transformation.scale) == null) {
            parentScale = new Vector3f(1.0f, 1.0f, 1.0f);
        }
        return new Transform(new Vector3f((Vector3fc)parentRotation), new Vector3f((Vector3fc)parentTranslation), new Vector3f((Vector3fc)parentScale)).withOrigin(transformation.origin);
    }

    public Transform withOrigin(String origin) {
        this.origin = origin;
        return this;
    }

    public static Transform toModelTransformation(Transform transformation) {
        Transform transform = Transform.repair(transformation);
        transform.translation.mul(0.0625f);
        return transform;
    }

    @Environment(value=EnvType.CLIENT)
    public class_4590 toAffineTransformation() {
        Transform transform = this.copy();
        Quaternionf quaternionf = new Quaternionf();
        quaternionf.rotationXYZ((float)Math.toRadians(this.rotation.x), (float)Math.toRadians(this.rotation.y), (float)Math.toRadians(this.rotation.z));
        Vector3f translationVector = new Vector3f((Vector3fc)transform.translation);
        Vector3f scaleVector = new Vector3f((Vector3fc)transform.scale);
        return new class_4590(translationVector, quaternionf, scaleVector, quaternionf);
    }

    public int[] rotateVertexData(int[] vertexData) {
        for (int i = 0; i < vertexData.length; i += 8) {
            float x = Float.intBitsToFloat(vertexData[i]);
            float y = Float.intBitsToFloat(vertexData[i + 1]);
            float z = Float.intBitsToFloat(vertexData[i + 2]);
            Vector4f position = new Vector4f(x, y, z, 1.0f);
            Vector4f transformedPosition = this.toMatrix().transform(position);
            float transformedX = transformedPosition.x;
            float transformedY = transformedPosition.y;
            float transformedZ = transformedPosition.z;
            vertexData[i] = Float.floatToIntBits(transformedX);
            vertexData[i + 1] = Float.floatToIntBits(transformedY);
            vertexData[i + 2] = Float.floatToIntBits(transformedZ);
        }
        return vertexData;
    }

    @Environment(value=EnvType.CLIENT)
    public class_3665 toModelBakeSettings() {
        Transform transform = Transform.toModelTransformation(this);
        final class_4590 affineTransformation = transform.toAffineTransformation();
        return new class_3665(){

            @NotNull
            public class_4590 method_3509() {
                return affineTransformation;
            }

            public boolean method_3512() {
                return false;
            }
        };
    }

    public String toString() {
        Gson gson = new Gson();
        return gson.toJson((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        Transform transformation = (Transform)o;
        return this.rotation.equals((Object)transformation.rotation) && this.scale.equals((Object)transformation.scale) && this.translation.equals((Object)transformation.translation);
    }

    public int hashCode() {
        int i = this.rotation.hashCode();
        i = 31 * i + this.translation.hashCode();
        i = 31 * i + this.scale.hashCode();
        return i;
    }

    public static class TransformJsonAdapter
    extends TypeAdapter<Transform> {
        public void write(JsonWriter jsonWriter, Transform transform) throws IOException {
            jsonWriter.beginObject();
            jsonWriter.name("origin").value(transform.origin);
            TransformJsonAdapter.writeVector3f(jsonWriter, "rotation", transform.rotation);
            TransformJsonAdapter.writeVector3f(jsonWriter, "translation", transform.translation);
            TransformJsonAdapter.writeVector3f(jsonWriter, "scale", transform.scale);
            jsonWriter.endObject();
        }

        public Transform read(JsonReader jsonReader) throws IOException {
            Vector3f rotation = null;
            Vector3f translation = null;
            Vector3f scale = null;
            String origin = null;
            jsonReader.beginObject();
            while (jsonReader.hasNext()) {
                String name = jsonReader.nextName();
                if ("origin".equals(name)) {
                    origin = jsonReader.nextString();
                    continue;
                }
                if ("rotation".equals(name)) {
                    rotation = TransformJsonAdapter.readVector3f(jsonReader);
                    continue;
                }
                if ("translation".equals(name)) {
                    translation = TransformJsonAdapter.readVector3f(jsonReader);
                    continue;
                }
                if ("scale".equals(name)) {
                    scale = TransformJsonAdapter.readVector3f(jsonReader);
                    continue;
                }
                jsonReader.skipValue();
            }
            jsonReader.endObject();
            if (rotation == null) {
                rotation = new Vector3f();
            }
            if (translation == null) {
                translation = new Vector3f();
            }
            if (scale == null) {
                scale = new Vector3f();
            }
            Transform transform = new Transform(rotation, translation, scale);
            transform.origin = origin;
            return transform;
        }

        private static void writeVector3f(JsonWriter jsonWriter, String name, Vector3f vector3f) throws IOException {
            jsonWriter.name(name);
            jsonWriter.beginArray();
            jsonWriter.value(vector3f.x);
            jsonWriter.value(vector3f.y);
            jsonWriter.value(vector3f.z);
            jsonWriter.endArray();
        }

        private static Vector3f readVector3f(JsonReader jsonReader) throws IOException {
            Vector3f vector3f = new Vector3f();
            if (jsonReader.peek() == JsonToken.BEGIN_ARRAY) {
                jsonReader.beginArray();
                vector3f.x = (float)jsonReader.nextDouble();
                vector3f.y = (float)jsonReader.nextDouble();
                vector3f.z = (float)jsonReader.nextDouble();
                jsonReader.endArray();
            } else if (jsonReader.peek() == JsonToken.BEGIN_OBJECT) {
                jsonReader.beginObject();
                while (jsonReader.hasNext()) {
                    String propName = jsonReader.nextName();
                    if ("x".equals(propName)) {
                        vector3f.x = (float)jsonReader.nextDouble();
                        continue;
                    }
                    if ("y".equals(propName)) {
                        vector3f.y = (float)jsonReader.nextDouble();
                        continue;
                    }
                    if (!"z".equals(propName)) continue;
                    vector3f.z = (float)jsonReader.nextDouble();
                }
                jsonReader.endObject();
            }
            return vector3f;
        }
    }
}

