/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material;

import com.google.gson.JsonElement;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.blocks.ModularWorkBenchEntity;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.crafting.crafter.replace.MaterialCraftingWidget;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.craft.CraftAction;
import smartin.miapi.craft.MaterialCraftInfo;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.DurabilityProperty;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.CraftingProperty;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public class AllowedMaterial
extends CodecProperty<AllowedMaterialData>
implements CraftingProperty,
MaterialCraftInfo {
    public static final class_2960 KEY = Miapi.id("allowed_material");
    public static AllowedMaterial property;
    public double materialCostClient = 0.0;
    public double materialRequirementClient = 0.0;
    public boolean wrongMaterial = false;
    public boolean smithingMaterial = false;
    public int slotHeight = 116;

    public AllowedMaterial() {
        super(AutoCodec.of(AllowedMaterialData.class).codec());
        property = this;
    }

    public List<String> getAllowedKeys(ItemModule module) {
        Optional optional = this.getData(module);
        if (optional.isPresent()) {
            return ((AllowedMaterialData)optional.get()).allowedMaterials;
        }
        return new ArrayList<String>();
    }

    public List<Material> getMaterials(String key) {
        return MaterialProperty.MATERIAL_REGISTRY.getFlatMap().values().stream().filter(a -> a.getGroups().contains(key)).collect(Collectors.toList());
    }

    @Override
    public List<class_241> getSlotPositions() {
        ArrayList<class_241> test = new ArrayList<class_241>();
        test.add(new class_241(96.0f, (float)(this.slotHeight - 12)));
        return test;
    }

    @Override
    public boolean shouldExecuteOnCraft(@Nullable ModuleInstance module, ModuleInstance root, class_1799 stack, CraftAction craftAction) {
        JsonElement element = craftAction.data.get(KEY);
        if (element != null) {
            return element.getAsBoolean();
        }
        return CraftingProperty.super.shouldExecuteOnCraft(module, root, stack, craftAction);
    }

    @Override
    public float getPriority() {
        return -1.0f;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public InteractAbleWidget createGui(int x, int y, int width, int height, CraftAction action) {
        return new MaterialCraftingWidget(this, x, y, width, height, action);
    }

    @Override
    public class_2561 getWarning() {
        if (this.wrongMaterial) {
            if (this.smithingMaterial) {
                class_2561.method_43471((String)"miapi.ui.craft.warning.material.wrong.smithing");
            }
            return class_2561.method_43471((String)"miapi.ui.craft.warning.material.wrong");
        }
        return class_2561.method_43471((String)"miapi.ui.craft.warning.material");
    }

    @Override
    public boolean canPerform(class_1799 old, class_1799 crafting, ModularWorkBenchEntity bench, class_1657 player, CraftAction craftAction, ItemModule module, List<class_1799> inventory, Map<class_2960, JsonElement> data) {
        Optional optional = this.getData(module);
        class_1799 input = inventory.get(0);
        if (optional.isPresent()) {
            AllowedMaterialData json = (AllowedMaterialData)optional.get();
            Material material = MaterialProperty.getMaterialFromIngredient(input);
            this.materialRequirementClient = json.cost * (float)crafting.method_7947();
            if (material != null) {
                boolean isAllowed = json.isValid(material);
                boolean bl = this.wrongMaterial = !isAllowed;
                if (isAllowed) {
                    this.materialCostClient = (double)input.method_7947() * material.getValueOfItem(input);
                    return this.materialCostClient >= this.materialRequirementClient;
                }
                this.materialCostClient = 0.0;
                this.smithingMaterial = material.getGroups().contains("smithing");
            } else {
                this.smithingMaterial = false;
                this.wrongMaterial = false;
                this.materialCostClient = 0.0;
            }
            return false;
        }
        this.wrongMaterial = false;
        return true;
    }

    @Override
    public class_1799 preview(class_1799 old, class_1799 crafting, class_1657 player, ModularWorkBenchEntity bench, CraftAction craftAction, ItemModule module, List<class_1799> inventory, Map<class_2960, JsonElement> data) {
        Material material;
        ModuleInstance newModule = craftAction.getModifyingModuleInstance(crafting);
        Optional optional = this.getData(module);
        class_1799 input = inventory.get(0);
        class_1799 materialStack = input.method_7972();
        if (optional.isPresent() && (material = MaterialProperty.getMaterialFromIngredient(input)) != null) {
            AllowedMaterialData json = (AllowedMaterialData)optional.get();
            boolean isAllowed = json.isValid(material);
            if (isAllowed) {
                MaterialProperty.setMaterial(newModule, material);
            }
            MiapiEvents.MaterialCraftEventData eventData = new MiapiEvents.MaterialCraftEventData(crafting, materialStack, material, newModule, craftAction);
            ((MiapiEvents.MaterialCraftEvent)MiapiEvents.MATERIAL_CRAFT_EVENT.invoker()).craft(eventData);
            crafting = eventData.crafted;
            newModule.getRoot().writeToItem(crafting);
        }
        if (crafting.method_7963() && crafting.method_7919() > 0) {
            ModuleInstance moduleInstance = craftAction.getModifyingModuleInstance(crafting);
            Double scannedDurability = DurabilityProperty.property.getValue(moduleInstance).orElse(0.0);
            int durability = (int)((double)scannedDurability.intValue() * MiapiConfig.getServerConfig().other.repairRatio);
            crafting.method_7974(crafting.method_7919() - durability);
        }
        return crafting;
    }

    @Override
    public List<class_1799> performCraftAction(class_1799 old, class_1799 crafting, class_1657 player, ModularWorkBenchEntity bench, CraftAction craftAction, ItemModule module, List<class_1799> inventory, Map<class_2960, JsonElement> data) {
        ModuleInstance newModule = craftAction.getModifyingModuleInstance(crafting);
        ArrayList<class_1799> results = new ArrayList<class_1799>();
        class_1799 input = inventory.get(0);
        class_1799 materialStack = input.method_7972();
        Optional optional = this.getData(module);
        if (optional.isEmpty()) {
            Miapi.LOGGER.error("crafting without allowed Material? this probably is a bug!");
            results.add(crafting);
            results.add(input);
            return results;
        }
        AllowedMaterialData json = (AllowedMaterialData)optional.get();
        Material material = MaterialProperty.getMaterialFromIngredient(input);
        if (material != null) {
            int newCount = (int)((double)input.method_7947() - Math.ceil((double)(json.cost * (float)crafting.method_7947()) / material.getValueOfItem(input)));
            if (!player.method_37908().method_8608()) {
                input.method_7939(newCount);
            }
            assert (newModule != null);
            MaterialProperty.setMaterial(newModule, material);
            newModule.getRoot().writeToItem(crafting);
            MiapiEvents.MaterialCraftEventData eventData = new MiapiEvents.MaterialCraftEventData(crafting, materialStack, material, newModule, craftAction);
            ((MiapiEvents.MaterialCraftEvent)MiapiEvents.MATERIAL_CRAFT_EVENT.invoker()).craft(eventData);
            crafting = eventData.crafted;
            if (crafting.method_7963()) {
                int durability = (int)((double)DurabilityProperty.property.getValue(craftAction.getModifyingModuleInstance(crafting)).orElse(0.0).intValue() * MiapiConfig.getServerConfig().other.repairRatio);
                crafting.method_7974(crafting.method_7919() - durability);
            }
        } else {
            Miapi.LOGGER.error("craft was called with no valid material?! this should not be possible. the resulting item wont be changed");
        }
        results.add(crafting);
        results.add(input);
        return results;
    }

    public static double getMaterialCost(ModuleInstance moduleInstance) {
        Optional optional = property.getData(moduleInstance);
        if (optional.isPresent()) {
            return ((AllowedMaterialData)optional.get()).cost;
        }
        return 0.0;
    }

    @Override
    public AllowedMaterialData merge(AllowedMaterialData left, AllowedMaterialData right, MergeType mergeType) {
        return MergeAble.decideLeftRight(left, right, mergeType);
    }

    @Override
    public int getSlotHeight() {
        return this.slotHeight;
    }

    @Override
    public void setSlotHeight(int newHeight) {
        this.slotHeight = newHeight;
    }

    @Override
    public double getMaterialCostClient() {
        return this.materialCostClient;
    }

    @Override
    public double getMaterialRequirementClient() {
        return this.materialRequirementClient;
    }

    public static class AllowedMaterialData {
        public List<String> allowedMaterials;
        @CodecBehavior.Optional
        public float cost = 1.0f;

        public boolean isValid(Material material) {
            return this.allowedMaterials.stream().anyMatch(allowedMaterial -> material.getGroups().contains(allowedMaterial) || material.getID().toString().equals(allowedMaterial));
        }
    }
}

