/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.event.EventResult;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_9135;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.material.JsonMaterial;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.modules.ModuleInstance;

public class ComponentMaterial
extends JsonMaterial {
    public static class_2960 KEY = Miapi.id("component_runtime_material");
    public JsonObject overWrite;
    public Material parent;
    public double cost = 1.0;
    public static MapCodec<ComponentMaterial> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.DOUBLE.optionalFieldOf("cost", (Object)1.0).forGetter(material -> material.cost), (App)StatResolver.Codecs.JSONELEMENT_CODEC.optionalFieldOf("overwrite", (Object)new JsonObject()).forGetter(material -> material.overWrite), (App)class_2960.field_25139.fieldOf("parent").forGetter(material -> material.parent.getID())).apply((Applicative)instance, (cost, json, materialKey) -> {
        Material material = MaterialProperty.MATERIAL_REGISTRY.get((class_2960)materialKey);
        return new ComponentMaterial(material, (JsonElement)json, (double)cost, Environment.isClient());
    }));
    public static class_9331<ComponentMaterial> NBT_MATERIAL_COMPONENT = class_9331.method_57873().method_57881(CODEC.codec()).method_57882(class_9135.method_56368((Codec)CODEC.codec())).method_57880();

    public ComponentMaterial(Material parent, JsonElement overwrite, double cost, boolean isClient) {
        super(KEY, parent.getDebugJson().deepCopy(), isClient);
        while (parent instanceof ComponentMaterial) {
            ComponentMaterial componentMaterial = (ComponentMaterial)parent;
            parent = componentMaterial.parent;
        }
        this.parent = parent;
        this.overWrite = overwrite.getAsJsonObject();
        this.mergeJson(overwrite, isClient);
        this.cost = cost;
    }

    public ComponentMaterial(Material parent, JsonObject overwrite, boolean isClient) {
        super(KEY, parent.getDebugJson().deepCopy(), isClient);
        while (parent instanceof ComponentMaterial) {
            ComponentMaterial componentMaterial = (ComponentMaterial)parent;
            parent = componentMaterial.parent;
        }
        this.parent = parent;
        this.overWrite = overwrite;
        this.mergeJson((JsonElement)overwrite, isClient);
    }

    @Override
    public void mergeJson(JsonElement rootElement, boolean isClient) {
        JsonObject object;
        if (rootElement.isJsonObject() && (object = rootElement.getAsJsonObject()).has("cost")) {
            this.cost = object.get("cost").getAsDouble();
        }
        super.mergeJson(rootElement, isClient);
    }

    @Override
    public class_2561 getTranslation() {
        if (this.parent == null) {
            return super.getTranslation();
        }
        return this.parent.getTranslation();
    }

    @Override
    public class_2960 getID() {
        return KEY;
    }

    public static void setup() {
        ReloadEvents.MAIN.subscribe((isClient, registryAccess) -> {
            JsonObject object = new JsonObject();
            MaterialProperty.MATERIAL_REGISTRY.register(KEY, (Material)new ComponentMaterial(new JsonMaterial(KEY, object, isClient), new JsonObject(), isClient));
        }, -1.0f);
        MiapiEvents.MATERIAL_CRAFT_EVENT.register(data -> {
            Material patt0$temp = data.material;
            if (patt0$temp instanceof ComponentMaterial) {
                ComponentMaterial componentMaterial = (ComponentMaterial)patt0$temp;
                componentMaterial.writeMaterial(data.moduleInstance);
                data.moduleInstance.getRoot().writeToItem(data.crafted);
            }
            return EventResult.pass();
        });
    }

    @Override
    public Material getMaterial(ModuleInstance moduleInstance) {
        return this;
    }

    public void writeMaterial(ModuleInstance moduleInstance) {
    }

    @Override
    public Optional<MapCodec<? extends Material>> codec() {
        return Optional.of(CODEC);
    }

    @Override
    @Nullable
    public Material getMaterialFromIngredient(class_1799 ingredient) {
        return (Material)ingredient.method_57353().method_57829(NBT_MATERIAL_COMPONENT);
    }

    public Optional<Material> decode(JsonObject object) {
        try {
            String parentID = object.get("parent").getAsString();
            Material parentMaterial = MaterialProperty.MATERIAL_REGISTRY.get(class_2960.method_60654((String)parentID));
            if (parentMaterial == null) {
                Miapi.LOGGER.error("Could not find Material:" + parentID);
                return Optional.empty();
            }
            return Optional.of(new ComponentMaterial(parentMaterial, object, Environment.isClient()));
        }
        catch (Exception e) {
            Miapi.LOGGER.error("Could not find Material", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public double getValueOfItem(class_1799 itemStack) {
        ComponentMaterial material = (ComponentMaterial)itemStack.method_57353().method_57829(NBT_MATERIAL_COMPONENT);
        if (material != null) {
            return material.cost;
        }
        return 0.0;
    }

    @Override
    public Double getPriorityOfIngredientItem(class_1799 itemStack) {
        if (itemStack.method_57353().method_57832(NBT_MATERIAL_COMPONENT)) {
            return -5.0;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ComponentMaterial other = (ComponentMaterial)obj;
        return Double.compare(other.cost, this.cost) == 0 && Objects.equals(this.overWrite, other.overWrite) && (this.parent == other.parent || this.parent != null && other.parent != null && Objects.equals(this.parent.getID(), other.parent.getID()));
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.overWrite, this.parent != null ? this.parent.getID() : null, this.cost);
    }
}

