/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material.generated;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1304;
import net.minecraft.class_131;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1738;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1810;
import net.minecraft.class_1821;
import net.minecraft.class_1829;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9285;
import net.minecraft.class_9304;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9336;
import smartin.miapi.Miapi;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.config.MiapiServerConfig;
import smartin.miapi.material.generated.GeneratedMaterialManager;
import smartin.miapi.modules.abilities.CopyItemAbility;
import smartin.miapi.modules.abilities.util.AbilityMangerProperty;
import smartin.miapi.modules.properties.ComponentProperty;
import smartin.miapi.modules.properties.CopyItemLoreProperty;
import smartin.miapi.modules.properties.FakeItemTagProperty;
import smartin.miapi.modules.properties.attributes.AttributeProperty;
import smartin.miapi.modules.properties.enchanment.CraftingEnchantProperty;
import smartin.miapi.modules.properties.onHit.CopyItemOnHit;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.ModuleProperty;

public class GeneratedMaterialPropertyManager {
    public static Map<String, Map<ModuleProperty<?>, Object>> setup(class_2960 id, class_1829 swordItem, class_1766 axeItem, List<class_1792> toolMaterials, List<class_1738> armorItems, Map<String, Map<ModuleProperty<?>, Object>> old) {
        HashMap properties = new HashMap(old);
        GeneratedMaterialPropertyManager.setupProperties((class_1792)swordItem, id, "blade", class_1802.field_8802, class_1802.field_8091, properties, null);
        GeneratedMaterialPropertyManager.setupProperties((class_1792)axeItem, id, "axe", class_1802.field_8556, class_1802.field_8406, properties, null);
        GeneratedMaterialPropertyManager.setupProperties(toolMaterials.stream().filter(class_1810.class::isInstance).findFirst(), id, "pickaxe", class_1802.field_8377, class_1802.field_8647, properties, null);
        GeneratedMaterialPropertyManager.setupProperties(toolMaterials.stream().filter(class_1821.class::isInstance).findFirst(), id, "shovel", class_1802.field_8250, class_1802.field_8876, properties, null);
        GeneratedMaterialPropertyManager.setupProperties(toolMaterials.stream().filter(class_1794.class::isInstance).findFirst(), id, "hoe", class_1802.field_8527, class_1802.field_8167, properties, null);
        GeneratedMaterialPropertyManager.setupProperties(armorItems.stream().filter(a -> GeneratedMaterialPropertyManager.isEquipment(a, class_1304.field_6169)).map(a -> a).findFirst(), id, "helmet", class_1802.field_8805, class_1802.field_8743, properties, (Integer)5);
        GeneratedMaterialPropertyManager.setupProperties(armorItems.stream().filter(a -> GeneratedMaterialPropertyManager.isEquipment(a, class_1304.field_6174)).map(a -> a).findFirst(), id, "chest", class_1802.field_8058, class_1802.field_8523, properties, (Integer)8);
        GeneratedMaterialPropertyManager.setupProperties(armorItems.stream().filter(a -> GeneratedMaterialPropertyManager.isEquipment(a, class_1304.field_6172)).map(a -> a).findFirst(), id, "pants", class_1802.field_8348, class_1802.field_8396, properties, (Integer)7);
        GeneratedMaterialPropertyManager.setupProperties(armorItems.stream().filter(a -> GeneratedMaterialPropertyManager.isEquipment(a, class_1304.field_6166)).map(a -> a).findFirst(), id, "boot", class_1802.field_8285, class_1802.field_8660, properties, (Integer)4);
        return properties;
    }

    public static boolean isEquipment(class_1738 item, class_1304 slot) {
        if (item.method_7685() == slot) {
            return true;
        }
        if (item.method_48398().method_48399() == slot) {
            return true;
        }
        if (slot == class_1304.field_6169) {
            return item.method_48398() == class_1738.class_8051.field_41934;
        }
        if (slot == class_1304.field_6174) {
            return item.method_48398() == class_1738.class_8051.field_41935;
        }
        if (slot == class_1304.field_6172) {
            return item.method_48398() == class_1738.class_8051.field_41936;
        }
        if (slot == class_1304.field_6166) {
            return item.method_48398() == class_1738.class_8051.field_41937;
        }
        return false;
    }

    private static void setupProperties(Optional<class_1792> item, class_2960 id, String type, class_1792 vanillaCompare, class_1792 vanillaCompare2, Map<String, Map<ModuleProperty<?>, Object>> properties, Integer cost) {
        item.ifPresent(i -> GeneratedMaterialPropertyManager.setupProperties(i, id, type, vanillaCompare, vanillaCompare2, properties, cost));
    }

    private static void setupProperties(class_1792 item, class_2960 id, String type, class_1792 vanillaCompare, class_1792 vanillaCompare2, Map<String, Map<ModuleProperty<?>, Object>> properties, Integer cost) {
        HashMap<CodecProperty, Object> propertyMap = new HashMap<CodecProperty, Object>();
        if (GeneratedMaterialPropertyManager.shouldApplyProperty(MiapiConfig.getServerConfig().generatedMaterials.properties.abilityProperty, id.toString())) {
            propertyMap.put(AbilityMangerProperty.property, Map.of(CopyItemAbility.ability, new CopyItemAbility.ItemContext(item)));
        }
        if (GeneratedMaterialPropertyManager.shouldApplyProperty(MiapiConfig.getServerConfig().generatedMaterials.properties.loreProperty, id.toString())) {
            propertyMap.put(CopyItemLoreProperty.property, List.of(class_7923.field_41178.method_47983((Object)item)));
        }
        if (GeneratedMaterialPropertyManager.shouldApplyProperty(MiapiConfig.getServerConfig().generatedMaterials.properties.onHitProperty, id.toString())) {
            propertyMap.put(CopyItemOnHit.property, List.of(class_7923.field_41178.method_47983((Object)item)));
        }
        if (GeneratedMaterialPropertyManager.shouldApplyProperty(MiapiConfig.getServerConfig().generatedMaterials.properties.tagProperty, id.toString())) {
            Set tagsCompare1 = vanillaCompare.method_40131().method_40228().collect(Collectors.toSet());
            Set tagsCompare2 = vanillaCompare2.method_40131().method_40228().collect(Collectors.toSet());
            Set commonTags = tagsCompare1.stream().filter(tagsCompare2::contains).collect(Collectors.toSet());
            Stream itemTags = item.method_40131().method_40228();
            List<String> uniqueTags = itemTags.filter(tag -> !commonTags.contains(tag)).map(tag -> tag.comp_327().toString()).toList();
            propertyMap.put(FakeItemTagProperty.property, uniqueTags);
        }
        if (GeneratedMaterialPropertyManager.shouldApplyProperty(MiapiConfig.getServerConfig().generatedMaterials.properties.componentProperty, id.toString())) {
            Set componentTypes = vanillaCompare.method_57347().method_57833().map(class_9336::comp_2443).collect(Collectors.toSet());
            Set commonComponents = vanillaCompare2.method_57347().method_57833().map(class_9336::comp_2443).filter(componentTypes::contains).collect(Collectors.toSet());
            HashMap components = new HashMap();
            item.method_57347().forEach(typedDataComponent -> {
                if (!commonComponents.contains(typedDataComponent.comp_2443())) {
                    class_2960 componentId = class_7923.field_49658.method_10221((Object)typedDataComponent.comp_2443());
                    JsonElement element = GeneratedMaterialPropertyManager.encode(typedDataComponent);
                    components.put(componentId, element);
                }
            });
            propertyMap.put(ComponentProperty.property, components);
        }
        if (GeneratedMaterialPropertyManager.shouldApplyProperty(MiapiConfig.getServerConfig().generatedMaterials.properties.enchantProperty, id.toString())) {
            HashMap enchantments = new HashMap();
            class_9304 itemEnchantments = (class_9304)GeneratedMaterialPropertyManager.getDefaultStack(item).method_57825(class_9334.field_49633, (Object)class_9304.field_49385);
            itemEnchantments.method_57534().forEach(enchantment -> {
                DoubleOperationResolvable resolvable = new DoubleOperationResolvable(List.of(new DoubleOperationResolvable.Operation(itemEnchantments.method_57536(enchantment), class_1322.class_1323.field_6328)));
                enchantments.put(((class_5321)enchantment.method_40230().get()).method_29177(), resolvable);
                if (GeneratedMaterialManager.verboseLogging()) {
                    Miapi.LOGGER.info("detected enchantemnt " + enchantment.method_55840() + " on " + String.valueOf(id));
                }
            });
            propertyMap.put(CraftingEnchantProperty.property, enchantments);
        }
        if (GeneratedMaterialPropertyManager.shouldApplyProperty(MiapiConfig.getServerConfig().generatedMaterials.properties.attributeProperty, id.toString())) {
            List<class_6880> firstAttributes = ((class_9285)GeneratedMaterialPropertyManager.getDefaultStack(vanillaCompare).method_57824(class_9334.field_49636)).comp_2393().stream().map(class_9285.class_9287::comp_2395).toList();
            List<class_6880> secondAttributes = ((class_9285)GeneratedMaterialPropertyManager.getDefaultStack(vanillaCompare2).method_57824(class_9334.field_49636)).comp_2393().stream().map(class_9285.class_9287::comp_2395).toList();
            List<class_9285.class_9287> modifiers = ((class_9285)GeneratedMaterialPropertyManager.getDefaultStack(item).method_57824(class_9334.field_49636)).comp_2393().stream().filter(a -> !firstAttributes.contains(a.comp_2395()) && !secondAttributes.contains(a.comp_2395())).filter(a -> a.comp_2396().comp_2450() == class_1322.class_1323.field_6328).toList();
            if (modifiers.isEmpty()) {
                modifiers = item.method_7844().comp_2393().stream().filter(a -> !firstAttributes.contains(a.comp_2395()) && !secondAttributes.contains(a.comp_2395())).filter(a -> a.comp_2396().comp_2450() == class_1322.class_1323.field_6328).toList();
            }
            HashMap attributes = new HashMap();
            modifiers.forEach(e -> {
                DoubleOperationResolvable resolvable = new DoubleOperationResolvable(List.of(new DoubleOperationResolvable.Operation(e.comp_2396().comp_2449() + "/" + cost + " * [module.cost]")));
                attributes.computeIfAbsent(class_7923.field_41190.method_10221((Object)((class_1320)e.comp_2395().comp_349())), c -> new HashMap()).computeIfAbsent(class_1322.class_1323.field_6328, c -> new HashMap()).put(Either.left((Object)e.comp_2397()), resolvable);
            });
            propertyMap.put(AttributeProperty.property, attributes);
        }
        properties.put(type, propertyMap);
    }

    public static boolean shouldApplyProperty(MiapiServerConfig.GeneratedMaterialsCategory.GeneratePropertyOption config, String idString) {
        if (!config.enable) {
            return false;
        }
        for (String regex : config.blocked) {
            if (!idString.matches(regex)) continue;
            return false;
        }
        return true;
    }

    public static class_1799 getDefaultStack(class_1792 item) {
        class_1799 itemStack = item.method_7854();
        try {
            Class<?> itemStackHelperClass = Class.forName("org.betterx.wover.item.api.ItemStackHelper");
            Method method = itemStackHelperClass.getDeclaredMethod("callItemStackSetupIfPossible", class_1799.class, class_7225.class_7874.class);
            itemStack = (class_1799)method.invoke(null, itemStack, Miapi.registryAccess);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (class_1799)class_131.field_1102.apply(itemStack, null);
    }

    public static <T> JsonElement encode(class_9336<T> typedDataComponent) {
        class_9331 componentType = typedDataComponent.comp_2443();
        Object data = typedDataComponent.comp_2444();
        return (JsonElement)componentType.method_57875().encodeStart((DynamicOps)JsonOps.INSTANCE, data).getOrThrow();
    }
}

