/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.material.palette;

import com.google.gson.JsonElement;
import com.redpxnda.nucleus.util.Color;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5253;
import net.minecraft.class_7764;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.client.MiapiClient;
import smartin.miapi.client.atlas.MaterialSpriteManager;
import smartin.miapi.client.renderer.NativeImageGetter;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.palette.FallbackColorer;
import smartin.miapi.material.palette.SpritePixelReplacer;

@Environment(value=EnvType.CLIENT)
public class PaletteAtlasBackedColorer
extends SpritePixelReplacer {
    protected class_2960 spriteId = Material.BASE_PALETTE_ID;
    protected Color averageColor;
    protected boolean isAnimated = false;
    protected NativeImageGetter.ImageHolder image;
    protected class_7764 contents;

    protected PaletteAtlasBackedColorer(Material material) {
        super(material);
    }

    public PaletteAtlasBackedColorer(Material material, class_2960 id) {
        super(material);
        this.setupSprite(id);
    }

    public PaletteAtlasBackedColorer(Material material, JsonElement json) {
        super(material);
        class_2960 id = class_2960.method_60654((String)json.getAsJsonObject().get("location").getAsString());
        this.setupSprite(id);
    }

    public static SpritePixelReplacer createColorer(Material material, JsonElement json) {
        PaletteAtlasBackedColorer colorer = new PaletteAtlasBackedColorer(material, json);
        class_1058 sprite = MiapiClient.materialAtlasManager.getMaterialSprite(colorer.getSpriteId());
        if (sprite == null) {
            Miapi.LOGGER.error("could not locate sprite " + String.valueOf(colorer.spriteId));
            return new FallbackColorer(material);
        }
        if (sprite.method_45851().method_45807() < 255) {
            Miapi.LOGGER.error("loaded sprite does not have the right dimmensions! It needs a width of 255" + sprite.method_45851().method_45807());
            return new FallbackColorer(material);
        }
        return colorer;
    }

    @Override
    public int getReplacementColor(int pixelX, int pixelY, int previousAbgr) {
        int red = class_5253.class_8045.method_48345((int)previousAbgr);
        return this.image.getColor(class_3532.method_15340((int)red, (int)0, (int)255), 0);
    }

    public void setupSprite(class_2960 id) {
        this.spriteId = id;
        class_1058 sprite = MiapiClient.materialAtlasManager.getMaterialSprite(this.getSpriteId());
        this.contents = sprite.method_45851();
        this.isAnimated = this.isAnimatedSprite(this.contents);
    }

    @Nullable
    public class_2960 getSpriteId() {
        return this.spriteId;
    }

    @Override
    public boolean doTick() {
        return this.isAnimated;
    }

    @Override
    public class_1011 transform(class_7764 originalSprite) {
        if (this.contents == null) {
            class_1058 sprite = MiapiClient.materialAtlasManager.getMaterialSprite(this.getSpriteId());
            if (sprite != null) {
                MaterialSpriteManager.markTextureAsAnimatedInUse(sprite);
                this.contents = sprite.method_45851();
            } else {
                this.contents = originalSprite;
            }
        }
        this.image = NativeImageGetter.get(this.contents);
        class_1011 result = super.transform(originalSprite);
        this.image = null;
        return result;
    }

    @Override
    public Color getAverageColor() {
        if (this.averageColor == null) {
            class_1058 sprite = MiapiClient.materialAtlasManager.getMaterialSprite(this.spriteId);
            if (sprite == null) {
                return Color.WHITE;
            }
            class_1011 img = NativeImageGetter.getImage(sprite.method_45851());
            ArrayList<Color> colors = new ArrayList<Color>();
            int height = img.method_4323();
            int width = img.method_4307();
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    int color = img.method_4315(x, y);
                    colors.add(new Color(class_5253.class_8045.method_48345((int)color), class_5253.class_8045.method_48346((int)color), class_5253.class_8045.method_48347((int)color), class_5253.class_8045.method_48342((int)color)));
                }
            }
            int red = 0;
            int green = 0;
            int blue = 0;
            int alpha = 0;
            for (Color color : colors) {
                if (color.a() <= 0) continue;
                red += color.r();
                green += color.g();
                blue += color.b();
                alpha += color.a();
            }
            this.averageColor = new Color(red / colors.size(), green / colors.size(), blue / colors.size(), alpha / colors.size());
        }
        return this.averageColor;
    }
}

