/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import com.redpxnda.nucleus.network.clientbound.ParticleCreationPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import smartin.miapi.mixin.LivingEntityAccessor;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.abilities.util.AbilityMangerProperty;
import smartin.miapi.modules.abilities.util.AttackUtil;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.abilities.util.ItemUseDefaultCooldownAbility;
import smartin.miapi.modules.abilities.util.ItemUseMinHoldAbility;
import smartin.miapi.modules.properties.LoreProperty;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.MergeType;

public class SpecialAttackAbility
implements ItemUseDefaultCooldownAbility<SpecialAttackJson>,
ItemUseMinHoldAbility<SpecialAttackJson> {
    public static Codec<SpecialAttackJson> CODEC = AutoCodec.of(SpecialAttackJson.class).codec();

    public SpecialAttackAbility() {
        LoreProperty.bottomLoreSuppliers.add(itemStack -> {
            ArrayList<class_5250> texts = new ArrayList<class_5250>();
            if (AbilityMangerProperty.isPrimaryAbility(this, itemStack)) {
                texts.add(class_2561.method_43471((String)"miapi.ability.heavy_attack.lore"));
            }
            return texts;
        });
    }

    @Override
    public boolean allowedOnItem(class_1799 itemStack, class_1937 world, class_1657 player, class_1268 hand, ItemAbilityManager.AbilityHitContext abilityHitContext) {
        return true;
    }

    @Override
    public class_1839 getUseAction(class_1799 itemStack) {
        return class_1839.field_8951;
    }

    @Override
    public int getMaxUseTime(class_1799 itemStack, class_1309 entity) {
        return 72000;
    }

    @Override
    public class_1271<class_1799> use(class_1937 world, class_1657 user, class_1268 hand) {
        if (user.method_7357().method_7904(user.method_5998(hand).method_7909())) {
            return class_1271.method_22430((Object)user.method_5998(hand));
        }
        user.method_6019(hand);
        return class_1271.method_22428((Object)user.method_5998(hand));
    }

    @Override
    public void onStoppedUsingAfter(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        SpecialAttackJson specialAttackJson = (SpecialAttackJson)this.getSpecialContext(stack);
        if (user instanceof class_1657) {
            class_1297 target2;
            class_3966 entityHitResult;
            class_1657 player = (class_1657)user;
            if ((double)(this.getMaxUseTime(stack, user) - remainingUseTicks) > specialAttackJson.minHold.getValue() && (entityHitResult = AttackUtil.raycastFromPlayer(specialAttackJson.range.evaluate(3.5, 3.5), player)) != null && (target2 = entityHitResult.method_17782()) instanceof class_1309) {
                class_1309 target = (class_1309)target2;
                ((LivingEntityAccessor)player).attacking(target);
                float damage = (float)((double)((float)player.method_45325(class_5134.field_23721)) * specialAttackJson.damage.getValue());
                float sweeping = (float)specialAttackJson.sweeping.getValue();
                AttackUtil.performAttack(player, target, damage, true, stack);
                if (sweeping > 0.0f) {
                    AttackUtil.performSweeping(player, target, sweeping, damage);
                }
                player.method_6104(player.method_6058());
                player.method_7357().method_7906(stack.method_7909(), (int)specialAttackJson.cooldown.getValue());
                class_1937 class_19372 = player.method_37908();
                if (class_19372 instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)class_19372;
                    specialAttackJson.particleEffect.forEach(particleOptions -> {
                        ParticleCreationPacket particleCreationPacket = new ParticleCreationPacket(particleOptions, player.method_23317(), player.method_23318(), player.method_23321(), 0.0, 0.0, 0.0);
                        particleCreationPacket.send(serverWorld);
                    });
                }
            }
        }
    }

    @Override
    public int getCooldown(class_1799 itemStack) {
        return (int)((SpecialAttackJson)this.getSpecialContext((class_1799)itemStack)).cooldown.getValue();
    }

    @Override
    public <K> SpecialAttackJson decode(DynamicOps<K> ops, K prefix) {
        return (SpecialAttackJson)((Pair)CODEC.decode(ops, prefix).getOrThrow()).getFirst();
    }

    @Override
    public SpecialAttackJson getDefaultContext() {
        return null;
    }

    @Override
    public SpecialAttackJson initialize(SpecialAttackJson json, ModuleInstance moduleInstance) {
        return json.initialize(moduleInstance);
    }

    @Override
    public int getMinHoldTime(class_1799 itemStack) {
        return (int)((SpecialAttackJson)this.getSpecialContext((class_1799)itemStack)).minHold.getValue();
    }

    @Override
    public SpecialAttackJson merge(SpecialAttackJson left, SpecialAttackJson right, MergeType mergeType) {
        SpecialAttackJson merged = new SpecialAttackJson();
        merged.damage = left.damage.merge(right.damage, mergeType);
        merged.sweeping = left.sweeping.merge(right.sweeping, mergeType);
        merged.range = left.range.merge(right.range, mergeType);
        merged.minHold = left.minHold.merge(right.minHold, mergeType);
        merged.cooldown = left.cooldown.merge(right.cooldown, mergeType);
        if (MergeType.EXTEND.equals((Object)mergeType)) {
            merged.description = left.description;
            merged.title = left.description;
        } else {
            merged.description = right.description;
            merged.title = right.description;
        }
        if (MergeType.OVERWRITE.equals((Object)mergeType)) {
            merged.particleEffect = right.particleEffect;
        } else {
            ArrayList<class_2394> list = new ArrayList<class_2394>(right.particleEffect);
            list.addAll(left.particleEffect);
            merged.particleEffect = list;
        }
        return merged;
    }

    public static class SpecialAttackJson {
        public DoubleOperationResolvable damage = new DoubleOperationResolvable(1.0);
        public DoubleOperationResolvable sweeping = new DoubleOperationResolvable(0.0);
        public DoubleOperationResolvable range = new DoubleOperationResolvable(3.5);
        @AutoCodec.Name(value="min_hold")
        @CodecBehavior.Optional
        public DoubleOperationResolvable minHold = new DoubleOperationResolvable(15.0);
        @CodecBehavior.Optional
        public DoubleOperationResolvable cooldown = new DoubleOperationResolvable(10.0);
        @CodecBehavior.Optional
        public class_2561 title = class_2561.method_43471((String)"miapi.ability.heavy_attack.title");
        @CodecBehavior.Optional
        public class_2561 description = class_2561.method_43471((String)"miapi.ability.heavy_attack.description");
        @CodecBehavior.Optional
        public List<class_2394> particleEffect = new ArrayList<class_2394>();

        public SpecialAttackJson initialize(ModuleInstance moduleInstance) {
            SpecialAttackJson specialAttackJson = new SpecialAttackJson();
            specialAttackJson.damage = this.damage.initialize(moduleInstance);
            specialAttackJson.sweeping = this.sweeping.initialize(moduleInstance);
            specialAttackJson.range = this.range.initialize(moduleInstance);
            specialAttackJson.minHold = this.minHold.initialize(moduleInstance);
            specialAttackJson.cooldown = this.cooldown.initialize(moduleInstance);
            specialAttackJson.title = this.title;
            specialAttackJson.description = this.description;
            specialAttackJson.particleEffect = this.particleEffect;
            return specialAttackJson;
        }
    }
}

