/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities.gun;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9331;
import smartin.miapi.Miapi;
import smartin.miapi.modules.abilities.gun.GunContextProperty;
import smartin.miapi.network.modern.ModernNetworking;

public class GunMagazineComponent {
    public static final Codec<List<class_1799>> CODEC = class_1799.field_24671.listOf();
    public static final class_9331<List<class_1799>> STACK_STORAGE_COMPONENT = class_9331.method_57873().method_57881(CODEC).method_57882(class_9135.method_56368(CODEC)).method_57880();
    public static final class_2960 PACKET_ID = Miapi.id("miapi", "c2s_hitscan_shot");

    public static void addBullet(class_1799 gun, class_1799 bullet) {
        List<class_1799> magazine = List.copyOf((Collection)gun.method_57825(STACK_STORAGE_COMPONENT, List.of()));
        magazine = new ArrayList(magazine);
        magazine.add(bullet);
        gun.method_57379(STACK_STORAGE_COMPONENT, magazine);
    }

    public static Optional<class_1799> removeBullet(class_1799 gun) {
        List magazine = List.copyOf((Collection)gun.method_57825(STACK_STORAGE_COMPONENT, List.of()));
        if (!magazine.isEmpty()) {
            magazine = new ArrayList(magazine);
            class_1799 removed = (class_1799)magazine.removeFirst();
            gun.method_57379(STACK_STORAGE_COMPONENT, magazine);
            return Optional.of(removed);
        }
        return Optional.empty();
    }

    public static int getBulletCount(class_1799 gun) {
        return ((List)gun.method_57825(STACK_STORAGE_COMPONENT, List.of())).size();
    }

    public static void emptyMagazine(class_1799 gun) {
        gun.method_57379(STACK_STORAGE_COMPONENT, List.of());
    }

    public static void shoot(class_1937 world, class_1657 player, boolean isHitscan) {
        if (isHitscan) {
            if (world.field_9236) {
                GunMagazineComponent.handleClientHitscan(player);
            }
        } else {
            GunMagazineComponent.handleProjectileShot(world, player);
        }
    }

    private static void handleClientHitscan(class_1657 player) {
        class_243 start = player.method_33571();
        class_243 look = player.method_5720();
        double range = GunContextProperty.getGunContext(player.method_6047()).range().getValue();
        class_243 end = start.method_1019(look.method_1021(range));
        class_3965 hitResult = player.method_37908().method_17742(new class_3959(start, end, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player));
        Optional<Integer> entityHit = Optional.empty();
        if (hitResult instanceof class_3966) {
            class_3966 entityHitResult = (class_3966)hitResult;
            entityHit = Optional.of(entityHitResult.method_17782().method_5628());
        }
        ModernNetworking.sendToServer(PACKET_ID, ShotPacketData.PACKET_CODEC, new ShotPacketData(hitResult.method_17784(), entityHit), player.method_37908().method_30349());
    }

    private static void handleProjectileShot(class_1937 world, class_1657 player) {
    }

    static {
        ModernNetworking.registerC2SReceiver(PACKET_ID, ShotPacketData.PACKET_CODEC, (packetData, player, access) -> {
            class_1937 world = player.method_37908();
            class_1799 weapon = player.method_59958();
            if (!world.field_9236 && GunMagazineComponent.getBulletCount(weapon) > 0) {
                double maxRange = GunContextProperty.getGunContext(weapon).range().getValue();
                class_243 shooterPos = player.method_33571();
                if (packetData.hitPosition.method_1022(shooterPos) <= maxRange) {
                    packetData.hitEntityId.ifPresent(entityID -> {
                        class_1309 target;
                        class_1297 patt0$temp = player.method_37908().method_8469(entityID.intValue());
                        if (patt0$temp instanceof class_1309 && (target = (class_1309)patt0$temp) != player) {
                            double damage = GunContextProperty.getGunContext(weapon).baseDamage().getValue();
                            Optional<class_1799> optionalBullet = GunMagazineComponent.removeBullet(weapon);
                            optionalBullet.ifPresent(bullet -> target.method_5643(player.method_48923().method_48802(player), (float)damage));
                        }
                    });
                }
            }
        });
    }

    public static class ShotPacketData {
        public final class_243 hitPosition;
        public final Optional<Integer> hitEntityId;
        public static final Codec<ShotPacketData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_243.field_38277.fieldOf("hitPosition").forGetter(data -> data.hitPosition), (App)Codec.INT.optionalFieldOf("hitEntityId").forGetter(data -> data.hitEntityId)).apply((Applicative)instance, ShotPacketData::new));
        public static final class_9139<class_9129, ShotPacketData> PACKET_CODEC = class_9135.method_56896(CODEC);

        public ShotPacketData(class_243 hitPosition, Optional<Integer> hitEntityId) {
            this.hitPosition = hitPosition;
            this.hitEntityId = hitEntityId;
        }
    }
}

