/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities.gun;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.redpxnda.nucleus.pose.server.ServerPoseFacet;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_7924;
import smartin.miapi.Miapi;
import smartin.miapi.modules.abilities.gun.GunMagazineComponent;
import smartin.miapi.modules.abilities.util.CodecAbility;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;

public class ShootAbility
implements CodecAbility<GunAbilityContext> {
    public static class_2960 KEY = Miapi.id("gun_shot_single");

    @Override
    public boolean allowedOnItem(class_1799 itemStack, class_1937 world, class_1657 player, class_1268 hand, ItemAbilityManager.AbilityHitContext abilityHitContext) {
        return GunMagazineComponent.getBulletCount(itemStack) > 0;
    }

    @Override
    public class_1839 getUseAction(class_1799 itemStack) {
        return class_1839.field_8952;
    }

    @Override
    public int getMaxUseTime(class_1799 itemStack, class_1309 livingEntity) {
        return 1;
    }

    @Override
    public class_1271<class_1799> use(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 gun = user.method_5998(hand);
        GunAbilityContext context = (GunAbilityContext)this.getSpecialContext(gun);
        if (context == null || GunMagazineComponent.getBulletCount(gun) <= 0) {
            return class_1271.method_22430((Object)gun);
        }
        if (!world.field_9236) {
            this.performShooting(world, user, gun, context);
        }
        return class_1271.method_22427((Object)gun);
    }

    @Override
    public Codec<GunAbilityContext> getCodec() {
        return GunAbilityContext.CODEC;
    }

    private void performShooting(class_1937 world, class_1657 user, class_1799 gun, GunAbilityContext context) {
        class_3414 event;
        Optional<class_1799> bullet = GunMagazineComponent.removeBullet(gun);
        if (bullet.isEmpty()) {
            return;
        }
        if (context.onShoot != null && (event = (class_3414)((class_2378)world.method_30349().method_33310(class_7924.field_41225).get()).method_10223(context.onShoot)) != null) {
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), event, user.method_5634(), 1.0f, 1.0f);
        }
        if (context.shotAnim != null) {
            this.setAnimation(user, user.method_6058(), context.shotAnim);
        }
        GunMagazineComponent.shoot(world, user, context.hitscan);
    }

    public void setAnimation(class_1657 p, class_1268 hand, class_2960 animation) {
        class_3222 player;
        ServerPoseFacet facet;
        if (p instanceof class_3222 && (facet = (ServerPoseFacet)ServerPoseFacet.KEY.get((class_1297)(player = (class_3222)p))) != null) {
            facet.set(animation.toString(), player, hand);
        }
    }

    public void resetAnimation(class_1309 entity) {
        class_3222 player;
        ServerPoseFacet facet;
        if (entity instanceof class_3222 && (facet = (ServerPoseFacet)ServerPoseFacet.KEY.get((class_1297)(player = (class_3222)entity))) != null) {
            facet.reset(player);
        }
    }

    @Override
    public GunAbilityContext getDefaultContext() {
        return new GunAbilityContext(null, null, true);
    }

    public static class GunAbilityContext {
        public static final Codec<GunAbilityContext> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.optionalFieldOf("on_shoot").forGetter(context -> Optional.ofNullable(context.onShoot)), (App)class_2960.field_25139.optionalFieldOf("shot_anim").forGetter(context -> Optional.ofNullable(context.shotAnim)), (App)Miapi.FIXED_BOOL_CODEC.optionalFieldOf("hitscan", (Object)true).forGetter(context -> context.hitscan)).apply((Applicative)instance, (onShootOpt, shotAnimOpt, hitscan) -> new GunAbilityContext(onShootOpt.orElse(null), shotAnimOpt.orElse(null), (boolean)hitscan)));
        public final class_2960 onShoot;
        public final class_2960 shotAnim;
        public final boolean hitscan;

        public GunAbilityContext(class_2960 onShoot, class_2960 shotAnim, boolean hitscan) {
            this.onShoot = onShoot;
            this.shotAnim = shotAnim;
            this.hitscan = hitscan;
        }

        public <T> T encode(DynamicOps<T> ops) {
            return CODEC.encodeStart(ops, (Object)this).result().orElseThrow(() -> new IllegalStateException("Failed to encode GunAbilityContext"));
        }
    }
}

