/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities.shield;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import com.redpxnda.nucleus.pose.server.ServerPoseFacet;
import dev.architectury.event.EventResult;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.modular.items.shield.TowerShieldComponent;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.abilities.util.ItemUseDefaultCooldownAbility;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public class ParryShieldBlock
implements ItemUseDefaultCooldownAbility<BlockData> {
    public ParryShieldBlock() {
        MiapiEvents.LIVING_HURT_AFTER.register(event -> {
            class_1297 patt0$temp;
            class_1799 itemStack = event.defender.method_6030();
            BlockData data = (BlockData)this.getSpecialContext(itemStack);
            if (data != null && (patt0$temp = event.damageSource.method_5529()) instanceof class_1309) {
                class_1309 attacker = (class_1309)patt0$temp;
                attacker.method_5643(event.defender.method_48923().method_48830(), event.amount);
                class_1309 patt1$temp = event.defender;
                if (patt1$temp instanceof class_1657) {
                    class_1657 player = (class_1657)patt1$temp;
                    player.method_7357().method_7906(itemStack.method_7909(), (int)data.cooldown.getValue());
                }
            }
            return EventResult.pass();
        });
    }

    @Override
    public boolean allowedOnItem(class_1799 itemStack, class_1937 world, class_1657 player, class_1268 hand, ItemAbilityManager.AbilityHitContext abilityHitContext) {
        return true;
    }

    @Override
    public class_1839 getUseAction(class_1799 itemStack) {
        return class_1839.field_8949;
    }

    @Override
    public int getMaxUseTime(class_1799 itemStack, class_1309 livingEntity) {
        return 72000;
    }

    @Override
    public class_1271<class_1799> use(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        BlockData data = (BlockData)this.getSpecialContext(itemStack);
        if (data != null) {
            TowerShieldComponent component = (TowerShieldComponent)itemStack.method_57824(TowerShieldComponent.TOWER_SHIELD_COMPONENT);
            if (component != null) {
                component.update(world.method_8510(), (int)data.cooldown.getValue());
            }
            this.setAnimation(user, hand, data.animation);
        }
        return class_1271.method_22430((Object)user.method_5998(hand));
    }

    @Override
    public BlockData getDefaultContext() {
        return null;
    }

    @Override
    public <K> BlockData decode(DynamicOps<K> ops, K prefix) {
        return (BlockData)((Pair)BlockData.codec.decode(ops, prefix).getOrThrow()).getFirst();
    }

    @Override
    public BlockData initialize(BlockData data, ModuleInstance moduleInstance) {
        BlockData init = new BlockData();
        init.cooldown = data.cooldown.initialize(moduleInstance);
        init.minUseTime = data.minUseTime.initialize(moduleInstance);
        init.animation = data.animation;
        return init;
    }

    @Override
    public BlockData merge(BlockData right, BlockData left, MergeType type) {
        return right.merge(right, left, type);
    }

    @Override
    public int getCooldown(class_1799 itemStack) {
        return (int)((BlockData)this.getSpecialContext((class_1799)itemStack)).cooldown.getValue();
    }

    @Override
    public class_1799 finishUsing(class_1799 stack, class_1937 world, class_1309 user) {
        this.resetAnimation(user);
        return stack;
    }

    @Override
    public void onStoppedHolding(class_1799 stack, class_1937 world, class_1309 user) {
        this.resetAnimation(user);
    }

    public void setAnimation(class_1657 p, class_1268 hand, class_2960 id) {
        if (p instanceof class_3222) {
            ServerPoseFacet facet;
            class_3222 player = (class_3222)p;
            if (id != null && (facet = (ServerPoseFacet)ServerPoseFacet.KEY.get((class_1297)player)) != null) {
                facet.set(id.toString(), player, hand);
            }
        }
    }

    public void resetAnimation(class_1309 entity) {
        class_3222 player;
        ServerPoseFacet facet;
        if (entity instanceof class_3222 && (facet = (ServerPoseFacet)ServerPoseFacet.KEY.get((class_1297)(player = (class_3222)entity))) != null) {
            facet.reset(player);
        }
    }

    public static class BlockData
    implements MergeAble<BlockData> {
        public static final Codec<BlockData> codec = AutoCodec.of(BlockData.class).codec();
        @CodecBehavior.Optional
        public DoubleOperationResolvable cooldown = new DoubleOperationResolvable(100.0);
        @AutoCodec.Name(value="min_hold")
        @CodecBehavior.Optional
        public DoubleOperationResolvable minUseTime = new DoubleOperationResolvable(40.0);
        @CodecBehavior.Optional
        public class_2960 animation = class_2960.method_60654((String)"miapi:block");

        @Override
        public BlockData merge(BlockData left, BlockData right, MergeType mergeType) {
            BlockData merged = new BlockData();
            merged.cooldown = left.cooldown.merge(right.cooldown, mergeType);
            merged.minUseTime = left.minUseTime.merge(right.minUseTime, mergeType);
            merged.animation = left.animation.equals((Object)merged.animation) ? right.animation : MergeAble.decideLeftRight(left.animation, right.animation, mergeType);
            return merged;
        }
    }
}

