/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.abilities.shield;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import com.redpxnda.nucleus.codec.behavior.CodecBehavior;
import com.redpxnda.nucleus.pose.server.ServerPoseFacet;
import dev.architectury.event.EventResult;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.item.modular.items.shield.TowerShieldComponent;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.abilities.util.ItemAbilityManager;
import smartin.miapi.modules.abilities.util.ItemUseDefaultCooldownAbility;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;

public class TowerShieldBlock
implements ItemUseDefaultCooldownAbility<BlockData> {
    public TowerShieldBlock() {
        MiapiEvents.LIVING_HURT_AFTER.register(event -> {
            class_1799 itemStack = event.defender.method_6030();
            BlockData data = (BlockData)this.getSpecialContext(itemStack);
            if (data != null) {
                itemStack.method_57368(TowerShieldComponent.TOWER_SHIELD_COMPONENT, (Object)new TowerShieldComponent(event.defender.method_37908().method_8510()), towerShieldComponent -> {
                    class_1309 patt0$temp;
                    ++towerShieldComponent.blockCount;
                    if ((double)towerShieldComponent.blockCount > data.block.getValue() && (patt0$temp = event.defender) instanceof class_1657) {
                        class_1657 player = (class_1657)patt0$temp;
                        double cooldown = data.cooldown.getValue();
                        class_1297 patt1$temp = event.damageSource.method_5526();
                        if (patt1$temp instanceof class_1309) {
                            class_1309 livingEntity = (class_1309)patt1$temp;
                            cooldown += livingEntity.method_45325(AttributeRegistry.SHIELD_BREAK) * 20.0 - 100.0;
                        }
                        player.method_7357().method_7906(itemStack.method_7909(), Math.max(20, (int)cooldown));
                        towerShieldComponent.blockCount = 0;
                    }
                    return towerShieldComponent;
                });
            }
            return EventResult.pass();
        });
    }

    @Override
    public boolean allowedOnItem(class_1799 itemStack, class_1937 world, class_1657 player, class_1268 hand, ItemAbilityManager.AbilityHitContext abilityHitContext) {
        return true;
    }

    @Override
    public class_1839 getUseAction(class_1799 itemStack) {
        return class_1839.field_8949;
    }

    @Override
    public int getMaxUseTime(class_1799 itemStack, class_1309 livingEntity) {
        return 72000;
    }

    @Override
    public class_1271<class_1799> use(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        BlockData data = (BlockData)this.getSpecialContext(itemStack);
        TowerShieldComponent component = (TowerShieldComponent)itemStack.method_57824(TowerShieldComponent.TOWER_SHIELD_COMPONENT);
        if (component != null) {
            component.update(world.method_8510(), (int)data.cooldown.getValue());
            itemStack.method_57379(TowerShieldComponent.TOWER_SHIELD_COMPONENT, (Object)component);
        }
        this.setAnimation(user, hand, data.animation);
        return class_1271.method_22430((Object)user.method_5998(hand));
    }

    @Override
    public BlockData getDefaultContext() {
        return null;
    }

    @Override
    public <K> BlockData decode(DynamicOps<K> ops, K prefix) {
        Codec codec = AutoCodec.of(BlockData.class).codec();
        return (BlockData)((Pair)codec.decode(ops, prefix).getOrThrow()).getFirst();
    }

    @Override
    public BlockData initialize(BlockData data, ModuleInstance moduleInstance) {
        BlockData init = new BlockData();
        init.cooldown = data.cooldown.initialize(moduleInstance);
        init.block = data.block.initialize(moduleInstance);
        init.animation = data.animation;
        return init;
    }

    @Override
    public int getCooldown(class_1799 itemStack) {
        return (int)((BlockData)this.getSpecialContext((class_1799)itemStack)).cooldown.getValue();
    }

    @Override
    public class_1799 finishUsing(class_1799 stack, class_1937 world, class_1309 user) {
        this.resetAnimation(user);
        return stack;
    }

    @Override
    public void onStoppedHolding(class_1799 stack, class_1937 world, class_1309 user) {
        this.resetAnimation(user);
    }

    public void setAnimation(class_1657 p, class_1268 hand, class_2960 id) {
        if (p instanceof class_3222) {
            ServerPoseFacet facet;
            class_3222 player = (class_3222)p;
            if (id != null && (facet = (ServerPoseFacet)ServerPoseFacet.KEY.get((class_1297)player)) != null) {
                facet.set(id.toString(), player, hand);
            }
        }
    }

    public void resetAnimation(class_1309 entity) {
        class_3222 player;
        ServerPoseFacet facet;
        if (entity instanceof class_3222 && (facet = (ServerPoseFacet)ServerPoseFacet.KEY.get((class_1297)(player = (class_3222)entity))) != null) {
            facet.reset(player);
        }
    }

    public static class BlockData {
        @CodecBehavior.Optional
        public DoubleOperationResolvable cooldown = new DoubleOperationResolvable(100.0);
        @CodecBehavior.Optional
        public DoubleOperationResolvable block = new DoubleOperationResolvable(1.0);
        @CodecBehavior.Optional
        public class_2960 animation = class_2960.method_60654((String)"miapi:block");
    }
}

