/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.edit_options.skins;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.handler.codec.DecoderException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_5253;
import net.minecraft.class_8824;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.PropertyHolder;
import smartin.miapi.modules.conditions.ConditionManager;
import smartin.miapi.modules.conditions.ModuleCondition;
import smartin.miapi.modules.edit_options.skins.SkinOptions;
import smartin.miapi.modules.edit_options.skins.TextureOptions;
import smartin.miapi.modules.properties.TagProperty;
import smartin.miapi.registries.RegistryInventory;

public class Skin {
    public String path;
    public String modID;
    public ItemModule module;
    public ModuleCondition condition;
    public PropertyHolder propertyHolder;
    public TextureOptions textureOptions = new TextureOptions(Miapi.id("textures/gui/skin/skin_button.png"), 100, 16, 3, class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255), 1, false);
    @Nullable
    public class_2561 hoverDescription;

    public static List<Skin> fromJson(JsonElement element) {
        JsonObject jsonObject = element.getAsJsonObject();
        ArrayList<Skin> skins = new ArrayList<Skin>();
        Skin.getModules(element).forEach(itemModule -> {
            Skin skin = new Skin();
            skin.module = itemModule;
            skin.condition = ConditionManager.get(jsonObject.get("condition"));
            skin.path = jsonObject.get("path").getAsString();
            skin.propertyHolder = (PropertyHolder)((Pair)PropertyHolder.MAP_CODEC.codec().decode((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow(s -> new DecoderException("Failed to decode skin !" + s))).getFirst();
            skin.textureOptions = TextureOptions.fromJson(jsonObject.get("texture"), Miapi.id("textures/gui/skin/skin_button.png"), 100, 16, 3, class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255));
            if (jsonObject.has("hover")) {
                skin.hoverDescription = (class_2561)class_8824.field_46597.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject.getAsJsonObject("hover")).result().orElse(class_2561.method_43473());
            }
            skins.add(skin);
        });
        return skins;
    }

    public static Optional<Skin> getSkin(ModuleInstance moduleInstance) {
        JsonElement element = moduleInstance.moduleData.get(Miapi.id("skin"));
        if (element != null) {
            String key = element.getAsString();
            Map<String, Skin> moduleSkins = SkinOptions.skins.get(moduleInstance.module.id());
            if (moduleSkins != null) {
                Skin skin = moduleSkins.get(key);
                return Optional.ofNullable(skin);
            }
        }
        return Optional.empty();
    }

    public static void writeSkin(ModuleInstance moduleInstance, String skinKey) {
        moduleInstance.moduleData.put(Miapi.id("skin"), (JsonElement)new JsonPrimitive(skinKey));
    }

    public static List<ItemModule> getModules(JsonElement element) {
        JsonObject jsonObject = element.getAsJsonObject();
        ArrayList<ItemModule> modules = new ArrayList<ItemModule>();
        if (jsonObject.has("module_tags")) {
            jsonObject.get("module_tags").getAsJsonArray().asList().forEach(jsonElement -> modules.addAll(TagProperty.getModulesWithTag(jsonElement.getAsString())));
        }
        if (jsonObject.has("module")) {
            JsonElement moduleElement = jsonObject.get("module");
            if (moduleElement.isJsonArray()) {
                jsonObject.get("module").getAsJsonArray().asList().forEach(jsonElement -> {
                    ItemModule itemModule = RegistryInventory.ITEM_MODULE_MIAPI_REGISTRY.get(jsonElement.getAsString());
                    if (itemModule != null) {
                        modules.add(itemModule);
                    }
                });
            } else {
                ItemModule itemModule = RegistryInventory.ITEM_MODULE_MIAPI_REGISTRY.get(jsonObject.get("module").getAsString());
                if (itemModule != null) {
                    modules.add(itemModule);
                }
            }
        }
        return modules;
    }
}

