/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.attributes;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Either;
import com.redpxnda.nucleus.event.PrioritizedEvent;
import dev.architectury.event.EventResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import smartin.miapi.Miapi;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;

public class AttributeUtil {
    public static final PrioritizedEvent<AttributeAdjustEvent> MODULE_ATTRIBUTE_ADJUST = PrioritizedEvent.createEventResult((Object[])new AttributeAdjustEvent[0]);
    public static final PrioritizedEvent<ItemAttributeAdjustEvent> ITEM_ATTRIBUTE_ADJUST = PrioritizedEvent.createEventResult((Object[])new ItemAttributeAdjustEvent[0]);
    public static final PrioritizedEvent<ItemVanillaAttributeAdjustEvent> VANILLA_ITEM_ATTRIBUTE_ADJUST = PrioritizedEvent.createEventResult((Object[])new ItemVanillaAttributeAdjustEvent[0]);

    public static Multimap<class_1320, class_1322> getAttribute(class_1799 itemStack, class_1304 equipmentSlot) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        class_9285 attributeModifiers = (class_9285)itemStack.method_57353().method_57829(class_9334.field_49636);
        if (attributeModifiers != null) {
            attributeModifiers.method_57482(equipmentSlot, (arg_0, arg_1) -> AttributeUtil.lambda$getAttribute$0((Multimap)multimap, arg_0, arg_1));
        }
        return multimap;
    }

    public static Multimap<class_1320, class_1322> getAttribute(class_1799 itemStack, class_9274 equipmentSlot) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        class_9285 attributeModifiers = (class_9285)itemStack.method_57353().method_57829(class_9334.field_49636);
        if (attributeModifiers != null) {
            attributeModifiers.method_60618(equipmentSlot, (arg_0, arg_1) -> AttributeUtil.lambda$getAttribute$1((Multimap)multimap, arg_0, arg_1));
        }
        return multimap;
    }

    public static double getActualValue(class_1799 stack, class_1304 slot, class_1320 entityAttribute, double fallback) {
        if (entityAttribute == null) {
            return fallback;
        }
        ArrayList<class_1322> modifiers = new ArrayList<class_1322>();
        class_9285 attributeModifiers = (class_9285)stack.method_57825(class_9334.field_49636, (Object)class_9285.field_49326);
        attributeModifiers.method_57482(slot, (attribute, modifier) -> {
            if (entityAttribute.equals(attribute.comp_349())) {
                modifiers.add((class_1322)modifier);
            }
        });
        return AttributeUtil.getActualValue(modifiers, fallback);
    }

    public static double getActualValue(Multimap<class_1320, class_1322> map, class_1320 entityAttribute, double fallback) {
        Collection attributes = map.get((Object)entityAttribute);
        return AttributeUtil.getActualValue(attributes, fallback);
    }

    public static double getActualValue(Collection<class_1322> attributes, double fallback) {
        ArrayList addition = new ArrayList();
        ArrayList multiplyBase = new ArrayList();
        ArrayList multiplyTotal = new ArrayList();
        attributes.forEach(attribute -> {
            switch (attribute.comp_2450()) {
                case field_6328: {
                    addition.add(attribute.comp_2449());
                    break;
                }
                case field_6330: {
                    multiplyBase.add(attribute.comp_2449());
                    break;
                }
                case field_6331: {
                    multiplyTotal.add(attribute.comp_2449());
                }
            }
        });
        double value = fallback;
        for (Double currentValue : addition) {
            value += currentValue.doubleValue();
        }
        double multiplier = 1.0;
        for (Double currentValue : multiplyBase) {
            multiplier += currentValue.doubleValue();
        }
        value *= multiplier;
        for (Double currentValue : multiplyTotal) {
            value = (1.0 + currentValue) * value;
        }
        if (Double.isNaN(value)) {
            return fallback;
        }
        return value;
    }

    public static double getActualValue(class_1799 stack, class_1304 slot, class_1320 entityAttribute) {
        return AttributeUtil.getActualValue(stack, slot, entityAttribute, entityAttribute.method_6169());
    }

    public static class_2960 getIDForSlot(class_9274 equipmentSlot, class_1320 attribute, class_1322.class_1323 operation) {
        if (equipmentSlot.equals((Object)class_9274.field_49217) && attribute.equals(class_5134.field_23721.comp_349()) && operation.equals((Object)class_1322.class_1323.field_6328)) {
            return class_1829.field_8006;
        }
        if (equipmentSlot.equals((Object)class_9274.field_49217) && attribute.equals(class_5134.field_23723.comp_349()) && operation.equals((Object)class_1322.class_1323.field_6328)) {
            return class_1829.field_8001;
        }
        return AttributeUtil.getIDForSlot(equipmentSlot, attribute, operation, "");
    }

    public static class_2960 getIDForSlot(class_9274 equipmentSlot, class_1320 attribute, class_1322.class_1323 operation, String context) {
        String slotidString = equipmentSlot.method_15434() + "-" + attribute.method_26830() + "-" + equipmentSlot.name() + "-" + equipmentSlot.ordinal() + "-" + operation.toString() + context;
        return AttributeUtil.getIDForSlot(slotidString);
    }

    public static class_2960 getIDForSlot(String slotidString) {
        return Miapi.id(slotidString.toLowerCase(Locale.ROOT));
    }

    private static /* synthetic */ void lambda$getAttribute$1(Multimap multimap, class_6880 attributeHolder, class_1322 attributeModifier) {
        multimap.put((Object)((class_1320)attributeHolder.comp_349()), (Object)attributeModifier);
    }

    private static /* synthetic */ void lambda$getAttribute$0(Multimap multimap, class_6880 attributeHolder, class_1322 attributeModifier) {
        multimap.put((Object)((class_1320)attributeHolder.comp_349()), (Object)attributeModifier);
    }

    public static interface AttributeAdjustEvent {
        public EventResult adjust(AttributeContext var1, ModuleInstance var2);
    }

    public static interface ItemAttributeAdjustEvent {
        public EventResult adjust(AttributeContext var1, class_1799 var2);
    }

    public static interface ItemVanillaAttributeAdjustEvent {
        public EventResult adjust(ItemVanillaAttributeContext var1, class_1799 var2);
    }

    public static class ItemVanillaAttributeContext {
        List<class_9285.class_9287> list;
    }

    public static class AttributeContext {
        Map<class_2960, Map<class_1322.class_1323, Map<Either<class_9274, Boolean>, DoubleOperationResolvable>>> map;
    }
}

