/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.enchanment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.mixin.NamedAccessor;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.ComponentApplyProperty;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public class AllowedEnchantments
extends CodecProperty<AllowedEnchantsData>
implements ComponentApplyProperty {
    public static final class_2960 KEY = Miapi.id("enchantments");
    public static AllowedEnchantments property;
    public static Map<class_2960, List<class_2960>> enchantmentExtentionsMap;

    public AllowedEnchantments() {
        super(AllowedEnchantsData.CODEC);
        property = this;
        ReloadEvents.END.subscribe((isClient, registryAccess) -> {
            enchantmentExtentionsMap = new HashMap(Map.of(class_2960.method_60654((String)"c:enchantable/pickaxe"), new ArrayList(), class_2960.method_60654((String)"c:enchantable/axe"), new ArrayList(), class_2960.method_60654((String)"c:enchantable/shovel"), new ArrayList(), class_2960.method_60654((String)"c:enchantable/hoe"), new ArrayList()));
            if (registryAccess != null) {
                this.detectEnchantments(registryAccess);
            }
        });
    }

    public void detectEnchantments(class_5455 access) {
        List<class_1792> pickaxes = List.of(class_1802.field_8647, class_1802.field_8387, class_1802.field_8335, class_1802.field_8377, class_1802.field_22024);
        List<class_1792> axe = List.of(class_1802.field_8406, class_1802.field_8062, class_1802.field_8825, class_1802.field_8556, class_1802.field_22025);
        List<class_1792> shovel = List.of(class_1802.field_8876, class_1802.field_8776, class_1802.field_8322, class_1802.field_8250, class_1802.field_22023);
        List<class_1792> hoe = List.of(class_1802.field_8167, class_1802.field_8431, class_1802.field_8303, class_1802.field_8527, class_1802.field_22026);
        ArrayList<class_1792> allTools = new ArrayList<class_1792>(pickaxes);
        allTools.addAll(axe);
        allTools.addAll(shovel);
        allTools.addAll(hoe);
        ((class_2378)access.method_33310(class_7924.field_41265).get()).forEach(enchantment -> {
            if (!this.allSupportEnchantment((List<class_1792>)allTools, (class_1887)enchantment)) {
                class_2960 enchantmentID = ((class_2378)access.method_33310(class_7924.field_41265).get()).method_10221(enchantment);
                if (this.allSupportEnchantment(pickaxes, (class_1887)enchantment)) {
                    enchantmentExtentionsMap.get(class_2960.method_60654((String)"c:enchantable/pickaxe")).add(enchantmentID);
                }
                if (this.allSupportEnchantment(axe, (class_1887)enchantment)) {
                    enchantmentExtentionsMap.get(class_2960.method_60654((String)"c:enchantable/axe")).add(enchantmentID);
                }
                if (this.allSupportEnchantment(shovel, (class_1887)enchantment)) {
                    enchantmentExtentionsMap.get(class_2960.method_60654((String)"c:enchantable/shovel")).add(enchantmentID);
                }
                if (this.allSupportEnchantment(hoe, (class_1887)enchantment)) {
                    enchantmentExtentionsMap.get(class_2960.method_60654((String)"c:enchantable/hoe")).add(enchantmentID);
                }
            }
        });
    }

    public boolean allSupportEnchantment(List<class_1792> items, class_1887 enchantment) {
        for (class_1792 item : items) {
            if (enchantment.method_60046(item.method_7854())) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllowed(class_1799 itemStack, class_6880<class_1887> enchantment, boolean oldValue) {
        Optional<AllowedEnchantsData> optional = property.getData(itemStack);
        return optional.map(allowedEnchantsData -> allowedEnchantsData.isAllowed(enchantment).orElse(oldValue)).orElse(oldValue);
    }

    @Override
    public AllowedEnchantsData merge(AllowedEnchantsData left, AllowedEnchantsData right, MergeType mergeType) {
        return new AllowedEnchantsData(MergeAble.mergeList(left.allowed(), right.allowed(), mergeType), MergeAble.mergeList(left.forbidden(), right.forbidden(), mergeType));
    }

    @Override
    public AllowedEnchantsData initialize(AllowedEnchantsData property, ModuleInstance context) {
        return new AllowedEnchantsData(this.initialize(property.allowed()), this.initialize(property.forbidden()));
    }

    public List<class_2960> initialize(List<class_2960> ids) {
        ArrayList<class_2960> expanded = new ArrayList<class_2960>(ids);
        for (class_2960 id : ids) {
            if (!enchantmentExtentionsMap.containsKey(id)) continue;
            expanded.addAll((Collection<class_2960>)enchantmentExtentionsMap.get(id));
        }
        return expanded.stream().distinct().toList();
    }

    @Override
    public void updateComponent(class_1799 itemStack, @Nullable class_5455 registryAccess) {
        if (itemStack.method_57826(class_9334.field_49633)) {
            class_9304 enchantments = itemStack.method_58657();
            itemStack.method_57368(class_9334.field_49633, (Object)class_9304.field_49385, old -> {
                class_9304.class_9305 mutable = new class_9304.class_9305(old);
                this.getData(itemStack).ifPresent(data -> enchantments.method_57534().forEach(e -> {
                    Optional<Boolean> optional = data.isAllowed((class_6880<class_1887>)e);
                    if (optional.isEmpty() || !optional.get().booleanValue()) {
                        mutable.method_57548(enchant -> ((class_1887)enchant.comp_349()).equals(e.comp_349()));
                    }
                }));
                return mutable.method_57549();
            });
        }
    }

    static {
        enchantmentExtentionsMap = new HashMap<class_2960, List<class_2960>>();
    }

    public record AllowedEnchantsData(List<class_2960> allowed, List<class_2960> forbidden) {
        public static Codec<Either<class_6880<class_1887>, class_2960>> codec = Codec.either((Codec)class_1887.field_51644, (Codec)class_2960.field_25139);
        public static Codec<AllowedEnchantsData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)class_2960.field_25139).optionalFieldOf("allowed", List.of()).forGetter(AllowedEnchantsData::allowed), (App)Codec.list((Codec)class_2960.field_25139).optionalFieldOf("forbidden", List.of()).forGetter(AllowedEnchantsData::allowed)).apply((Applicative)instance, AllowedEnchantsData::new));

        Optional<Boolean> isAllowed(class_6880<class_1887> enchantment) {
            if (this.contains(enchantment, this.forbidden())) {
                return Optional.of(false);
            }
            if (this.contains(enchantment, this.allowed)) {
                return Optional.of(true);
            }
            return Optional.empty();
        }

        private boolean contains(class_6880<class_1887> enchantment, List<class_2960> ids) {
            for (class_2960 id : ids) {
                class_6885.class_6888 set;
                class_2960 tagID;
                if (enchantment.method_40226(id)) {
                    return true;
                }
                class_6885 class_68852 = ((class_1887)enchantment.comp_349()).comp_2687().comp_2506();
                if (!(class_68852 instanceof class_6885.class_6888) || !(tagID = ((NamedAccessor)(set = (class_6885.class_6888)class_68852)).getKey().comp_327()).equals((Object)id)) continue;
                return true;
            }
            return false;
        }
    }
}

