/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.mining;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9334;
import net.minecraft.class_9424;
import smartin.miapi.Miapi;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.cache.ModularItemCache;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.ComponentApplyProperty;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

public class MiningLevelProperty
extends CodecProperty<Map<String, MiningRule>>
implements ComponentApplyProperty {
    public static MiningLevelProperty property;
    public static final class_2960 KEY;
    public static Map<String, class_6862<class_2248>> miningCapabilities;
    public static Codec<Map<String, MiningRule>> CODEC;
    public static String CACHEKEY;

    public MiningLevelProperty() {
        super(CODEC);
        property = this;
        ModularItemCache.setSupplier(CACHEKEY, this::asComponent);
    }

    @Override
    public Map<String, MiningRule> merge(Map<String, MiningRule> left, Map<String, MiningRule> right, MergeType mergeType) {
        return MergeAble.mergeMap(left, right, mergeType, (k, l, r) -> MiningRule.merge(l, r, mergeType));
    }

    @Override
    public Map<String, MiningRule> initialize(Map<String, MiningRule> data, ModuleInstance context) {
        HashMap<String, MiningRule> initialized = new HashMap<String, MiningRule>();
        data.forEach((key, entry) -> initialized.put((String)key, entry.initialize(context)));
        return initialized;
    }

    class_9424 asComponent(class_1799 itemStack) {
        ArrayList rules = new ArrayList();
        Map rawData = this.getData(itemStack).orElse(new HashMap());
        rawData.values().forEach(miningRule -> rules.addAll(miningRule.asRules()));
        return new class_9424(rules, 1.0f, 1);
    }

    class_9424 asComponentCached(class_1799 itemStack) {
        return ModularItemCache.get(itemStack, CACHEKEY, new class_9424(new ArrayList(), 1.0f, 1));
    }

    @Override
    public void updateComponent(class_1799 itemStack, class_5455 registryAccess) {
        itemStack.method_57379(class_9334.field_50077, (Object)new class_9424(new ArrayList(), 1.0f, 1));
    }

    public static float getDestroySpeed(class_1799 stack, class_2680 state) {
        return Math.max(property.asComponentCached(stack).method_58425(state), 1.0f);
    }

    public static boolean isCorrectToolForDrops(class_1799 stack, class_2680 state) {
        class_9424 tool = property.asComponentCached(stack);
        return tool.method_58426(state);
    }

    public static boolean mineBlock(class_1799 stack, class_1937 level, class_2680 state, class_2338 pos, class_1309 miningEntity) {
        class_9424 ourComponent = property.asComponentCached(stack);
        int toolDamage = ourComponent.comp_2500();
        if (!level.field_9236 && state.method_26214((class_1922)level, pos) != 0.0f && toolDamage > 0) {
            stack.method_7970(toolDamage, miningEntity, class_1304.field_6173);
        }
        return true;
    }

    private static List<class_6880<class_2248>> toList(List<class_6885<class_2248>> blocks) {
        ArrayList<class_6880<class_2248>> canDropBlocks = new ArrayList<class_6880<class_2248>>();
        class_7923.field_41175.forEach(block -> blocks.forEach(set -> {
            class_6880 holder = class_7923.field_41175.method_47983(block);
            if (set.method_40241(holder)) {
                canDropBlocks.add(holder);
            }
        }));
        return canDropBlocks;
    }

    private static List<class_6880<class_2248>> toList(class_6885<class_2248> blocks) {
        ArrayList<class_6880<class_2248>> canDropBlocks = new ArrayList<class_6880<class_2248>>();
        class_7923.field_41175.forEach(block -> {
            class_6880 holder = class_7923.field_41175.method_47983(block);
            if (blocks.method_40241(holder)) {
                canDropBlocks.add(holder);
            }
        });
        return canDropBlocks;
    }

    static {
        KEY = Miapi.id("mining_level");
        miningCapabilities = new HashMap<String, class_6862<class_2248>>();
        CODEC = Codec.unboundedMap((Codec)Codec.STRING, MiningRule.CODEC);
        CACHEKEY = String.valueOf(KEY) + "finished_component";
    }

    public record MiningRule(List<class_6885<class_2248>> blocks, List<class_6885<class_2248>> blacklist, DoubleOperationResolvable speed, Optional<Boolean> correctForDrops, boolean useMaterial, List<Material> respectMaterialBlacklists) {
        public static final Codec<MiningRule> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6895.method_40340((class_5321)class_7924.field_41254).listOf().optionalFieldOf("allowed", List.of()).forGetter(MiningRule::blocks), (App)class_6895.method_40340((class_5321)class_7924.field_41254).listOf().optionalFieldOf("forbidden", List.of()).forGetter(MiningRule::blacklist), (App)DoubleOperationResolvable.CODEC.optionalFieldOf("speed", (Object)new DoubleOperationResolvable(1.0)).forGetter(MiningRule::speed), (App)Miapi.FIXED_BOOL_CODEC.optionalFieldOf("correct_for_drops").forGetter(MiningRule::correctForDrops), (App)Miapi.FIXED_BOOL_CODEC.optionalFieldOf("use_material", (Object)false).forGetter(MiningRule::useMaterial)).apply((Applicative)instance, (blockList, blacklist, speed, correct, useMaterial) -> new MiningRule((List<class_6885<class_2248>>)blockList, (List<class_6885<class_2248>>)blacklist, (DoubleOperationResolvable)speed, (Optional<Boolean>)correct, (boolean)useMaterial, (List<Material>)new ArrayList<Material>())));

        public static MiningRule merge(MiningRule left, MiningRule right, MergeType mergeType) {
            List<class_6885<class_2248>> blocks = MergeAble.mergeList(left.blocks(), right.blocks(), mergeType);
            List<class_6885<class_2248>> blacklist = MergeAble.mergeList(left.blacklist(), right.blacklist(), mergeType);
            List<Material> mergedMaterials = MergeAble.mergeList(left.respectMaterialBlacklists(), right.respectMaterialBlacklists(), mergeType);
            DoubleOperationResolvable merged = left.speed().merge(right.speed(), mergeType);
            Optional<Boolean> mergedBoolean = Optional.empty();
            if (left.correctForDrops().isPresent()) {
                mergedBoolean = left.correctForDrops();
            }
            if (right.correctForDrops().isPresent()) {
                mergedBoolean = right.correctForDrops();
            }
            return new MiningRule(blocks, blacklist, merged, mergedBoolean, left.useMaterial() || right.useMaterial(), mergedMaterials);
        }

        public MiningRule initialize(ModuleInstance moduleInstance) {
            Material material;
            ArrayList<class_6885<class_2248>> blockBlackList = new ArrayList<class_6885<class_2248>>(this.blacklist().stream().toList());
            Optional<Boolean> correctForDrops = this.correctForDrops();
            ArrayList<Material> mergedMaterials = new ArrayList<Material>(this.respectMaterialBlacklists());
            if (this.useMaterial() && (material = MaterialProperty.getMaterial(moduleInstance)) != null) {
                mergedMaterials.add(material);
            }
            return new MiningRule(this.blocks().stream().toList(), blockBlackList, this.speed().initialize(moduleInstance), correctForDrops, this.useMaterial(), mergedMaterials);
        }

        public List<class_9424.class_9425> asRules() {
            float speedEvaluated = (float)this.speed().evaluate(0.0, 1.0);
            if (speedEvaluated < 1.0f) {
                speedEvaluated = 1.0f;
            }
            if (this.useMaterial()) {
                List<class_6880<class_2248>> canDropBlocks = MiningLevelProperty.toList(this.blocks());
                if (!canDropBlocks.isEmpty()) {
                    MiningLevelProperty.toList(this.blacklist()).stream().map(class_6880::comp_349).distinct().forEach(canDropBlocks::remove);
                }
                ArrayList<class_6880<class_2248>> blocksWithMiningSpeed = new ArrayList<class_6880<class_2248>>(canDropBlocks);
                ArrayList toRemoveFromMaterial = new ArrayList();
                this.respectMaterialBlacklists().forEach(material -> {
                    if (toRemoveFromMaterial.isEmpty()) {
                        class_7923.field_41175.method_40266(material.getIncorrectBlocksForDrops()).ifPresent(named -> named.method_40239().distinct().forEach(toRemoveFromMaterial::add));
                    } else {
                        ArrayList notShared = new ArrayList(toRemoveFromMaterial);
                        class_7923.field_41175.method_40266(material.getIncorrectBlocksForDrops()).ifPresent(named -> MiningLevelProperty.toList((class_6885<class_2248>)named).stream().map(class_6880::comp_349).distinct().forEach(notShared::remove));
                        notShared.forEach(toRemoveFromMaterial::remove);
                    }
                });
                toRemoveFromMaterial.forEach(canDropBlocks::remove);
                List<class_2248> rawBlocks = new HashSet<class_6880<class_2248>>(canDropBlocks).stream().distinct().map(class_6880::comp_349).toList();
                class_9424.class_9425 mineAndDrop = class_9424.class_9425.method_58431(rawBlocks, (float)speedEvaluated);
                class_9424.class_9425 overrideSpeed = class_9424.class_9425.method_58434(blocksWithMiningSpeed.stream().map(class_6880::comp_349).toList(), (float)speedEvaluated);
                return List.of(mineAndDrop, overrideSpeed);
            }
            ArrayList canDropBlocks = new ArrayList();
            this.blocks.forEach(set -> set.forEach(canDropBlocks::add));
            ArrayList forbiddenBlocks = new ArrayList();
            this.blacklist.forEach(set -> set.forEach(canDropBlocks::add));
            return List.of(new class_9424.class_9425((class_6885)class_6885.method_40242(forbiddenBlocks), Optional.of(Float.valueOf(speedEvaluated)), Optional.of(false)), new class_9424.class_9425((class_6885)class_6885.method_40242(canDropBlocks), Optional.of(Float.valueOf(speedEvaluated)), this.correctForDrops()));
        }
    }
}

