/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.render;

import com.mojang.serialization.Codec;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import smartin.miapi.Miapi;
import smartin.miapi.client.model.BannerMiapiModel;
import smartin.miapi.client.model.MiapiItemModel;
import smartin.miapi.item.modular.Transform;
import smartin.miapi.material.MaterialInscribeDataProperty;
import smartin.miapi.modules.properties.render.ModelProperty;
import smartin.miapi.modules.properties.slot.SlotProperty;
import smartin.miapi.modules.properties.util.CodecProperty;
import smartin.miapi.modules.properties.util.MergeAble;
import smartin.miapi.modules.properties.util.MergeType;

@Environment(value=EnvType.CLIENT)
public class BannerModelProperty
extends CodecProperty<List<BannerModelData>> {
    public static final class_2960 KEY = Miapi.id("banner");
    public static BannerModelProperty property;
    public static Codec<List<BannerModelData>> CODEC;

    public BannerModelProperty() {
        super(CODEC);
        property = this;
        MiapiItemModel.modelSuppliers.add((key, displayMode, moduleInstance, stack) -> {
            ArrayList models = new ArrayList();
            this.getData(moduleInstance).ifPresent(list -> list.forEach(bannerModelData -> {
                SlotProperty.ModuleSlot slot;
                if ("parent".equals(bannerModelData.modelType) && (slot = SlotProperty.getSlotIn(moduleInstance)) != null) {
                    bannerModelData.modelType = slot.transform.origin;
                }
                Supplier<class_1799> stackSupplier = switch (bannerModelData.type) {
                    case "item_nbt" -> () -> stack;
                    case "module_data" -> {
                        if (ModelProperty.isAllowedKey(bannerModelData.modelType, key)) {
                            yield () -> MaterialInscribeDataProperty.readStackFromModuleInstance(moduleInstance, KEY.toString());
                        }
                        yield () -> class_1799.field_8037;
                    }
                    default -> throw new IllegalStateException("Unexpected value: " + bannerModelData.type);
                };
                BannerMiapiModel.BannerMode mode = BannerMiapiModel.getMode(bannerModelData.model);
                bannerModelData.transform = Transform.repair(bannerModelData.transform);
                BannerMiapiModel bannerMiapiModel = BannerMiapiModel.getFromStack(stackSupplier.get(), mode, bannerModelData.transform.toMatrix());
                if (bannerMiapiModel != null) {
                    models.add(bannerMiapiModel);
                }
            }));
            return models;
        });
    }

    @Override
    public List<BannerModelData> merge(List<BannerModelData> left, List<BannerModelData> right, MergeType mergeType) {
        return MergeAble.mergeList(left, right, mergeType);
    }

    static {
        CODEC = Codec.list((Codec)AutoCodec.of(BannerModelData.class).codec());
    }

    public static class BannerModelData {
        public String type;
        public String model;
        public String modelType;
        public Transform transform = Transform.IDENTITY;
    }
}

