/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.modules.properties.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.function.TriFunction;
import smartin.miapi.modules.properties.util.MergeType;

public interface MergeAble<T> {
    public T merge(T var1, T var2, MergeType var3);

    public static <K> List<K> mergeList(List<K> left, List<K> right, MergeType mergeType) {
        if (MergeType.OVERWRITE.equals((Object)mergeType)) {
            return new ArrayList<K>(right);
        }
        ArrayList<K> merged = new ArrayList<K>(left);
        merged.addAll(right);
        return merged;
    }

    public static <K, L> Map<L, K> mergeMap(Map<L, K> left, Map<L, K> right, MergeType mergeType) {
        return MergeAble.mergeMap(left, right, mergeType, (key, l, r) -> MergeAble.decideLeftRight(l, r, mergeType));
    }

    public static <K, L> Map<L, K> mergeMap(Map<L, K> left, Map<L, K> right, MergeType mergeType, TriFunction<L, K, K, K> onCollision) {
        if (MergeType.OVERWRITE.equals((Object)mergeType)) {
            return new LinkedHashMap<L, K>(right);
        }
        LinkedHashMap merged = new LinkedHashMap(left);
        right.forEach((key, entry) -> {
            if (!merged.containsKey(key)) {
                merged.put(key, entry);
            } else {
                Object mergedKey = onCollision.apply(key, merged.get(key), entry);
                if (mergedKey != null) {
                    merged.put(key, mergedKey);
                } else {
                    merged.remove(key);
                }
            }
        });
        return merged;
    }

    public static <K> K decideLeftRight(K right, K left, MergeType mergeType) {
        if (MergeType.EXTEND.equals((Object)mergeType)) {
            return right;
        }
        return left;
    }
}

