/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import smartin.miapi.Miapi;
import smartin.miapi.network.NetworkingImpl;

public class Networking {
    public static Map<String, Consumer<class_2540>> S2CPackets = new HashMap<String, Consumer<class_2540>>();
    public static Map<String, BiConsumer<class_2540, class_3222>> C2SPackets = new HashMap<String, BiConsumer<class_2540, class_3222>>();
    public static NetworkingImpl implementation;
    protected static NetworkingImpl.EventListener listener;

    protected Networking() {
    }

    public static void setImplementation(NetworkingImpl implementation) {
        if (Networking.implementation != null) {
            implementation.unsubscribe(listener);
        }
        Networking.implementation = implementation;
        implementation.subscribe(listener);
    }

    public static class_2540 createBuffer() {
        return implementation.createBuffer();
    }

    public static void registerC2SPacket(String identifier, BiConsumer<class_2540, class_3222> callback) {
        if (C2SPackets.get(identifier) != null) {
            Miapi.LOGGER.error("packet already exists with identifier " + identifier);
        }
        C2SPackets.put(identifier, callback);
    }

    public static void unRegisterC2SPacket(String identifier) {
        C2SPackets.remove(identifier);
    }

    public static void unRegisterS2CPacket(String identifier) {
        S2CPackets.remove(identifier);
    }

    public static void registerS2CPacket(String identifier, Consumer<class_2540> callbacks) {
        if (S2CPackets.get(identifier) != null) {
            Miapi.LOGGER.error("packet already exists with identifier " + identifier);
        }
        S2CPackets.put(identifier, callbacks);
    }

    public static void sendC2S(String packetIdentifier, class_2540 buffer) {
        implementation.sendPacketToServer(packetIdentifier, buffer);
    }

    public static void sendS2C(String packetIdentifier, class_3222 player, class_2540 buffer) {
        implementation.sendPacketToClient(packetIdentifier, player, buffer);
    }

    public static void sendS2C(String packetIdentifier, class_2540 buffer) {
        if (Miapi.server == null) {
            Miapi.LOGGER.error("cant send packets before Server has fully started");
        }
        Miapi.server.method_3760().method_14571().forEach(serverPlayer -> {
            class_2540 buf = new class_2540(buffer.copy());
            implementation.sendPacketToClient(packetIdentifier, (class_3222)serverPlayer, buf);
        });
    }

    static {
        listener = (key, data, entity) -> {
            if (entity == null) {
                Consumer<class_2540> consumer = S2CPackets.get(key);
                if (consumer != null) {
                    consumer.accept(data);
                }
            } else {
                BiConsumer<class_2540, class_3222> consumer = C2SPackets.get(key);
                if (consumer != null) {
                    consumer.accept(data, entity);
                }
            }
        };
    }
}

