/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.network.modern;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.apache.commons.lang3.function.TriConsumer;
import smartin.miapi.Environment;
import smartin.miapi.Miapi;
import smartin.miapi.network.Networking;
import smartin.miapi.network.modern.payload.C2SMiapiPayload;
import smartin.miapi.network.modern.payload.CustomPayload;
import smartin.miapi.network.modern.payload.S2CMiapiPayload;

public class ModernNetworking {
    public static final Map<class_2960, Receiver<?>> s2cReceivers = new HashMap();
    public static final Map<class_2960, Receiver<?>> c2sReceivers = new HashMap();

    public static void setup() {
        try {
            if (Environment.isClient()) {
                NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, S2CMiapiPayload.TYPE, S2CMiapiPayload.STREAM_CODEC, (packet, context) -> s2cReceivers.computeIfPresent(packet.payload().parseId(), (location, receiver) -> {
                    class_9129 buf = new class_9129((ByteBuf)Networking.createBuffer(), context.registryAccess());
                    buf.method_52983(packet.payload().data());
                    receiver.receive(buf, context.getPlayer());
                    return receiver;
                }));
            } else {
                NetworkManager.registerS2CPayloadType(S2CMiapiPayload.TYPE, S2CMiapiPayload.STREAM_CODEC);
            }
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, C2SMiapiPayload.PACKET_TYPE, C2SMiapiPayload.STREAM_CODEC, (packet, context) -> c2sReceivers.computeIfPresent(packet.payload().parseId(), (location, receiver) -> {
                class_9129 buf = new class_9129((ByteBuf)Networking.createBuffer(), context.registryAccess());
                buf.method_52983(packet.payload().data());
                receiver.receive(buf, context.getPlayer());
                return receiver;
            }));
        }
        catch (RuntimeException e) {
            Miapi.LOGGER.error("could not setup networking", (Throwable)e);
        }
    }

    public static <T> void registerS2CReceiver(class_2960 location, class_9139<class_9129, T> codec, TriConsumer<T, class_1657, class_5455> onReceive) {
        s2cReceivers.put(location, new Receiver<T>(codec, onReceive));
    }

    public static <T> void registerC2SReceiver(class_2960 location, class_9139<class_9129, T> codec, TriConsumer<T, class_1657, class_5455> onReceive) {
        c2sReceivers.put(location, new Receiver<T>(codec, onReceive));
    }

    public static void deregisterS2CReceiver(class_2960 location) {
        s2cReceivers.remove(location);
    }

    public static void deregisterC2SReceiver(class_2960 location) {
        c2sReceivers.remove(location);
    }

    public static <T> void sendToServer(class_2960 location, class_9139<class_9129, T> codec, T data, class_5455 access) {
        if (Environment.isClient() && class_310.method_1551().method_1562() == null) {
            return;
        }
        class_9129 buf = new class_9129((ByteBuf)Networking.createBuffer(), access);
        codec.encode((Object)buf, data);
        CustomPayload data1 = new CustomPayload(location.toString(), C2SMiapiPayload.getClientUUID(), buf.array());
        NetworkManager.sendToServer((class_8710)new C2SMiapiPayload(data1));
    }

    public static <T> void sendToPlayer(class_2960 location, class_1657 player, class_9139<class_9129, T> codec, T data) {
        if (player instanceof class_3222) {
            class_3222 player1 = (class_3222)player;
            if (player1.field_13987 == null) {
                return;
            }
        }
        class_9129 buf = new class_9129((ByteBuf)Networking.createBuffer(), player.method_56673());
        codec.encode((Object)buf, data);
        CustomPayload data1 = new CustomPayload(location.toString(), player.method_5667(), buf.array());
        NetworkManager.sendToServer((class_8710)new S2CMiapiPayload(data1));
    }

    public record Receiver<T>(class_9139<class_9129, T> codec, TriConsumer<T, class_1657, class_5455> onReceive) {
        public void receive(class_9129 raw, class_1657 player) {
            this.onReceive().accept(this.codec().decode((Object)raw), (Object)player, (Object)raw.method_56349());
        }
    }
}

