/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.registries;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import org.apache.logging.log4j.util.InternalApi;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;

public class MiapiRegistry<T> {
    protected final Map<class_2960, T> entries = Collections.synchronizedMap(new LinkedHashMap());
    @InternalApi
    public static final Map<Class<?>, MiapiRegistry<?>> REGISTRY_MAP = Collections.synchronizedMap(new LinkedHashMap());
    protected final List<Consumer<T>> callbacks = new ArrayList<Consumer<T>>();
    protected final Map<class_2960, Supplier<T>> suppliers = Collections.synchronizedMap(new LinkedHashMap());

    protected MiapiRegistry() {
    }

    public static <T> MiapiRegistry<T> getInstance(Class<T> clazz) {
        if (!REGISTRY_MAP.containsKey(clazz)) {
            MiapiRegistry<T> instance = new MiapiRegistry<T>();
            REGISTRY_MAP.put(clazz, instance);
            return instance;
        }
        return REGISTRY_MAP.get(clazz);
    }

    @Nullable
    public <T> class_2960 findKey(T value) {
        Optional<class_2960> matchingId = this.entries.entrySet().stream().filter(entry -> entry.getValue().equals(value)).map(Map.Entry::getKey).findFirst();
        return matchingId.orElse(null);
    }

    public static <T> MiapiRegistry<T> getInstance(Class<T> clazz, List<Consumer<T>> callbacks) {
        MiapiRegistry<Object> instance;
        if (!REGISTRY_MAP.containsKey(clazz)) {
            instance = new MiapiRegistry<T>();
            REGISTRY_MAP.put(clazz, instance);
        }
        MiapiRegistry<Object> finalInstance = instance = REGISTRY_MAP.get(clazz);
        callbacks.forEach(finalInstance::addCallback);
        return REGISTRY_MAP.computeIfAbsent(clazz, T -> new MiapiRegistry());
    }

    public T register(String name, T value) {
        return this.register(Miapi.id(name), value);
    }

    public T register(class_2960 name, T value) {
        if (this.entries.containsKey(name) || this.suppliers.containsKey(name)) {
            throw new IllegalArgumentException("Entry with name '" + String.valueOf(name) + "' already exists.");
        }
        this.entries.put(name, value);
        this.callbacks.forEach(callback -> callback.accept(value));
        return value;
    }

    public void registerSupplier(class_2960 name, Supplier<T> value) {
        if (this.entries.containsKey(name)) {
            throw new IllegalArgumentException("Entry with name '" + String.valueOf(name) + "' already exists.");
        }
        this.suppliers.put(name, value);
    }

    public boolean containsKey(class_2960 id) {
        return this.entries.containsKey(id);
    }

    public void clear() {
        this.suppliers.clear();
        this.entries.clear();
    }

    public void loadAllSupplier() {
        this.suppliers.forEach((id, supplier) -> {
            Object entry = supplier.get();
            this.entries.put((class_2960)id, entry);
            this.suppliers.remove(entry);
            this.callbacks.forEach(callbacks -> callbacks.accept(entry));
        });
    }

    @Nullable
    public T get(class_2960 name) {
        if (!this.entries.containsKey(name)) {
            if (this.suppliers.containsKey(name)) {
                Object entry = this.suppliers.get(name).get();
                this.entries.put(name, entry);
                this.suppliers.remove(entry);
                this.callbacks.forEach(callbacks -> callbacks.accept(entry));
                return entry;
            }
            return null;
        }
        return this.entries.get(name);
    }

    @Nullable
    public T get(String name) {
        return this.get(Miapi.id(name));
    }

    public T remove(class_2960 id) {
        return this.entries.remove(id);
    }

    public void addCallback(Consumer<T> callback) {
        this.callbacks.add(callback);
        this.entries.values().forEach(callback);
    }

    public String getName() {
        for (Class<?> key : REGISTRY_MAP.keySet()) {
            if (REGISTRY_MAP.get(key) != this) continue;
            return key.getName();
        }
        return "Unknown Registry";
    }

    public Map<class_2960, T> getFlatMap() {
        return this.entries;
    }

    public Codec<T> codec() {
        return class_2960.field_25139.xmap(this::get, this::findKey);
    }
}

