/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.blocks;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.block.state.properties.Property;
import smartin.miapi.blocks.ModularWorkBench;
import smartin.miapi.blocks.ModularWorkBenchEntity;
import smartin.miapi.item.modular.VisualModularItem;
import smartin.miapi.item.modular.items.shield.ModularNonVanillaShield;
import smartin.miapi.item.modular.items.shield.ModularVanillaShield;

public class ModularWorkBenchRenderer
implements BlockEntityRenderer<ModularWorkBenchEntity> {
    private final BlockEntityRendererProvider.Context context;

    public ModularWorkBenchRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(ModularWorkBenchEntity be, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        ItemStack stack = be.getItem();
        if (stack.isEmpty()) {
            return;
        }
        matrices.pushPose();
        matrices.translate(0.5f, 1.03125f, 0.5f);
        float rotAmnt = ((Direction)be.getBlockState().getValue((Property)ModularWorkBench.FACING)).toYRot();
        rotAmnt = !(stack.getItem() instanceof Equipable) && (stack.getItem() instanceof VisualModularItem || stack.getItem() instanceof TieredItem || stack.getItem() instanceof SwordItem || stack.getItem() instanceof ArrowItem || stack.getItem() instanceof ProjectileWeaponItem) ? (rotAmnt -= 45.0f) : (rotAmnt -= 90.0f);
        matrices.mulPose(Axis.YP.rotationDegrees(rotAmnt));
        matrices.mulPose(Axis.XP.rotationDegrees(90.0f));
        matrices.scale(0.75f, 0.75f, 0.75f);
        if (stack.getItem() instanceof ShieldItem || stack.getItem() instanceof ModularNonVanillaShield || stack.getItem() instanceof ModularVanillaShield) {
            matrices.scale(2.0f, 2.0f, 2.0f);
        }
        try {
            this.context.getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, light, overlay, matrices, vertexConsumers, be.getLevel(), 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        matrices.popPose();
    }
}

