/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.atlas;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.client.model.MiapiItemModel;
import smartin.miapi.mixin.client.ElytraEntityModelAccessor;
import smartin.miapi.mixin.client.ElytraFeatureRendererAccessor;
import smartin.miapi.mixin.client.LivingEntityRendererAccessor;

@OnlyIn(value=Dist.CLIENT)
public class ArmorModelManager {
    public static List<ArmorPartProvider> partProviders = new ArrayList<ArmorPartProvider>();

    public static void renderArmorPiece(PoseStack matrices, MultiBufferSource vertexConsumers, int light, EquipmentSlot armorSlot, ItemStack itemStack, LivingEntity entity, HumanoidModel outerModel, EntityModel entityModel) {
        partProviders.forEach(armorPartProvider -> {
            List<ArmorPart> armorParts = armorPartProvider.getParts(armorSlot, entity, outerModel, entityModel);
            armorParts.forEach(armorPart -> {
                matrices.pushPose();
                String key = armorPart.apply(matrices, armorSlot, entity, outerModel, entityModel);
                MiapiItemModel miapiItemModel = MiapiItemModel.getItemModel(itemStack);
                if (miapiItemModel != null) {
                    miapiItemModel.render(key, itemStack, matrices, ItemDisplayContext.HEAD, 0.0f, vertexConsumers, entity, light, OverlayTexture.NO_OVERLAY);
                }
                matrices.popPose();
            });
        });
    }

    static {
        partProviders.add(new ModelPartProvider());
        partProviders.add(new ElytraPartProvider());
    }

    public static interface ArmorPartProvider {
        public List<ArmorPart> getParts(EquipmentSlot var1, LivingEntity var2, HumanoidModel<?> var3, EntityModel var4);
    }

    public static interface ArmorPart {
        public String apply(PoseStack var1, EquipmentSlot var2, LivingEntity var3, HumanoidModel<?> var4, EntityModel var5);
    }

    public static final class ModelPartProvider
    implements ArmorPartProvider {
        private static final String[] modelParts = new String[]{"head", "hat", "left_arm", "right_arm", "left_leg", "right_leg", "body"};

        @Override
        public List<ArmorPart> getParts(EquipmentSlot equipmentSlot, LivingEntity livingEntity, HumanoidModel<?> model, EntityModel entityModel) {
            ArrayList<ArmorPart> parts = new ArrayList<ArmorPart>();
            for (String key : modelParts) {
                parts.add((matrixStack, equipmentSlot1, livingEntity1, model1, entityModel1) -> {
                    entityModel1.copyPropertiesTo((EntityModel)model1);
                    ModelPart part = ModelPartProvider.getModelPart(model1, key);
                    part.translateAndRotate(matrixStack);
                    return key;
                });
            }
            return parts;
        }

        private static ModelPart getModelPart(HumanoidModel<?> model, String name) {
            return switch (name) {
                case "head" -> model.head;
                case "hat" -> model.hat;
                case "left_arm" -> model.leftArm;
                case "right_arm" -> model.rightArm;
                case "left_leg" -> model.leftLeg;
                case "right_leg" -> model.rightLeg;
                default -> model.body;
            };
        }
    }

    public static final class ElytraPartProvider
    implements ArmorPartProvider {
        @Override
        public List<ArmorPart> getParts(EquipmentSlot equipmentSlot, LivingEntity livingEntity, HumanoidModel<?> model, EntityModel entityModel) {
            LivingEntityRenderer livingEntityRenderer;
            Optional<Object> elytraFeatureRenderer;
            ArrayList<ArmorPart> parts = new ArrayList<ArmorPart>();
            EntityRenderer entityRenderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)livingEntity);
            if (entityRenderer instanceof LivingEntityRenderer && (elytraFeatureRenderer = ((LivingEntityRendererAccessor)(livingEntityRenderer = (LivingEntityRenderer)entityRenderer)).getFeatures().stream().filter(a -> a instanceof ElytraLayer).findAny()).isPresent()) {
                ElytraModel elytraEntityModel = ((ElytraFeatureRendererAccessor)elytraFeatureRenderer.get()).getElytra();
                livingEntity.getYHeadRot();
                livingEntity.getViewXRot(0.0f);
                livingEntity.getAgeScale();
                elytraEntityModel.setupAnim(livingEntity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
                parts.add((matrixStack, equipmentSlot1, livingEntity1, model1, entityModel1) -> {
                    entityModel.copyPropertiesTo((EntityModel)elytraEntityModel);
                    entityModel1.copyPropertiesTo((EntityModel)model1);
                    ModelPart part = ((ElytraEntityModelAccessor)elytraEntityModel).getLeftWing();
                    part.translateAndRotate(matrixStack);
                    return "left_wing";
                });
                parts.add((matrixStack, equipmentSlot1, livingEntity1, model1, entityModel1) -> {
                    entityModel.copyPropertiesTo((EntityModel)elytraEntityModel);
                    entityModel1.copyPropertiesTo((EntityModel)model1);
                    ModelPart part = ((ElytraEntityModelAccessor)elytraEntityModel).getRightWing();
                    part.translateAndRotate(matrixStack);
                    return "right_wing";
                });
                return parts;
            }
            return parts;
        }
    }
}

