/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.atlas;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.serialization.MapCodec;
import com.redpxnda.nucleus.codec.auto.AutoCodec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.SpriteTicker;
import net.minecraft.client.renderer.texture.atlas.SpriteResourceLoader;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceType;
import net.minecraft.client.resources.metadata.animation.FrameSize;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceMetadata;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Miapi;
import smartin.miapi.client.atlas.MaterialSpriteManager;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.mixin.SpriteSourcesAccessor;
import smartin.miapi.mixin.client.SpriteContentsAccessor;

public class BufferSpriteAdder
implements SpriteSource {
    public static MapCodec<? extends SpriteSource> CODEC = AutoCodec.of(BufferSpriteAdder.class);
    public static SpriteSourceType TYPE = SpriteSourcesAccessor.callRegister("miapi_runtime", CODEC);

    public void run(ResourceManager resourceManager, SpriteSource.Output output) {
        MaterialSpriteManager.ATLAS_SPRITE_POOL.clear();
        MaterialSpriteManager.FAST_CACHE.clear();
        MiapiConfig.getClientConfig().other.cacheSprites.forEach(cacheSprites -> {
            for (int i = 0; i < cacheSprites.count; ++i) {
                List slots = MaterialSpriteManager.ATLAS_SPRITE_POOL.computeIfAbsent(MaterialSpriteManager.resToKey(cacheSprites.x, cacheSprites.y), s -> new ArrayList());
                ResourceLocation id = Miapi.id("runtime_" + cacheSprites.x + "x" + cacheSprites.y + "-" + i);
                NativeImage nativeImage = new NativeImage(cacheSprites.x, cacheSprites.y, false);
                final SpriteContents contents = new SpriteContents(this, id, new FrameSize(cacheSprites.x, cacheSprites.y), nativeImage, ResourceMetadata.EMPTY){
                    SpriteContents thisContents = this;

                    @Nullable
                    public SpriteTicker createTicker() {
                        return new SpriteTicker(){

                            public void tickAndUpload(int x, int y) {
                                thisContents.uploadFirstFrame(x, y);
                            }

                            public void close() {
                                thisContents.close();
                            }
                        };
                    }
                };
                output.add(id, new SpriteSource.SpriteSupplier(){

                    public SpriteContents apply(SpriteResourceLoader spriteResourceLoader) {
                        return contents;
                    }
                });
                slots.add(new MaterialSpriteManager.SpriteSlot(id, cacheSprites.x, cacheSprites.y, contents, n -> ((SpriteContentsAccessor)contents).getImage().copyFrom(n)));
            }
        });
    }

    public SpriteSourceType type() {
        return TYPE;
    }
}

