/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.atlas;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.architectury.event.EventResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.client.AnimatedTexturesManager;
import smartin.miapi.client.MiapiClient;
import smartin.miapi.client.renderer.MovedVertexConsumer;
import smartin.miapi.client.renderer.RescaledVertexConsumer;
import smartin.miapi.config.MiapiConfig;
import smartin.miapi.datapack.ReloadEvents;
import smartin.miapi.events.MiapiEvents;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.palette.SpriteColorer;
import smartin.miapi.mixin.client.SpriteContentsAccessor;

@OnlyIn(value=Dist.CLIENT)
public class MaterialSpriteManager {
    static Map<Holder, DynamicTexture> animated_Textures = new HashMap<Holder, DynamicTexture>();
    public static final long CACHE_SIZE = 10000L;
    public static final long CACHE_LIFETIME = 10L;
    public static final TimeUnit CACHE_LIFETIME_UNIT = TimeUnit.SECONDS;
    protected static Map<ResourceLocation, DynamicTexture> nativeImageBackedTextureMap = new HashMap<ResourceLocation, DynamicTexture>();
    public static Set<TextureAtlasSprite> animated = new HashSet<TextureAtlasSprite>();
    public static final Map<Integer, List<SpriteSlot>> ATLAS_SPRITE_POOL = new HashMap<Integer, List<SpriteSlot>>();
    public static final Map<Holder, SpriteSlot> FAST_CACHE = new HashMap<Holder, SpriteSlot>();
    public static final List<SpriteSlot> ANIMATED_ATLAS_SPRITES = new ArrayList<SpriteSlot>();
    protected static final Cache<Holder, ResourceLocation> materialSpriteCache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterAccess(10L, CACHE_LIFETIME_UNIT).removalListener(notification -> {
        if (notification.wasEvicted()) {
            Object patt1$temp;
            Object patt0$temp = notification.getValue();
            if (patt0$temp instanceof ResourceLocation) {
                ResourceLocation removeId = (ResourceLocation)patt0$temp;
                DynamicTexture texture = nativeImageBackedTextureMap.get(removeId);
                if (texture != null) {
                    texture.close();
                }
                Minecraft.getInstance().getTextureManager().release(removeId);
            }
            if ((patt1$temp = notification.getKey()) instanceof Holder) {
                Holder holder = (Holder)patt1$temp;
                animated_Textures.remove(holder);
                try {
                    holder.colorer.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }).build((CacheLoader)new CacheLoader<Holder, ResourceLocation>(){

        @NotNull
        public ResourceLocation load(@NotNull Holder key) {
            return MaterialSpriteManager.getMaterialSprite(key);
        }
    });

    public static ResourceLocation getMaterialSprite(Holder holder) {
        ResourceLocation identifier = (ResourceLocation)materialSpriteCache.getIfPresent((Object)holder);
        if (identifier == null) {
            SpriteColorer.MaterialRecoloredSpriteHolder colorer = holder.colorer().createSpriteManager(holder.sprite().contents());
            DynamicTexture nativeImageBackedTexture = new DynamicTexture(colorer.recolor().mappedCopy(IntUnaryOperator.identity()));
            ResourceLocation spriteId = Minecraft.getInstance().getTextureManager().register("miapi/dynmaterialsprites", nativeImageBackedTexture);
            if (colorer.requireTick()) {
                animated_Textures.put(holder, nativeImageBackedTexture);
            }
            materialSpriteCache.put((Object)holder, (Object)spriteId);
            return spriteId;
        }
        return identifier;
    }

    public static void clear() {
        materialSpriteCache.invalidateAll();
        ANIMATED_ATLAS_SPRITES.clear();
        FAST_CACHE.forEach((h, s) -> {
            s.used = 0;
        });
        FAST_CACHE.clear();
    }

    public static void tick() {
        if (!ReloadEvents.isInReload()) {
            ArrayList toRemove = new ArrayList();
            animated_Textures.forEach((holder, nativeImageBackedTexture) -> {
                try {
                    holder.colorer.tick(nativeImage -> {
                        Objects.requireNonNull(nativeImageBackedTexture.getPixels()).copyFrom(nativeImage);
                        nativeImageBackedTexture.upload();
                    }, holder.sprite().contents());
                }
                catch (Exception e) {
                    toRemove.add(holder);
                }
            });
            ANIMATED_ATLAS_SPRITES.forEach(slot -> {
                AnimatedTexturesManager.markAnimated(slot.getSprite());
                slot.updateSprite();
            });
            toRemove.forEach(arg_0 -> materialSpriteCache.invalidate(arg_0));
            ArrayList toRemoveFAST = new ArrayList();
            FAST_CACHE.forEach((h, s) -> {
                --s.used;
                if (s.used < 1) {
                    toRemoveFAST.add(h);
                    s.clear();
                    ANIMATED_ATLAS_SPRITES.remove(s);
                }
            });
            toRemoveFAST.forEach(h -> {
                SpriteSlot slot = FAST_CACHE.remove(h);
                ATLAS_SPRITE_POOL.computeIfAbsent(MaterialSpriteManager.resToKey(slot.x, slot.y), s -> new ArrayList()).add(slot);
            });
            for (TextureAtlasSprite sprite : animated) {
                AnimatedTexturesManager.markAnimated(sprite);
            }
        }
    }

    public static void markTextureAsAnimatedInUse(TextureAtlasSprite sprite) {
        if (MiapiClient.isSodiumLoaded()) {
            animated.add(sprite);
        }
    }

    public static VertexConsumer getVertexConsumer(MultiBufferSource vertexConsumers, TextureAtlasSprite originalSprite, Material material, SpriteColorer materialSpriteColorer) {
        Holder holder = new Holder(originalSprite, material, materialSpriteColorer);
        if (!MiapiConfig.getClientConfig().other.disableFastRender) {
            SpriteSlot spriteSlot = FAST_CACHE.get(holder);
            if (spriteSlot == null && (spriteSlot = MaterialSpriteManager.getFreeAtlasSlot(((SpriteContentsAccessor)originalSprite.contents()).getWidth(), ((SpriteContentsAccessor)originalSprite.contents()).getHeight())) != null) {
                spriteSlot.used = 4;
                spriteSlot.holder = holder;
                FAST_CACHE.put(holder, spriteSlot);
                if (holder.colorer().doTick()) {
                    ANIMATED_ATLAS_SPRITES.add(spriteSlot);
                    AnimatedTexturesManager.markAnimated(spriteSlot.sprite);
                }
                spriteSlot.updateSprite();
            }
            if (spriteSlot != null && spriteSlot.used < 4) {
                return MaterialSpriteManager.getBlockAtlasVertexConsumer(vertexConsumers, originalSprite, holder, spriteSlot);
            }
        }
        return MaterialSpriteManager.getDynamicTextureVertexConsumer(vertexConsumers, originalSprite, holder);
    }

    @NotNull
    private static VertexConsumer getBlockAtlasVertexConsumer(MultiBufferSource vertexConsumers, TextureAtlasSprite originalSprite, Holder holder, SpriteSlot spriteSlot) {
        spriteSlot.used = 3;
        return new MovedVertexConsumer(ItemRenderer.getFoilBufferDirect((MultiBufferSource)vertexConsumers, (RenderType)ItemBlockRenderTypes.getRenderType((ItemStack)ItemStack.EMPTY, (boolean)false), (boolean)true, (boolean)false), originalSprite, spriteSlot.getSprite());
    }

    @NotNull
    private static RescaledVertexConsumer getDynamicTextureVertexConsumer(MultiBufferSource vertexConsumers, TextureAtlasSprite originalSprite, Holder holder) {
        ResourceLocation replaceId = MaterialSpriteManager.getMaterialSprite(holder);
        RenderType atlasRenderLayer = RenderType.entityTranslucentCull((ResourceLocation)replaceId);
        VertexConsumer atlasConsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)vertexConsumers, (RenderType)atlasRenderLayer, (boolean)true, (boolean)false);
        return new RescaledVertexConsumer(atlasConsumer, originalSprite);
    }

    @Nullable
    public static SpriteSlot getFreeAtlasSlot(int width, int height) {
        int key = width << 16 | height;
        List<SpriteSlot> slots = ATLAS_SPRITE_POOL.get(key);
        if (slots == null) {
            return null;
        }
        for (int i = 0; i < slots.size(); ++i) {
            SpriteSlot slot = slots.get(i);
            if (slot.used >= 1) continue;
            slots.remove(slot);
            return slot;
        }
        return null;
    }

    public static int resToKey(int width, int height) {
        return width << 16 | height;
    }

    static {
        MiapiEvents.CLEAR_CACHE.register(() -> {
            MaterialSpriteManager.clear();
            return EventResult.pass();
        });
    }

    public record Holder(TextureAtlasSprite sprite, Material material, SpriteColorer colorer) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Holder holder = (Holder)o;
            return Objects.equals(this.sprite, holder.sprite) && Objects.equals(this.material, holder.material) && Objects.equals(this.colorer, holder.colorer);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.sprite, this.material, this.colorer);
        }
    }

    public static class SpriteSlot {
        public int used = 0;
        public ResourceLocation internalID;
        public Consumer<NativeImage> update;
        public int x;
        public int y;
        public final SpriteContents contents;
        public TextureAtlasSprite sprite;
        public Holder holder;

        public SpriteSlot(ResourceLocation id, int x, int y, SpriteContents contents, Consumer<NativeImage> update) {
            this.contents = contents;
            this.internalID = id;
            this.x = x;
            this.y = y;
            this.update = update;
        }

        public TextureAtlasSprite getSprite() {
            if (this.sprite == null) {
                this.sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(this.internalID);
            }
            return this.sprite;
        }

        public int width() {
            return this.x;
        }

        public int height() {
            return this.y;
        }

        public void updateSprite() {
            if (this.holder != null) {
                this.update.accept(this.holder.colorer().createSpriteManager(this.holder.sprite().contents()).recolor());
            }
        }

        public void clear() {
            NativeImage image = new NativeImage(this.x, this.y, false);
            for (int x = 0; x < this.x; ++x) {
                for (int y = 0; y < this.y; ++y) {
                    image.setPixelRGBA(x, y, 0);
                }
            }
            this.update.accept(image);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            SpriteSlot that = (SpriteSlot)object;
            return Objects.equals(this.internalID, that.internalID);
        }

        public int hashCode() {
            return Objects.hashCode(this.internalID);
        }
    }
}

