/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.client.gui.InteractAbleWidget;

@OnlyIn(value=Dist.CLIENT)
public class BoxList
extends InteractAbleWidget {
    private final List<List<AbstractWidget>> allRows = new ArrayList<List<AbstractWidget>>();
    private List<? extends AbstractWidget> currentWidgets = new ArrayList<AbstractWidget>();
    private int space = 5;

    public BoxList(int x, int y, int width, int height, Component message, List<AbstractWidget> widgets) {
        super(x, y, width, height, message);
        this.setWidgets(widgets, this.space);
    }

    public void setSpace(int space) {
        this.space = space;
        ArrayList widgets = new ArrayList();
        this.setWidgets(widgets, space);
    }

    public void setWidgets(@Nullable List<? extends AbstractWidget> widgets, int space) {
        this.children().clear();
        this.space = space;
        if (widgets == null) {
            widgets = new ArrayList<AbstractWidget>();
        }
        this.currentWidgets = widgets;
        LinkedHashMap byHeight = new LinkedHashMap();
        widgets.forEach(widget -> {
            byHeight.putIfAbsent(widget.getHeight(), new ArrayList());
            ((List)byHeight.get(widget.getHeight())).add(widget);
        });
        int currentHeight = this.getY();
        while (!byHeight.isEmpty()) {
            List toAdd = (List)byHeight.remove(((HashMap)byHeight).keySet().stream().findAny().get());
            toAdd.sort(Comparator.comparingInt(AbstractWidget::getHeight));
            while (!toAdd.isEmpty()) {
                AbstractWidget widget2 = (AbstractWidget)toAdd.remove(0);
                int currentWidth = 0;
                ArrayList<AbstractWidget> currentRow = new ArrayList<AbstractWidget>();
                currentRow.add(widget2);
                widget2.setX(this.getX() + currentWidth + space);
                widget2.setY(currentHeight + space);
                this.addChild((GuiEventListener)widget2);
                currentWidth += widget2.getWidth() + space;
                for (int i = 0; i < toAdd.size(); ++i) {
                    if (currentWidth + ((AbstractWidget)toAdd.get(i)).getWidth() > this.getWidth()) continue;
                    AbstractWidget next = (AbstractWidget)toAdd.remove(i);
                    next.setX(this.getX() + currentWidth + space);
                    next.setY(currentHeight + space);
                    currentWidth += next.getWidth() + space;
                    this.addChild((GuiEventListener)next);
                }
                currentHeight += widget2.getHeight() + space;
                this.allRows.add(currentRow);
            }
        }
        this.height = currentHeight - this.getY();
    }

    public void setX(int x) {
        if (this.getX() != x) {
            super.setX(x);
            this.setWidgets(this.currentWidgets, this.space);
        }
    }

    public void setY(int y) {
        if (this.getY() != y) {
            super.setY(y);
            this.setWidgets(this.currentWidgets, this.space);
        }
    }

    public void setWidth(int widths) {
        if (this.getWidth() != this.width) {
            super.setWidth(this.width);
            this.setWidgets(this.currentWidgets, this.space);
        }
    }

    @Override
    public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.renderWidget(context, mouseX, mouseY, delta);
    }
}

