/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FastColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.config.MiapiConfig;

@OnlyIn(value=Dist.CLIENT)
public class MultiLineTextWidget
extends InteractAbleWidget {
    public Component rawText;
    public List<Component> lines = new ArrayList<Component>();
    private int longestLine;
    public int maxLineLength;
    public Font textRenderer;
    public int spacer;
    public boolean hasTextShadow;
    public int textColor;

    public MultiLineTextWidget(int x, int y, int width, int height, Component text) {
        super(x, y, width, height, (Component)Component.empty());
        this.textRenderer = Minecraft.getInstance().font;
        this.spacer = 1;
        this.hasTextShadow = true;
        this.textColor = FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255);
        this.maxLineLength = width;
        this.setText(text);
    }

    public void setText(Component text) {
        this.rawText = text;
        List rawLines = Arrays.stream(text.getString().split("\n")).collect(Collectors.toList());
        this.lines.clear();
        while (!rawLines.isEmpty()) {
            MutableComponent line;
            int size;
            String rawLine = (String)rawLines.remove(0);
            if (this.maxLineLength > 0 && this.textRenderer.width(rawLine) > this.maxLineLength) {
                List<Object> words = MiapiConfig.getClientConfig().other.splitNewLineAlways ? rawLine.chars().mapToObj(c -> String.valueOf((char)c)).collect(Collectors.toList()) : new ArrayList<String>(Arrays.stream(rawLine.split(" ")).toList());
                StringBuilder currentLine = new StringBuilder();
                currentLine.append((String)words.remove(0));
                if (!MiapiConfig.getClientConfig().other.splitNewLineAlways) {
                    currentLine.append(" ");
                }
                StringBuilder nextLine = new StringBuilder();
                int currentLineLength = 0;
                boolean isLineExceeded = false;
                for (String word : words) {
                    StringBuilder part;
                    int wordLength = this.textRenderer.width(word);
                    if (wordLength > this.maxLineLength) {
                        part = new StringBuilder();
                        for (char c2 : word.toCharArray()) {
                            part.append(c2);
                            if (this.textRenderer.width(part.toString()) <= this.maxLineLength) continue;
                            rawLines.add(0, word.substring(part.length() - 1));
                            word = part.substring(0, part.length() - 1);
                            break;
                        }
                        rawLines.add(0, word);
                        break;
                    }
                    if (!isLineExceeded && currentLineLength + wordLength + 1 <= this.maxLineLength) {
                        currentLine.append(word);
                        if (!MiapiConfig.getClientConfig().other.splitNewLineAlways) {
                            currentLine.append(" ");
                        }
                        currentLineLength = this.textRenderer.width(currentLine.toString());
                        continue;
                    }
                    if (currentLineLength == 0 && wordLength > this.maxLineLength) {
                        part = new StringBuilder();
                        for (char c2 : word.toCharArray()) {
                            part.append(c2);
                            if (this.textRenderer.width(part.toString()) <= this.maxLineLength) continue;
                            rawLines.add(0, word.substring(part.length() - 1));
                            word = part.substring(0, part.length() - 1);
                            break;
                        }
                        rawLines.add(0, word);
                        break;
                    }
                    nextLine.append(word);
                    if (!MiapiConfig.getClientConfig().other.splitNewLineAlways) {
                        nextLine.append(" ");
                    }
                    isLineExceeded = true;
                }
                if (isLineExceeded) {
                    rawLines.add(0, nextLine.toString());
                }
                rawLine = currentLine.toString().trim();
            }
            if ((size = this.textRenderer.width((FormattedText)(line = Component.translatable((String)rawLine)))) > this.longestLine) {
                this.longestLine = size;
            }
            this.lines.add((Component)line);
        }
        this.width = this.longestLine;
        int n = this.lines.size();
        Objects.requireNonNull(this.textRenderer);
        this.height = n * 9 + Math.max(0, this.lines.size() - 1) * this.spacer;
    }

    @Override
    public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        int start = this.getY();
        for (Component line : this.lines) {
            context.drawString(this.textRenderer, line, this.getX(), start, this.textColor, this.hasTextShadow);
            Objects.requireNonNull(this.textRenderer);
            start += 9 + this.spacer;
        }
        super.renderWidget(context, mouseX, mouseY, delta);
    }
}

