/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.TransformableWidget;
import smartin.miapi.client.gui.crafting.CraftingScreen;

@OnlyIn(value=Dist.CLIENT)
public class ScrollList
extends InteractAbleWidget {
    public List<InteractAbleWidget> widgets = null;
    private int scrollAmount = 0;
    private int maxScrollAmount = 0;
    public boolean saveMode = true;
    boolean needsScrollbar = false;
    public boolean alwaysEnableScrollbar = false;
    int barWidth = 8;
    boolean scrollbarDragged = false;
    public boolean altDesign = false;

    public ScrollList(int x, int y, int width, int height, List<InteractAbleWidget> widgets) {
        super(x, y, width, height, (Component)Component.empty());
        this.setList(widgets);
    }

    public void setList(List<InteractAbleWidget> widgets) {
        this.widgets = widgets;
        this.children().clear();
    }

    public void setScrollAmount(int amount) {
        this.scrollAmount = amount;
    }

    public int getScrollAmount() {
        return this.scrollAmount;
    }

    @Override
    public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        super.renderWidget(drawContext, mouseX, mouseY, delta);
        int totalHeight = 0;
        for (AbstractWidget abstractWidget : this.widgets) {
            totalHeight += abstractWidget.getHeight();
        }
        this.maxScrollAmount = Math.max(0, totalHeight - this.height);
        if (this.widgets == null) {
            return;
        }
        this.scrollAmount = Math.max(0, Math.min(this.scrollAmount, this.maxScrollAmount));
        this.needsScrollbar = totalHeight > this.height;
        int startY = this.getY() - this.scrollAmount;
        for (AbstractWidget abstractWidget : this.widgets) {
            abstractWidget.setY(startY);
            if (startY + abstractWidget.getHeight() >= this.getY() && startY <= this.getY() + this.height - 1) {
                abstractWidget.setX(this.getX());
                if (this.showScrollbar()) {
                    abstractWidget.setWidth(this.width - this.barWidth);
                } else {
                    abstractWidget.setWidth(this.width);
                }
                Matrix4f matrix4f = new Matrix4f((Matrix4fc)drawContext.pose().last().pose());
                Vector4f posX = TransformableWidget.transFormMousePos(this.getX(), this.getY(), matrix4f);
                Vector4f posY = TransformableWidget.transFormMousePos(this.getX() + this.width, this.getY() + this.height, matrix4f);
                drawContext.enableScissor((int)posX.x(), (int)posX.y, (int)posY.x(), (int)posY.y());
                abstractWidget.render(drawContext, mouseX, mouseY, delta);
                drawContext.disableScissor();
            }
            startY += abstractWidget.getHeight();
        }
        if (this.showScrollbar()) {
            int n = this.getX() + this.width - this.barWidth;
            float f = (float)this.scrollAmount / (float)this.maxScrollAmount;
            this.renderScrollbarBackground(drawContext, mouseX, mouseY, delta, n, this.barWidth);
            this.renderScrollbarClickAble(drawContext, mouseX, mouseY, delta, n, this.barWidth, f);
        }
    }

    public void renderScrollbarBackground(GuiGraphics drawContext, int mouseX, int mouseY, float delta, int barX, int barWidth) {
        int offsetAlt = this.altDesign ? 28 : 0;
        ScrollList.drawTextureWithEdge(drawContext, CraftingScreen.BACKGROUND_TEXTURE, barX, this.getY(), 498 - offsetAlt, 96, 14, 15, barWidth, this.getHeight(), 512, 512, 3);
    }

    public void renderScrollbarClickAble(GuiGraphics drawContext, int mouseX, int mouseY, float delta, int barX, int barWidth, float percent) {
        int height = (int)((float)(this.getHeight() - 17) * percent) + (this.altDesign ? (percent >= 1.0f ? 2 : 0) : 1) + this.getY();
        int offset = this.needsScrollbar ? 0 : 15;
        int offsetAlt = this.altDesign ? 28 : 0;
        ScrollList.drawTextureWithEdge(drawContext, CraftingScreen.BACKGROUND_TEXTURE, barX, height, 484 - offsetAlt, 96 + offset, 14, 15, barWidth, 15, 512, 512, 3);
    }

    private boolean showScrollbar() {
        return this.needsScrollbar || this.alwaysEnableScrollbar;
    }

    @Override
    public void renderHover(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        if (this.isMouseOver(mouseX, mouseY)) {
            int startY = this.getY() - this.scrollAmount;
            for (AbstractWidget abstractWidget : this.widgets) {
                if (startY + abstractWidget.getHeight() >= this.getY() && startY <= this.getY() + this.height - 1 && abstractWidget instanceof InteractAbleWidget) {
                    InteractAbleWidget interactAbleWidget = (InteractAbleWidget)abstractWidget;
                    abstractWidget.setY(startY);
                    abstractWidget.setX(this.getX());
                    if (this.showScrollbar()) {
                        abstractWidget.setWidth(this.width - this.barWidth);
                    } else {
                        abstractWidget.setWidth(this.width);
                    }
                    interactAbleWidget.renderHover(drawContext, mouseX, mouseY, delta);
                }
                startY += abstractWidget.getHeight();
            }
        }
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.widgets == null) {
            return false;
        }
        if (this.isMouseOver(mouseX, mouseY)) {
            for (AbstractWidget abstractWidget : this.widgets) {
                if (!abstractWidget.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) continue;
                return true;
            }
            int scrollSpeed = 10;
            this.scrollAmount = (int)((double)this.scrollAmount - scrollY * (double)scrollSpeed);
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.widgets != null) {
            for (InteractAbleWidget widget : this.widgets) {
                if (!widget.keyPressed(keyCode, scanCode, modifiers)) continue;
                return true;
            }
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (this.widgets != null) {
            for (InteractAbleWidget widget : this.widgets) {
                if (!widget.keyReleased(keyCode, scanCode, modifiers)) continue;
                return true;
            }
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (this.widgets == null) {
                return false;
            }
            boolean clicked = false;
            if (this.showScrollbar() && this.isMouseOver(mouseX, mouseY) && mouseX > (double)(this.getX() + this.width - this.barWidth) && mouseX < (double)(this.getX() + this.width)) {
                this.scrollbarDragged = true;
                return true;
            }
            for (AbstractWidget abstractWidget : this.widgets) {
                if (!abstractWidget.isMouseOver(mouseX, mouseY) || !abstractWidget.mouseClicked(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (mouseX > (double)(this.getX() + this.width - this.barWidth) && mouseX < (double)(this.getX() + this.width)) {
            if (mouseY < (double)this.getY()) {
                this.scrollAmount = 0;
                return true;
            }
            if (mouseY > (double)(this.getY() + this.height)) {
                this.scrollAmount = this.maxScrollAmount;
                return true;
            }
            double i = Math.min(1.0, Math.max(0.0, (mouseY - (double)this.getY()) / (double)(this.getHeight() - 10)));
            this.scrollAmount = (int)(i * (double)this.maxScrollAmount);
            return true;
        }
        for (InteractAbleWidget child : this.widgets) {
            if (!child.isMouseOver(mouseX, mouseY) || !child.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) continue;
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.widgets == null) {
            return false;
        }
        if (this.showScrollbar() && this.isMouseOver(mouseX, mouseY) && mouseX > (double)(this.getX() + this.width - this.barWidth) && mouseX < (double)(this.getX() + this.width)) {
            this.scrollbarDragged = false;
            return true;
        }
        boolean released = false;
        for (AbstractWidget abstractWidget : this.widgets) {
            if (!abstractWidget.mouseReleased(mouseX, mouseY, button)) continue;
            released = true;
        }
        return released;
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        if (!this.visible) {
            return false;
        }
        double x = this.getX();
        double y = this.getY();
        double width = this.width;
        double height = this.height;
        return mouseX >= x && mouseY >= y && mouseX < x + width && mouseY < y + height;
    }
}

