/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector4f;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.TransformableWidget;

@OnlyIn(value=Dist.CLIENT)
public class ScrollingTextWidget
extends InteractAbleWidget
implements Renderable,
GuiEventListener {
    private Component text = Component.empty();
    private float timer = 0.0f;
    private int scrollPosition = 0;
    public int textColor;
    public float scrollDelay = 0.5f;
    public float scrollHoldTime = 2.0f;
    public float firstLetterExtraTime = 1.0f;
    public boolean hasTextShadow = true;
    private Orientation orientation;

    public ScrollingTextWidget(int x, int y, int maxWidth, Component text, int textColor) {
        super(x, y, maxWidth, 9, (Component)Component.empty());
        this.textColor = textColor;
        this.setText(text);
        this.orientation = Orientation.LEFT;
    }

    public ScrollingTextWidget(int x, int y, int maxWidth, Component text) {
        super(x, y, maxWidth, 9, (Component)Component.empty());
        this.textColor = -1;
        this.setText(text);
        this.orientation = Orientation.LEFT;
    }

    public void setText(Component text) {
        this.text = text == null ? Component.empty() : text;
        this.scrollPosition = 0;
        this.timer = -this.firstLetterExtraTime;
    }

    public Component getText() {
        return this.text == null ? Component.literal((String)"Missing Text!") : this.text;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    @Override
    public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        int textWidth = Minecraft.getInstance().font.width((FormattedText)this.getText());
        boolean scissorEnabled = false;
        int textStart = this.getX();
        switch (this.orientation.ordinal()) {
            case 1: {
                textStart += (this.width - textWidth) / 2;
                break;
            }
            case 2: {
                textStart += this.width - textWidth;
            }
        }
        if (textWidth > this.width) {
            String string = this.getText().getString();
            int offsetAmount = 0;
            boolean stallScrollPos = false;
            if (this.scrollPosition < string.length()) {
                String sub = string.substring(0, this.scrollPosition);
                String remaining = string.substring(Math.min(string.length() - 1, this.scrollPosition + 1));
                int subLength = Minecraft.getInstance().font.width(sub);
                int remainingLength = Minecraft.getInstance().font.width(remaining);
                offsetAmount = -subLength;
                if (remainingLength <= this.width) {
                    stallScrollPos = true;
                }
            }
            this.timer += delta / 20.0f;
            if (this.timer > this.scrollDelay && !stallScrollPos) {
                ++this.scrollPosition;
                this.timer = 0.0f;
            }
            if (this.timer > this.scrollHoldTime && stallScrollPos) {
                this.scrollPosition = 0;
                this.timer = -this.firstLetterExtraTime;
            }
            textStart += offsetAmount;
            Vector4f corner1 = TransformableWidget.transFormMousePos(this.getX(), this.getY(), context.pose().last().pose());
            Vector4f corner2 = TransformableWidget.transFormMousePos(this.getX() + this.width, this.getY() + this.height, context.pose().last().pose());
            context.enableScissor((int)corner1.x, (int)corner1.y, (int)corner2.x + 1, (int)corner2.y);
            scissorEnabled = true;
        }
        if (this.text != null) {
            context.drawString(Minecraft.getInstance().font, this.getText(), textStart, this.getY(), this.textColor, this.hasTextShadow);
        }
        if (scissorEnabled) {
            context.disableScissor();
        }
        super.renderWidget(context, mouseX, mouseY, delta);
    }

    public int getRequiredWidth() {
        return Math.min(this.width, Minecraft.getInstance().font.width((FormattedText)this.getText()));
    }

    public static enum Orientation {
        LEFT,
        CENTERED,
        RIGHT;

    }
}

