/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting;

import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.client.gui.InteractAbleWidget;

@OnlyIn(value=Dist.CLIENT)
public class MinimizeButton
extends InteractAbleWidget {
    private final Runnable onMinimized;
    private final Runnable onMaximized;
    private boolean isEnabled = true;
    private long timeClicked = -100L;

    public MinimizeButton(int x, int y, int width, int height, Runnable onMinimized, Runnable onMaximized) {
        super(x, y, width, height, (Component)Component.empty());
        this.onMinimized = onMinimized;
        this.onMaximized = onMaximized;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver(mouseX, mouseY)) {
            this.playClickedSound();
            if (this.isEnabled) {
                this.minimize();
            } else {
                this.maximize();
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void maximize() {
        if (!this.isEnabled) {
            this.timeClicked = Util.getMillis();
            this.onMaximized.run();
            this.isEnabled = true;
        }
    }

    public void minimize() {
        if (this.isEnabled) {
            this.timeClicked = Util.getMillis();
            this.onMinimized.run();
            this.isEnabled = false;
        }
    }

    public long getLastChangeTime() {
        return this.timeClicked;
    }

    @Override
    public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        super.renderWidget(drawContext, mouseX, mouseY, delta);
    }
}

