/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting;

import net.minecraft.client.Minecraft;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.Environment;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.item.modular.ModularItem;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.modules.edit_options.CreateItemOption.CreateItemOption;
import smartin.miapi.modules.edit_options.ReplaceOption;

public class PreviewManager {
    @Nullable
    public static Material currentPreviewMaterial = null;
    public static ItemStack currentPreviewMaterialStack = ItemStack.EMPTY;
    private static ItemStack cursorStack = ItemStack.EMPTY;
    private static Material lastFramePreviewMaterial = null;
    private static int noUpdate = 0;

    public static void setCursorItemstack(ItemStack itemstack) {
        if (Environment.isClient() && Minecraft.getInstance().isSameThread()) {
            if (cursorStack != itemstack || cursorStack != null && itemstack != null && cursorStack.equals(itemstack)) {
                Material material = MaterialProperty.getMaterialFromIngredient(itemstack);
                if (material != currentPreviewMaterial) {
                    cursorStack = itemstack;
                    PreviewManager.updateMaterial(material, cursorStack);
                } else {
                    noUpdate = 0;
                }
            } else {
                noUpdate = 0;
            }
        }
    }

    public static void resetCursorStack() {
        PreviewManager.setCursorItemstack(ItemStack.EMPTY);
    }

    public static void resetPreview() {
        ReplaceOption.resetPreview();
    }

    public static boolean hasValidPreview() {
        return currentPreviewMaterial != null;
    }

    public static void updateMaterial(Material material, ItemStack itemStack) {
        currentPreviewMaterial = material;
        currentPreviewMaterialStack = itemStack;
    }

    public static void tick() {
        CraftingScreen craftingScreen;
        ++noUpdate;
        if (lastFramePreviewMaterial != currentPreviewMaterial) {
            lastFramePreviewMaterial = currentPreviewMaterial;
            noUpdate = 0;
            if (CraftingScreen.getInstance() != null) {
                CraftingScreen craftingScreen2 = CraftingScreen.getInstance();
                ItemStack currentStack = craftingScreen2.getItem();
                if (currentStack.isEmpty() && craftingScreen2.getEditOption() == null) {
                    if (ModularItem.isModularItem(currentStack) || currentPreviewMaterial == null) {
                        craftingScreen2.updatePreviewItemStack(ItemStack.EMPTY);
                    } else {
                        craftingScreen2.updatePreviewItemStack(cursorStack);
                    }
                } else {
                    ReplaceOption.tryPreview();
                }
            }
        } else if (noUpdate > 5 && currentPreviewMaterial != null && CraftingScreen.getInstance() != null && (craftingScreen = CraftingScreen.getInstance()) != null) {
            ItemStack currentStack = craftingScreen.getItem();
            if (currentStack.isEmpty() && !(craftingScreen.getEditOption() instanceof CreateItemOption)) {
                craftingScreen.updatePreviewItemStack(ItemStack.EMPTY);
            } else {
                ReplaceOption.tryPreview();
                currentPreviewMaterial = null;
            }
        }
    }
}

