/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.crafter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ScrollList;
import smartin.miapi.client.gui.ScrollingTextWidget;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.properties.slot.SlotProperty;

@OnlyIn(value=Dist.CLIENT)
public class DetailView
extends InteractAbleWidget {
    final Consumer<SlotProperty.ModuleSlot> selectConsumer;
    final Map<SlotProperty.ModuleSlot, SlotButton> buttonMap = new HashMap<SlotProperty.ModuleSlot, SlotButton>();
    SlotProperty.ModuleSlot selectedSlot;
    ScrollList scrollList;
    public static int scrollPos = 0;

    public DetailView(int x, int y, int width, int height, SlotProperty.ModuleSlot baseSlot, SlotProperty.ModuleSlot selected, Consumer<SlotProperty.ModuleSlot> edit, Consumer<SlotProperty.ModuleSlot> replace, String slotType) {
        super(x, y, width, height, (Component)Component.empty());
        this.selectedSlot = selected;
        if (baseSlot != null) {
            this.scrollList = new ScrollList(x, y, width, height, this.getButtons(baseSlot, new ArrayList<InteractAbleWidget>(), 0, slotType));
            this.addChild(this.scrollList);
            this.scrollList.setScrollAmount(scrollPos);
        }
        this.selectConsumer = edit;
    }

    public List<InteractAbleWidget> getButtons(SlotProperty.ModuleSlot slot, List<InteractAbleWidget> buttons, int level, String slotType) {
        int nextLevel;
        if (slot.slotType.equals(slotType)) {
            buttons.add(new SlotButton(0, 0, 50, 22, slot, level));
            nextLevel = level + 1;
        } else {
            nextLevel = level;
        }
        if (slot.inSlot != null) {
            SlotProperty.getSlots(slot.inSlot).forEach((id, childSlot) -> {
                if (childSlot.slotType.equals(slotType)) {
                    this.getButtons((SlotProperty.ModuleSlot)childSlot, buttons, nextLevel, slotType);
                }
            });
        }
        return buttons;
    }

    public void select(SlotProperty.ModuleSlot slot) {
        scrollPos = this.scrollList.getScrollAmount();
        this.selectedSlot = slot;
        this.selectConsumer.accept(slot);
    }

    public void scrollTo(int y) {
        if (this.scrollList != null) {
            this.scrollList.setScrollAmount(y - this.getY());
        }
    }

    class SlotButton
    extends InteractAbleWidget {
        private final List<SlotButton> subSlots;
        private final ScrollingTextWidget moduleName;
        private final ScrollingTextWidget materialName;
        private final SlotProperty.ModuleSlot slot;
        private final Material material;
        private final int level;
        private final boolean isOpened = false;
        private final boolean isSelected = false;

        public SlotButton(int x, int y, int width, int height, SlotProperty.ModuleSlot slot, int level) {
            boolean hasNoModule;
            super(x, y, width, height, (Component)Component.empty());
            this.subSlots = new ArrayList<SlotButton>();
            this.isOpened = false;
            this.isSelected = false;
            this.slot = slot;
            this.level = level;
            ModuleInstance moduleInstance = slot.inSlot;
            boolean bl = hasNoModule = moduleInstance == null;
            if (hasNoModule) {
                moduleInstance = new ModuleInstance(ItemModule.empty);
            }
            Component materialNameText = moduleInstance.getModuleName();
            this.material = MaterialProperty.getMaterial(moduleInstance);
            Component displayText = moduleInstance.getModuleName();
            if (hasNoModule && slot.translationKey != null) {
                displayText = Component.translatable((String)slot.translationKey);
            }
            this.moduleName = new ScrollingTextWidget(this.getX() + 10, this.getY(), this.width - 20, displayText, FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
            this.materialName = new ScrollingTextWidget(this.getX() + 10, this.getY(), this.width - 20, materialNameText, FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
            this.materialName.setOrientation(ScrollingTextWidget.Orientation.RIGHT);
            DetailView.this.buttonMap.put(slot, this);
        }

        @Override
        public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
            super.renderWidget(drawContext, mouseX, mouseY, delta);
            int hoverOffset = 0;
            if (this.isMouseOver(mouseX, mouseY)) {
                hoverOffset = 1;
            }
            if (this.isHoveredOrFocused()) {
                hoverOffset = 2;
            }
            SlotButton.drawTextureWithEdge(drawContext, CraftingScreen.BACKGROUND_TEXTURE, this.getX() + (this.level - 1) * 2, this.getY(), 404, 18 * hoverOffset, 108, 18, this.getWidth() - (this.level - 1) * 2, this.getHeight(), 512, 512, 4);
            int nameStart = this.getX() + 5 + (this.level - 1) * 2;
            if (this.material != null && this.material.hasIcon()) {
                nameStart += 1 + this.material.renderIcon(drawContext, this.getX() + 5 + (this.level - 1) * 2, this.getY() + 3);
            }
            this.moduleName.setX(nameStart);
            this.moduleName.setY(this.getY() + 7);
            this.moduleName.setWidth(this.getWidth() + this.getX() - nameStart - 4);
            this.moduleName.render(drawContext, mouseX, mouseY, delta);
        }

        public boolean isHoveredOrFocused() {
            if (this.slot == DetailView.this.selectedSlot) {
                return true;
            }
            return this.slot != null && this.slot.equals(DetailView.this.selectedSlot);
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (button == 0 && this.isMouseOver(mouseX, mouseY)) {
                this.playClickedSound();
                DetailView.this.select(this.slot);
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }
    }
}

