/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.crafter;

import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.blocks.ModularWorkBenchEntity;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.crafting.CraftingScreenHandler;
import smartin.miapi.client.gui.crafting.crafter.CraftEditOption;
import smartin.miapi.client.gui.crafting.crafter.DetailView;
import smartin.miapi.client.gui.crafting.crafter.EditView;
import smartin.miapi.client.gui.crafting.crafter.replace.CraftOption;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.edit_options.EditOption;
import smartin.miapi.modules.properties.slot.SlotProperty;

@OnlyIn(value=Dist.CLIENT)
public class EditModuleCrafter
extends InteractAbleWidget {
    public ItemStack stack;
    public SlotProperty.ModuleSlot slot;
    private final SlotProperty.ModuleSlot baseSlot = new SlotProperty.ModuleSlot(new ArrayList<String>());
    Consumer<SlotProperty.ModuleSlot> selected;
    EditView editView;
    public CraftingScreenHandler handler;
    EditOption editOption;
    public EditOption.EditContext editContext;
    Mode currentMode = Mode.DETAIL;
    CraftOption craftOption;
    public String moduleType;

    public EditModuleCrafter(int x, int y, int width, int height, EditOption editOption, EditOption.EditContext editContext, String moduleType) {
        super(x, y, width, height, (Component)Component.empty());
        this.moduleType = moduleType;
        this.editOption = editOption;
        this.editContext = editContext;
        this.setMode(Mode.DETAIL);
    }

    public void setMode(Mode mode) {
        this.currentMode = mode;
        switch (mode.ordinal()) {
            case 1: {
                this.children().clear();
                DetailView detailView = new DetailView(this.getX(), this.getY(), this.width, this.height, this.editContext.getSlot(), this.editContext.getSlot(), toEdit -> {
                    if (toEdit == null) {
                        ArrayList<String> allowed = new ArrayList<String>();
                        allowed.add("");
                        allowed.add("melee");
                        toEdit = new SlotProperty.ModuleSlot(allowed);
                    }
                    this.slot = toEdit;
                    this.setMode(Mode.REPLACE);
                }, toReplace -> {
                    if (toReplace == null) {
                        ArrayList<String> allowed = new ArrayList<String>();
                        allowed.add("");
                        allowed.add("melee");
                        toReplace = new SlotProperty.ModuleSlot(allowed);
                    }
                    this.slot = toReplace;
                    this.setMode(Mode.REPLACE);
                }, this.moduleType);
                this.children.add(detailView);
                break;
            }
            case 0: {
                this.children.clear();
                CraftEditOption craftEditOption = new CraftEditOption(this.getX(), this.getY(), this.width, this.height, EditModuleCrafter.transform(this.editContext, this.slot));
                this.addChild(craftEditOption);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static EditOption.EditContext transform(final EditOption.EditContext context, final SlotProperty.ModuleSlot slot) {
        return new EditOption.EditContext(){

            @Override
            public void craft(FriendlyByteBuf craftBuffer) {
                context.craft(craftBuffer);
            }

            @Override
            public void preview(FriendlyByteBuf preview) {
                context.preview(preview);
            }

            @Override
            public SlotProperty.ModuleSlot getSlot() {
                return slot;
            }

            @Override
            public ItemStack getItemstack() {
                return context.getItemstack();
            }

            @Override
            @Nullable
            public ModuleInstance getInstance() {
                return context.getInstance();
            }

            @Override
            @Nullable
            public Player getPlayer() {
                return context.getPlayer();
            }

            @Override
            @Nullable
            public ModularWorkBenchEntity getWorkbench() {
                return context.getWorkbench();
            }

            @Override
            public Container getLinkedInventory() {
                return context.getLinkedInventory();
            }

            @Override
            public CraftingScreenHandler getScreenHandler() {
                return context.getScreenHandler();
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void addSlot(Slot slot2) {
                context.addSlot(slot2);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void removeSlot(Slot slot2) {
                context.removeSlot(slot2);
            }
        };
    }

    @Override
    public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        super.renderWidget(drawContext, mouseX, mouseY, delta);
    }

    public static enum Mode {
        REPLACE,
        DETAIL;

    }
}

