/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.crafter;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import smartin.miapi.blocks.ModularWorkBenchEntity;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ScrollList;
import smartin.miapi.client.gui.ScrollingTextWidget;
import smartin.miapi.client.gui.SimpleButton;
import smartin.miapi.client.gui.TransformableWidget;
import smartin.miapi.client.gui.crafting.CraftingScreenHandler;
import smartin.miapi.item.modular.StatResolver;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.modules.edit_options.EditOption;
import smartin.miapi.modules.properties.slot.SlotProperty;
import smartin.miapi.network.Networking;
import smartin.miapi.registries.RegistryInventory;

@OnlyIn(value=Dist.CLIENT)
public class EditView
extends InteractAbleWidget {
    ItemStack stack;
    ModuleInstance instance;
    Consumer<ItemStack> previewConsumer;
    Consumer<Object> back;
    List<GuiEventListener> defaultChildren = new ArrayList<GuiEventListener>();
    EditOption.EditContext editContext;
    SlotProperty.ModuleSlot slot;
    List<Slot> currentSlots = new ArrayList<Slot>();

    public EditView(int x, int y, int width, int height, final ItemStack stack, final @Nullable SlotProperty.ModuleSlot slot, Consumer<ItemStack> preview, Consumer<Object> back) {
        super(x, y, width, height, (Component)Component.empty());
        this.previewConsumer = preview;
        this.stack = stack;
        this.slot = slot;
        if (slot != null) {
            this.instance = slot.inSlot;
        }
        this.clearSlots();
        this.back = back;
        float headerScale = 1.5f;
        TransformableWidget headerHolder = new TransformableWidget(x, y, width, height, headerScale);
        this.defaultChildren.add(headerHolder);
        ScrollingTextWidget header = new ScrollingTextWidget((int)((float)(this.getX() + 5) / headerScale), (int)((float)this.getY() / headerScale), (int)((float)(this.width - 10) / headerScale), (Component)Component.translatable((String)"miapi.ui.edit.header"), FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
        headerHolder.addChild(header);
        ScrollList list = new ScrollList(x, y + 16, width, height - 14, new ArrayList<InteractAbleWidget>());
        this.defaultChildren.add(list);
        list.children().clear();
        this.defaultChildren.add(new SimpleButton<Object>(this.getX() + 2, this.getY() + this.height - 10, 40, 12, (Component)Component.translatable((String)"miapi.ui.back"), stack, back));
        ArrayList<InteractAbleWidget> toList = new ArrayList<InteractAbleWidget>();
        this.editContext = new EditOption.EditContext(){

            @Override
            public void craft(FriendlyByteBuf packetByteBuf) {
            }

            @Override
            public void preview(FriendlyByteBuf preview) {
            }

            @Override
            public SlotProperty.ModuleSlot getSlot() {
                return slot;
            }

            @Override
            public ItemStack getItemstack() {
                return stack;
            }

            @Override
            @Nullable
            public ModuleInstance getInstance() {
                return EditView.this.instance;
            }

            @Override
            @Nullable
            public Player getPlayer() {
                return Minecraft.getInstance().player;
            }

            @Override
            @Nullable
            public ModularWorkBenchEntity getWorkbench() {
                AbstractContainerMenu abstractContainerMenu = Minecraft.getInstance().player.containerMenu;
                if (abstractContainerMenu instanceof CraftingScreenHandler) {
                    CraftingScreenHandler craftingScreenHandler = (CraftingScreenHandler)abstractContainerMenu;
                    return craftingScreenHandler.blockEntity;
                }
                return null;
            }

            @Override
            public Container getLinkedInventory() {
                AbstractContainerMenu abstractContainerMenu = Minecraft.getInstance().player.containerMenu;
                if (abstractContainerMenu instanceof CraftingScreenHandler) {
                    CraftingScreenHandler craftingScreenHandler = (CraftingScreenHandler)abstractContainerMenu;
                    return craftingScreenHandler.inventory;
                }
                return null;
            }

            @Override
            public CraftingScreenHandler getScreenHandler() {
                AbstractContainerMenu abstractContainerMenu = Minecraft.getInstance().player.containerMenu;
                if (abstractContainerMenu instanceof CraftingScreenHandler) {
                    CraftingScreenHandler craftingScreenHandler = (CraftingScreenHandler)abstractContainerMenu;
                    return craftingScreenHandler;
                }
                return null;
            }
        };
        RegistryInventory.EDIT_OPTION_MIAPI_REGISTRY.getFlatMap().forEach((s, editOption) -> {
            if (editOption.isVisible(this.editContext)) {
                ModuleInstance moduleInstance = null;
                if (this.instance != null) {
                    moduleInstance = this.instance.copy();
                }
                toList.add(new SlotButton(0, 0, this.width, 15, s.toString(), (EditOption)editOption, moduleInstance));
            }
        });
        list.setList(toList);
        this.setDefaultChildren();
    }

    public void clearSlots() {
        this.currentSlots.forEach(slot1 -> {
            AbstractContainerMenu patt0$temp = Minecraft.getInstance().player.containerMenu;
            if (patt0$temp instanceof CraftingScreenHandler) {
                CraftingScreenHandler handler = (CraftingScreenHandler)patt0$temp;
                handler.removeSlotByClient((Slot)slot1);
            }
        });
    }

    private void setDefaultChildren() {
        this.children().clear();
        this.defaultChildren.forEach(this::addChild);
    }

    public void setEditOption(final EditOption option) {
        this.editContext = new EditOption.EditContext(){

            @Override
            public void craft(FriendlyByteBuf packetByteBuf) {
                CraftingScreenHandler screenHandler = this.getScreenHandler();
                if (screenHandler instanceof CraftingScreenHandler) {
                    CraftingScreenHandler screenHandler1 = screenHandler;
                    ModuleInstance toCrafter = EditView.this.instance;
                    FriendlyByteBuf buf = Networking.createBuffer();
                    buf.writeUtf(RegistryInventory.EDIT_OPTION_MIAPI_REGISTRY.findKey(option).toString());
                    ArrayList<String> position = new ArrayList<String>();
                    if (toCrafter != null) {
                        toCrafter.calculatePosition(position);
                    }
                    Object sharedPos = "";
                    if (!position.isEmpty()) {
                        sharedPos = (String)position.removeFirst();
                    }
                    for (String entry : position) {
                        sharedPos = (String)sharedPos + "\n" + entry;
                    }
                    buf.writeUtf((String)sharedPos);
                    buf.writeBytes(packetByteBuf.copy());
                    Networking.sendC2S(screenHandler1.editPacketID, buf);
                }
                this.preview(packetByteBuf);
            }

            @Override
            public void preview(FriendlyByteBuf preview) {
                EditView.this.previewConsumer.accept(option.preview(preview, this));
            }

            @Override
            public SlotProperty.ModuleSlot getSlot() {
                return EditView.this.slot;
            }

            @Override
            public ItemStack getItemstack() {
                return EditView.this.stack;
            }

            @Override
            @Nullable
            public ModuleInstance getInstance() {
                return EditView.this.instance;
            }

            @Override
            @Nullable
            public Player getPlayer() {
                return Minecraft.getInstance().player;
            }

            @Override
            @Nullable
            public ModularWorkBenchEntity getWorkbench() {
                AbstractContainerMenu abstractContainerMenu = Minecraft.getInstance().player.containerMenu;
                if (abstractContainerMenu instanceof CraftingScreenHandler) {
                    CraftingScreenHandler craftingScreenHandler = (CraftingScreenHandler)abstractContainerMenu;
                    return craftingScreenHandler.blockEntity;
                }
                return null;
            }

            @Override
            public CraftingScreenHandler getScreenHandler() {
                AbstractContainerMenu abstractContainerMenu = Minecraft.getInstance().player.containerMenu;
                if (abstractContainerMenu instanceof CraftingScreenHandler) {
                    CraftingScreenHandler craftingScreenHandler = (CraftingScreenHandler)abstractContainerMenu;
                    return craftingScreenHandler;
                }
                return null;
            }

            @Override
            public Container getLinkedInventory() {
                AbstractContainerMenu abstractContainerMenu = Minecraft.getInstance().player.containerMenu;
                if (abstractContainerMenu instanceof CraftingScreenHandler) {
                    CraftingScreenHandler craftingScreenHandler = (CraftingScreenHandler)abstractContainerMenu;
                    return craftingScreenHandler.inventory;
                }
                return null;
            }

            @Override
            public void addSlot(Slot slot) {
                AbstractContainerMenu abstractContainerMenu = Minecraft.getInstance().player.containerMenu;
                if (abstractContainerMenu instanceof CraftingScreenHandler) {
                    CraftingScreenHandler craftingScreenHandler = (CraftingScreenHandler)abstractContainerMenu;
                    craftingScreenHandler.addSlotByClient(slot);
                    EditView.this.currentSlots.add(slot);
                }
            }

            @Override
            public void removeSlot(Slot slot) {
                AbstractContainerMenu abstractContainerMenu = Minecraft.getInstance().player.containerMenu;
                if (abstractContainerMenu instanceof CraftingScreenHandler) {
                    CraftingScreenHandler craftingScreenHandler = (CraftingScreenHandler)abstractContainerMenu;
                    craftingScreenHandler.removeSlotByClient(slot);
                    EditView.this.currentSlots.remove(slot);
                }
            }
        };
        this.children().clear();
        this.addChild(option.getGui(this.getX(), this.getY(), this.width, this.height, this.editContext));
    }

    class SlotButton
    extends InteractAbleWidget {
        private final ResourceLocation texture;
        private final ScrollingTextWidget textWidget;
        private final EditOption option;

        public SlotButton(int x, int y, int width, int height, String editName, EditOption option, ModuleInstance instance) {
            super(x, y, width, height, (Component)Component.empty());
            this.texture = ResourceLocation.fromNamespaceAndPath((String)"miapi", (String)"textures/gui/crafter/module_button_select.png");
            Component translated = StatResolver.translateAndResolve("miapi.edit.option." + editName, instance);
            this.textWidget = new ScrollingTextWidget(0, 0, this.width, translated, FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
            this.option = option;
        }

        @Override
        public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
            int hoverOffset = 0;
            if (this.isMouseOver(mouseX, mouseY)) {
                hoverOffset = 14;
            }
            SlotButton.drawTextureWithEdge(drawContext, this.texture, this.getX(), this.getY(), 0, hoverOffset, 140, 14, this.getWidth(), this.getHeight(), 140, 42, 2);
            this.textWidget.setX(this.getX() + 2);
            this.textWidget.setY(this.getY() + 3);
            this.textWidget.setWidth(this.width - 4);
            this.textWidget.render(drawContext, mouseX, mouseY, delta);
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.isMouseOver(mouseX, mouseY) && button == 0) {
                EditView.this.setEditOption(this.option);
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }
    }
}

