/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.crafter.help;

import com.redpxnda.nucleus.util.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ScrollingTextWidget;
import smartin.miapi.client.gui.SimpleButton;
import smartin.miapi.client.gui.crafting.crafter.help.pages.SinglePageTextImage;

@OnlyIn(value=Dist.CLIENT)
public class HelpPage
extends InteractAbleWidget {
    int color = Color.GREEN.argb();
    List<SinglePageTextImage> pages;
    ScrollingTextWidget header;
    SimpleButton backBtn;
    SimpleButton prev;
    SimpleButton next;
    int currentPage = 0;
    static ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"miapi", (String)"textures/gui/help_background.png");
    public static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"miapi", (String)"textures/gui/help_background.png");

    public HelpPage(int x, int y, int width, int height, Component title, Consumer<InteractAbleWidget> remove, List<SinglePageTextImage> pages) {
        super(x, y, width, height, title);
        this.pages = pages;
        this.backBtn = new SimpleButton<Object>(x + 3, y + height - 21, 50, 18, (Component)Component.translatable((String)"miapi.ui.back"), null, a -> remove.accept(this));
        this.prev = new SimpleButton<Object>(x + 55, y + height - 21, 50, 18, (Component)Component.translatable((String)"miapi.ui.prev"), null, a -> {
            this.currentPage = Math.max(this.currentPage - 1, 0);
            this.setPage(this.currentPage);
        });
        this.next = new SimpleButton<Object>(x + width - 53, y + height - 21, 50, 18, (Component)Component.translatable((String)"miapi.ui.next"), null, a -> {
            this.currentPage = Math.min(this.currentPage + 1, (pages.size() - 1) / 2);
            this.setPage(this.currentPage);
        });
        this.header = new ScrollingTextWidget(x + 10, y + 5, width - 10, title);
        this.header.setOrientation(ScrollingTextWidget.Orientation.CENTERED);
        this.setPage(0);
    }

    public void setPage(int x) {
        this.currentPage = x;
        this.children().clear();
        int lowerPage = x * 2;
        int upperPage = x * 2 + 1;
        if (this.pages.size() > lowerPage) {
            this.pages.get(lowerPage).setX(this.getX());
            this.pages.get(lowerPage).setY(this.getY() + 18);
            this.addChild(this.pages.get(lowerPage));
        }
        if (this.pages.size() > upperPage) {
            this.pages.get(upperPage).setX(this.getX() + this.width / 2);
            this.pages.get(upperPage).setY(this.getY() + 18);
            this.addChild(this.pages.get(upperPage));
        }
        if (this.pages.size() > 2) {
            this.next.isEnabled = this.pages.size() - 1 > upperPage;
            this.prev.isEnabled = x > 0;
            this.addChild(this.prev);
            this.addChild(this.next);
        }
        this.addChild(this.header);
        this.addChild(this.backBtn);
    }

    @Override
    public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        drawContext.blit(BACKGROUND, this.getX(), this.getY(), this.getWidth(), this.getHeight(), 0.0f, 0.0f, this.getWidth(), this.getHeight(), this.getWidth(), this.getHeight());
        super.renderWidget(drawContext, mouseX, mouseY, delta);
    }

    public static List<SinglePageTextImage> getPages(String key, int count) {
        ArrayList<SinglePageTextImage> pages = new ArrayList<SinglePageTextImage>(count);
        for (int i = 0; i < count; ++i) {
            pages.add(new SinglePageTextImage("miapi.help." + key + ".info." + i, "textures/gui/help/" + key + "/" + i + ".png"));
        }
        return pages;
    }
}

