/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.crafter.replace;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.client.gui.HoverDescription;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ScrollList;
import smartin.miapi.client.gui.ScrollingTextWidget;
import smartin.miapi.client.gui.TransformableWidget;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.client.gui.crafting.crafter.replace.CraftOption;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.edit_options.EditOption;
import smartin.miapi.modules.properties.CraftingConditionProperty;
import smartin.miapi.modules.properties.PriorityProperty;
import smartin.miapi.modules.properties.slot.AllowedSlots;
import smartin.miapi.modules.properties.slot.CanChildBeEmpty;
import smartin.miapi.modules.properties.slot.SlotProperty;

@OnlyIn(value=Dist.CLIENT)
public class ReplaceView
extends InteractAbleWidget {
    Consumer<CraftOption> craft;
    Consumer<CraftOption> preview;
    SlotButton lastPreview;
    public static List<CraftOptionSupplier> optionSuppliers = new ArrayList<CraftOptionSupplier>();
    public SlotProperty.ModuleSlot currentSlot;

    public ReplaceView(int x, int y, int width, int height, SlotProperty.ModuleSlot slot, EditOption.EditContext editContext, Consumer<SlotProperty.ModuleSlot> back, Consumer<CraftOption> craft, Consumer<CraftOption> preview) {
        super(x, y, width, height, (Component)Component.empty());
        this.craft = craft;
        this.preview = preview;
        float headerScale = 1.0f;
        this.currentSlot = slot;
        TransformableWidget headerHolder = new TransformableWidget(x, y, width, height, headerScale);
        this.addChild(headerHolder);
        ScrollingTextWidget header = new ScrollingTextWidget((int)((float)(this.getX() + 5) / headerScale), (int)((float)this.getY() / headerScale) + 3, (int)((float)(this.width - 10) / headerScale), (Component)Component.translatable((String)"miapi.ui.replace.header"), FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
        headerHolder.addChild(header);
        ScrollList list = new ScrollList(x, y + 14, width, height - 16, new ArrayList<InteractAbleWidget>());
        this.addChild(list);
        list.children().clear();
        ArrayList<InteractAbleWidget> toList = new ArrayList<InteractAbleWidget>();
        if (editContext.getInstance() == null || CanChildBeEmpty.property.isTrue(editContext.getInstance())) {
            toList.add(new SlotButton(0, 0, this.width, 15, new CraftOption(ItemModule.empty, new HashMap<ResourceLocation, JsonElement>(), -1000.0)));
        }
        ArrayList craftOptions = new ArrayList();
        AllowedSlots.allowedIn(slot).forEach(module -> {
            if (CraftingConditionProperty.isVisible(slot, module, (Player)Minecraft.getInstance().player, null)) {
                craftOptions.add(new CraftOption((ItemModule)module, (Map<ResourceLocation, JsonElement>)new HashMap<ResourceLocation, JsonElement>(), PriorityProperty.getFor(module)));
            }
        });
        optionSuppliers.forEach(craftOptionSupplier -> craftOptions.addAll(craftOptionSupplier.getOption(editContext)));
        List<CraftOption> sortedCraftOptions = craftOptions.stream().sorted(Comparator.comparingDouble(CraftOption::priority)).toList();
        sortedCraftOptions.forEach(craftOption -> toList.add(new SlotButton(0, 0, this.width, 15, (CraftOption)craftOption)));
        list.setList(toList);
    }

    public void setPreview(CraftOption option) {
        this.preview.accept(option);
    }

    class SlotButton
    extends InteractAbleWidget {
        private final ScrollingTextWidget textWidget;
        private final CraftOption option;
        private boolean isAllowed;
        private final HoverDescription hoverDescription;

        public SlotButton(int x, int y, int width, int height, CraftOption option) {
            super(x, y, width, height, (Component)Component.empty());
            this.isAllowed = true;
            this.option = option;
            this.textWidget = new ScrollingTextWidget(0, 0, this.width, option.displayName(), FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255));
            this.isAllowed = CraftingConditionProperty.isSelectAble(ReplaceView.this.currentSlot, option.module(), (Player)Minecraft.getInstance().player, null);
            List<Component> texts = new ArrayList<Component>();
            if (!this.isAllowed) {
                texts = CraftingConditionProperty.getReasonsForSelectable(ReplaceView.this.currentSlot, option.module(), (Player)Minecraft.getInstance().player, null);
            }
            this.hoverDescription = new HoverDescription(x, y, texts);
        }

        @Override
        public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
            int hoverOffset = 0;
            if (this.isMouseOver(mouseX, mouseY)) {
                hoverOffset = 14;
            }
            if (!this.isAllowed) {
                hoverOffset = 28;
            }
            SlotButton.drawTextureWithEdge(drawContext, CraftingScreen.BACKGROUND_TEXTURE, this.getX(), this.getY(), 404, 54 + hoverOffset, 108, 14, this.getWidth(), this.getHeight(), 512, 512, 3);
            this.textWidget.setX(this.getX() + 2);
            this.textWidget.setY(this.getY() + 3);
            this.textWidget.setWidth(this.width - 4);
            this.textWidget.render(drawContext, mouseX, mouseY, delta);
            if (this.isMouseOver(mouseX, mouseY) && !this.isAllowed && this.hoverDescription != null) {
                this.hoverDescription.render(drawContext, mouseX, mouseY, delta);
            }
        }

        @Override
        public void renderHover(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
            if (this.isMouseOver(mouseX, mouseY) && !this.isAllowed && this.hoverDescription != null) {
                this.hoverDescription.setX(this.getX());
                this.hoverDescription.setY(this.getY() + this.getHeight());
                this.hoverDescription.render(drawContext, mouseX, mouseY, delta);
            }
        }

        @Override
        public boolean isMouseOver(double mouseX, double mouseY) {
            boolean isOver = super.isMouseOver(mouseX, mouseY);
            if (!((Object)((Object)this)).equals((Object)ReplaceView.this.lastPreview) && isOver) {
                ReplaceView.this.lastPreview = this;
                ReplaceView.this.setPreview(this.option);
            }
            return isOver;
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.isMouseOver(mouseX, mouseY) && button == 0 && this.isAllowed) {
                this.playClickedSound();
                ReplaceView.this.craft.accept(this.option);
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }
    }

    public static interface CraftOptionSupplier {
        public List<CraftOption> getOption(EditOption.EditContext var1);
    }
}

