/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.crafter.replace.hover;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.client.gui.crafting.crafter.replace.hover.HoverMaterialList;
import smartin.miapi.modules.ItemModule;

@OnlyIn(value=Dist.CLIENT)
public class HoverInteractableMaterialList
extends HoverMaterialList {
    public HoverInteractableMaterialList(ItemModule module, int x, int y, int width, int height) {
        super(module, x, y, width, height);
    }

    @Override
    public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        this.realMouseX = mouseX;
        this.realMouseY = mouseY;
        if (this.lastRendered || this.permaOpen) {
            HoverInteractableMaterialList.selectedMaterialUpdate(this.previewMaterial);
            if (CraftingScreen.getInstance() != null && this.isMouseOver(mouseX, mouseY)) {
                CraftingScreen.getInstance().overwriteMouseY = -1000;
                CraftingScreen.getInstance().overwriteMouseX = -1000;
            }
        }
        super.renderWidget(drawContext, mouseX, mouseY, delta);
    }

    public boolean isMouseOver(double mouseX, double mouseY, int xStart, int yStart, int xWidth, int yHeight) {
        return this.active && this.visible && mouseX >= (double)xStart && mouseY >= (double)yStart && mouseX < (double)(this.getX() + xWidth) && mouseY < (double)(this.getY() + yHeight);
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        if (this.permaOpen) {
            return this.isMouseOver(mouseX, mouseY, this.getX(), this.getY(), this.sizeBaseList + this.sizeDetailList, this.verticalSize);
        }
        return super.isMouseOver(mouseX, mouseY);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double amount) {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (mouseX > (double)(this.getX() + this.sizeBaseList) || Screen.hasShiftDown() || Screen.hasAltDown()) {
                this.scrollPosTwo = amount < 0.0 ? ++this.scrollPosTwo : --this.scrollPosTwo;
                return true;
            }
            this.scrollPosTwo = 0;
            this.start = 0;
            if (amount < 0.0) {
                int maxElementsTotal = this.materialKeys.size();
                if (this.selected + this.scrollPosOne != maxElementsTotal - 1) {
                    if (this.scrollPosOne == 0 && 8 == maxElementsTotal) {
                        this.selected = Math.min(this.selected + 1, 7);
                    } else if (this.scrollPosOne + 8 == maxElementsTotal - 1) {
                        this.selected = Math.min(this.selected + 1, 7);
                    } else if (this.selected == 6) {
                        ++this.scrollPosOne;
                    } else {
                        this.selected = Math.min(this.selected + 1, 7);
                    }
                }
            } else if (this.selected == 1 && this.scrollPosOne > 0) {
                --this.scrollPosOne;
            } else {
                this.selected = Math.max(this.selected - 1, 0);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver(mouseX, mouseY)) {
            this.permaOpen = !this.permaOpen;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

