/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.crafter.replace.hover;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.Miapi;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.client.gui.crafting.PreviewManager;
import smartin.miapi.material.AllowedMaterial;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.material.composite.AnyIngredientComposite;
import smartin.miapi.material.composite.CompositeMaterial;
import smartin.miapi.material.composite.material.MaterialCopyComposite;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.registries.RegistryInventory;

@OnlyIn(value=Dist.CLIENT)
public class HoverMaterialList
extends InteractAbleWidget {
    public Map<String, List<Material>> materials = new LinkedHashMap<String, List<Material>>();
    public List<String> materialKeys;
    public int selected = 0;
    public int scrollPosOne = 0;
    public int scrollPosTwo = 0;
    protected final int maxElements = 8;
    final int selectedColor = FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255);
    final int unselectedColor = FastColor.ARGB32.color((int)255, (int)200, (int)200, (int)200);
    final int moreEntryColor = FastColor.ARGB32.color((int)255, (int)160, (int)160, (int)160);
    protected int start = 0;
    protected int end = 0;
    protected boolean lastRendered = false;
    protected Material previewMaterial = null;
    protected int realMouseX = 0;
    protected int realMouseY = 0;
    protected int sizeDetailList;
    protected int verticalSize;
    protected int sizeBaseList = 0;
    protected boolean permaOpen = false;

    public HoverMaterialList(ItemModule module, int x, int y, int width, int height) {
        super(x, y, width, height, (Component)Component.empty());
        this.materialKeys = AllowedMaterial.property.getAllowedKeys(module);
        for (String key : this.materialKeys) {
            this.materials.put(key, AllowedMaterial.property.getMaterials(key).stream().sorted(Comparator.comparing(m -> m.getTranslation().getString())).toList());
        }
    }

    @Override
    public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        drawContext.blit(CraftingScreen.BACKGROUND_TEXTURE, this.getX(), this.getY(), 404.0f, 96.0f, 20, 11, 512, 512);
        super.renderWidget(drawContext, mouseX, mouseY, delta);
        if (this.lastRendered || this.permaOpen) {
            HoverMaterialList.selectedMaterialUpdate(this.previewMaterial);
        }
    }

    @Override
    public void renderHover(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        int i;
        int currentY = this.getY() + 3;
        if (this.materialKeys.isEmpty()) {
            return;
        }
        String selectedMaterialOrGroup = this.materialKeys.get(this.selected + this.scrollPosOne);
        List<Material> materialList = this.materials.get(selectedMaterialOrGroup);
        this.sizeBaseList = 30;
        this.verticalSize = Math.min(this.materials.size(), 8);
        this.verticalSize = Math.clamp((long)materialList.size(), this.verticalSize, 8);
        this.verticalSize *= 14;
        for (i = this.scrollPosOne; i < Math.min(this.materials.size(), 8 + this.scrollPosOne); ++i) {
            Component material = HoverMaterialList.getTranslation(this.materialKeys.get(i));
            this.sizeBaseList = Math.max(Minecraft.getInstance().font.width((FormattedText)material), this.sizeBaseList);
        }
        this.sizeDetailList = 0;
        if (materialList.size() > 1) {
            for (Material m : materialList) {
                Component material = m.getTranslation();
                this.sizeDetailList = Math.max(Minecraft.getInstance().font.width((FormattedText)material), this.sizeDetailList);
            }
        }
        this.sizeDetailList += 10;
        if (this.isMouseOver(this.realMouseX, this.realMouseY) || this.permaOpen) {
            this.lastRendered = true;
            drawContext.fill(this.getX(), this.getY(), this.getX() + this.sizeDetailList + this.sizeBaseList, this.getY() + this.verticalSize, FastColor.ARGB32.color((int)210, (int)0, (int)0, (int)0));
            if (!this.materials.isEmpty()) {
                int start = this.scrollPosOne = Math.max(0, Math.min(this.materials.size() - 8, this.scrollPosOne));
                int end = Math.min(this.scrollPosOne + 8, this.materials.size());
                if (end < this.materials.size() - 1) {
                    drawContext.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"miapi.ui.material_detail.lower.scroll"), this.getX() + 3, currentY + 98, this.moreEntryColor, false);
                    --end;
                }
                if (start != 0) {
                    drawContext.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"miapi.ui.material_detail.higher.scroll"), this.getX() + 3, currentY, this.moreEntryColor, false);
                    ++start;
                    currentY += 14;
                }
                for (int i2 = start; i2 < end; ++i2) {
                    int color = i2 == this.selected + this.scrollPosOne ? this.selectedColor : this.unselectedColor;
                    Component translation = HoverMaterialList.getTranslation(this.materialKeys.get(i2));
                    drawContext.drawString(Minecraft.getInstance().font, translation, this.getX() + 3, currentY, color, false);
                    currentY += 14;
                }
            }
            currentY = this.getY() + 3;
            if (materialList.size() > 1) {
                this.scrollPosTwo = Math.max(0, Math.min(this.scrollPosTwo, materialList.size() - 1));
                while (this.start > this.scrollPosTwo - 1) {
                    --this.start;
                }
                this.start = Math.max(0, this.start);
                this.end = Math.min(this.start + 8, materialList.size());
                while (this.end < this.scrollPosTwo + 2 && this.end < materialList.size()) {
                    ++this.start;
                    this.end = Math.min(this.start + 8, materialList.size());
                }
                for (i = this.start; i < this.end; ++i) {
                    if (this.start > 0 && i == this.start) {
                        drawContext.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"miapi.ui.material_detail.higher"), this.getX() + this.sizeBaseList + 6, currentY, this.moreEntryColor, false);
                    } else if (i == this.end - 1 && this.end < materialList.size() - 1) {
                        drawContext.drawString(Minecraft.getInstance().font, (Component)Component.translatable((String)"miapi.ui.material_detail.lower"), this.getX() + this.sizeBaseList + 6, currentY, this.moreEntryColor, false);
                    } else {
                        int color = i == this.scrollPosTwo ? this.selectedColor : this.unselectedColor;
                        drawContext.drawString(Minecraft.getInstance().font, materialList.get(i).getTranslation(), this.getX() + this.sizeBaseList + 6, currentY, color, false);
                    }
                    currentY += 14;
                }
                this.previewMaterial = materialList.get(this.scrollPosTwo);
            } else if (!materialList.isEmpty()) {
                this.previewMaterial = materialList.getFirst();
            }
        } else {
            this.lastRendered = false;
            this.scrollPosOne = 0;
            this.scrollPosTwo = 0;
            this.selected = 0;
        }
    }

    public static void selectedMaterialUpdate(Material material) {
        if (material != null && PreviewManager.currentPreviewMaterial != material) {
            ItemStack materialStack = new ItemStack((ItemLike)RegistryInventory.modularItem);
            materialStack.set(CompositeMaterial.COMPOSITE_MATERIAL_COMPONENT, (Object)CompositeMaterial.getFromComposites(List.of(new MaterialCopyComposite(material), new AnyIngredientComposite())));
            PreviewManager.setCursorItemstack(materialStack);
        } else {
            ItemStack materialStack = new ItemStack((ItemLike)RegistryInventory.modularItem);
            PreviewManager.setCursorItemstack(materialStack);
            PreviewManager.resetCursorStack();
        }
    }

    public static Component getTranslation(String materialOrGroupKey) {
        ResourceLocation id = Miapi.id(materialOrGroupKey);
        if (MaterialProperty.MATERIAL_REGISTRY.containsKey(id)) {
            Material material = MaterialProperty.MATERIAL_REGISTRY.get(id);
            return material.getTranslation();
        }
        MutableComponent testTranslation = Component.translatable((String)("miapi.material_group." + materialOrGroupKey));
        if (testTranslation.getString().equals("miapi.material_group." + materialOrGroupKey)) {
            Miapi.LOGGER.warn("missing translation for miapi.material_group." + materialOrGroupKey);
            return Component.literal((String)materialOrGroupKey);
        }
        return testTranslation;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            if (Screen.hasShiftDown() || Screen.hasControlDown()) {
                this.scrollPosTwo = scrollY < 0.0 ? ++this.scrollPosTwo : --this.scrollPosTwo;
                return true;
            }
            this.scrollPosTwo = 0;
            this.start = 0;
            if (scrollY < 0.0) {
                int maxElementsTotal = this.materialKeys.size();
                if (this.selected + this.scrollPosOne != maxElementsTotal - 1) {
                    if (this.scrollPosOne == 0 && 8 == maxElementsTotal) {
                        this.selected = Math.min(this.selected + 1, 7);
                    } else if (this.scrollPosOne + 8 == maxElementsTotal - 1) {
                        this.selected = Math.min(this.selected + 1, 7);
                    } else if (this.selected == 6) {
                        ++this.scrollPosOne;
                    } else {
                        this.selected = Math.min(this.selected + 1, 7);
                    }
                }
            } else if (this.selected == 1 && this.scrollPosOne > 0) {
                --this.scrollPosOne;
            } else {
                this.selected = Math.max(this.selected - 1, 0);
            }
            return true;
        }
        return false;
    }
}

