/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.crafter.replace.hover;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.crafting.CraftingScreen;
import smartin.miapi.material.MaterialStatIndicatorProperty;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.properties.LoreProperty;

@OnlyIn(value=Dist.CLIENT)
public class MaterialStatPreview
extends InteractAbleWidget {
    boolean isVisiible;
    Map<String, MaterialStatIndicatorProperty.Context> map;
    List<Component> list = new ArrayList<MutableComponent>(List.of(Component.translatable((String)"miapi.material_indication.header")));
    List<Component> fullList = new ArrayList<MutableComponent>(List.of(Component.translatable((String)"miapi.material_indication.header")));

    public MaterialStatPreview(int x, int y, int width, int height, ItemModule context) {
        super(x, y, width, height, (Component)Component.empty());
        Optional optionalData = MaterialStatIndicatorProperty.property.getData(context);
        this.isVisiible = optionalData.isPresent();
        if (this.isVisiible) {
            this.map = MaterialStatIndicatorProperty.property.initialize((Map)optionalData.get());
            this.map.forEach((stat, context1) -> {
                int value = context1.strength;
                String valueString = value > 0 ? "+".repeat(value) : "-".repeat(-value);
                MutableComponent component = Component.literal((String)valueString);
                component = value > 0 ? LoreProperty.format((Component)component, ChatFormatting.GREEN) : LoreProperty.format((Component)component, ChatFormatting.RED);
                this.list.add((Component)Component.translatable((String)("miapi.material_stat." + stat)).append((Component)component));
                this.fullList.add((Component)Component.translatable((String)("miapi.material_stat." + stat)).append((Component)component));
                if (context1.info != null) {
                    this.fullList.add(context1.info);
                }
            });
        }
    }

    @Override
    public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        if (this.isVisiible) {
            drawContext.drawString(Minecraft.getInstance().font, "i", this.getX() + 3, this.getY() + 8, Color.BLACK.getRGB(), false);
            if (this.isMouseOver(mouseX, mouseY)) {
                if (CraftingScreen.hasShiftDown() || CraftingScreen.hasAltDown()) {
                    drawContext.renderTooltip(Minecraft.getInstance().font, this.fullList, Optional.empty(), mouseX, mouseY);
                } else {
                    drawContext.renderTooltip(Minecraft.getInstance().font, this.list, Optional.empty(), mouseX, mouseY);
                }
            }
        }
    }
}

