/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.slotdisplay;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4fStack;
import org.joml.Vector3f;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.modules.properties.slot.SlotProperty;

@OnlyIn(value=Dist.CLIENT)
public class SlotDisplay
extends InteractAbleWidget {
    private final Map<SlotProperty.ModuleSlot, ModuleButton> buttonMap = new HashMap<SlotProperty.ModuleSlot, ModuleButton>();
    private ItemStack stack;
    private PoseStack slotProjection = new PoseStack();
    private double lastMouseX;
    private double lastMouseY;
    private boolean mouseDown0 = false;
    private boolean mouseDown1 = false;
    private SlotProperty.ModuleSlot selected = null;
    private final Consumer<SlotProperty.ModuleSlot> setSelected;
    private SlotProperty.ModuleSlot baseSlot;

    public SlotDisplay(ItemStack stack, int x, int y, int height, int width, Consumer<SlotProperty.ModuleSlot> selected) {
        super(x, y, width, height, (Component)Component.literal((String)"Item Display"));
        this.stack = stack;
        this.height = height;
        this.width = width;
        this.slotProjection.scale(1.0f, -1.0f, 1.0f);
        this.setSelected = selected;
        this.setBaseSlot(new SlotProperty.ModuleSlot(new ArrayList<String>()));
    }

    @Override
    public void mouseMoved(double mouseX, double mouseY) {
        if (this.mouseDown0) {
            this.handleLeftClickDrag(mouseX, mouseY, this.lastMouseX - mouseX, this.lastMouseY - mouseY);
        } else if (this.mouseDown1) {
            this.handleRightClickDrag(mouseX, mouseY, this.lastMouseX - mouseX, this.lastMouseY - mouseY);
        }
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
    }

    @Override
    public boolean isMouseOver(double x, double y) {
        boolean mouseOver;
        boolean bl = mouseOver = x >= (double)this.getX() && y >= (double)this.getY() && x < (double)(this.getX() + this.width) && y < (double)(this.getY() + this.height);
        if (mouseOver) {
            return true;
        }
        this.mouseDown0 = false;
        this.mouseDown1 = false;
        return super.isMouseOver(x, y);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isMouseOver(mouseX, mouseY)) {
            this.mouseDown0 = true;
        } else if (button == 1 && this.isMouseOver(mouseX, mouseY)) {
            this.mouseDown1 = true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.mouseDown0 = false;
        } else if (button == 1) {
            this.mouseDown1 = false;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    private void handleLeftClickDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
        PoseStack newStack = new PoseStack();
        newStack.translate((float)(-deltaX) / 100.0f, -((float)deltaY) / 100.0f, 0.0f);
        newStack.mulPose(this.slotProjection.last().pose());
        this.slotProjection = newStack;
    }

    private void handleRightClickDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
        float angleX = (float)(-(deltaY * (double)0.02f));
        float angleY = (float)(-(deltaX * (double)0.02f));
        PoseStack newStack = new PoseStack();
        newStack.last().pose().rotateAffineXYZ(-angleX, angleY, 0.0f);
        newStack.mulPose(this.slotProjection.last().pose());
        this.slotProjection = newStack;
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            double scale = Math.pow(2.0, scrollY / 10.0);
            this.slotProjection.scale((float)scale, (float)scale, (float)scale);
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public void setBaseSlot(SlotProperty.ModuleSlot baseSlot1) {
        this.baseSlot = baseSlot1;
        this.buttonMap.forEach((slot1, moduleButton) -> this.children().remove(moduleButton));
        this.buttonMap.clear();
        if (this.baseSlot != null && this.baseSlot.inSlot != null) {
            this.baseSlot.inSlot.allSubModules().forEach(moduleInstances -> SlotProperty.getSlots(moduleInstances).forEach((number, slot) -> this.buttonMap.computeIfAbsent((SlotProperty.ModuleSlot)slot, newSlot -> {
                ModuleButton newButton = new ModuleButton(0, 0, 10, 10, (SlotProperty.ModuleSlot)newSlot);
                this.addChild(newButton);
                return newButton;
            })));
            this.buttonMap.computeIfAbsent(this.baseSlot, newSlot -> {
                ModuleButton newButton = new ModuleButton(0, 0, 10, 10, (SlotProperty.ModuleSlot)newSlot);
                this.addChild(newButton);
                return newButton;
            });
        }
    }

    public void setItem(ItemStack itemStack) {
        this.stack = itemStack;
        this.slotProjection = new PoseStack();
        this.slotProjection.scale(1.0f, -1.0f, 1.0f);
        this.selected = new SlotProperty.ModuleSlot(new ArrayList<String>());
    }

    public int getSize() {
        int size = Math.min(this.width, this.height);
        size = Math.max(5, size - 10);
        return size;
    }

    @Override
    public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        drawContext.enableScissor(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height);
        this.renderSlot(this.stack, drawContext, mouseX, mouseY, delta);
        super.renderWidget(drawContext, mouseX, mouseY, delta);
        drawContext.disableScissor();
    }

    public void select(SlotProperty.ModuleSlot selected) {
        this.selected = selected;
    }

    private Vector3f position() {
        return new Vector3f((float)this.getX() + (float)(this.width - 16) / 2.0f, (float)this.getY() + (float)(this.height - 16) / 2.0f, 150.0f);
    }

    public void renderSlot(ItemStack stack, GuiGraphics context, int mouseX, int mouseY, float delta) {
        ItemRenderer renderer = Minecraft.getInstance().getItemRenderer();
        Minecraft.getInstance().getTextureManager().getTexture(TextureAtlas.LOCATION_BLOCKS).setFilter(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4fStack matrixStack = RenderSystem.getModelViewStack();
        matrixStack.pushMatrix();
        Vector3f pos = this.position();
        matrixStack.translate(pos.x(), pos.y(), pos.z());
        matrixStack.scale((float)this.getSize(), (float)this.getSize(), 1.0f);
        RenderSystem.applyModelViewMatrix();
        MultiBufferSource.BufferSource immediate = Minecraft.getInstance().renderBuffers().bufferSource();
        boolean bl = true;
        if (bl) {
            Lighting.setupForFlatItems();
        }
        RenderSystem.enableDepthTest();
        renderer.renderStatic(stack, ItemDisplayContext.GUI, 0xF000F0, OverlayTexture.NO_OVERLAY, this.slotProjection, (MultiBufferSource)immediate, (Level)Minecraft.getInstance().level, 0);
        immediate.endBatch();
        RenderSystem.enableDepthTest();
        if (bl) {
            Lighting.setupFor3DItems();
        }
        matrixStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        Minecraft.getInstance().renderBuffers().outlineBufferSource();
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public class ModuleButton
    extends InteractAbleWidget {
        private static final ResourceLocation ButtonTexture = ResourceLocation.fromNamespaceAndPath((String)"miapi", (String)"textures/button.png");
        public SlotProperty.ModuleSlot instance;

        public ModuleButton(int x, int y, int width, int height, SlotProperty.ModuleSlot instance) {
            super(x, y, width, height, (Component)Component.literal((String)" "));
            this.instance = instance;
        }

        private void setSelected(SlotProperty.ModuleSlot instance) {
            SlotDisplay.this.selected = instance;
            SlotDisplay.this.setSelected.accept(instance);
        }

        @Override
        public void renderWidget(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
            RenderSystem.depthFunc((int)519);
            RenderSystem.disableDepthTest();
            this.renderButton(drawContext, mouseX, mouseY, delta);
            RenderSystem.enableDepthTest();
            RenderSystem.depthFunc((int)515);
        }

        @Override
        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.isMouseOver(mouseX, mouseY)) {
                this.playClickedSound();
                this.setSelected(this.instance);
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }

        public void renderButton(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
            int textureSize = 30;
            int textureOffset = 0;
            if (this.instance.equals(SlotDisplay.this.selected)) {
                textureOffset = 20;
            } else if (this.isMouseOver(mouseX, mouseY)) {
                textureOffset = 10;
            }
        }
    }
}

