/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.statdisplay;

import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Either;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.Miapi;
import smartin.miapi.client.gui.crafting.statdisplay.SingleStatDisplayDouble;
import smartin.miapi.client.gui.crafting.statdisplay.StatListWidget;
import smartin.miapi.modules.properties.attributes.AttributeProperty;
import smartin.miapi.modules.properties.attributes.AttributeUtil;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;

@OnlyIn(value=Dist.CLIENT)
public class AttributeSingleDisplay
extends SingleStatDisplayDouble {
    public static Set<Attribute> attributesWithDisplay = new HashSet<Attribute>();
    public static Map<EquipmentSlot, Multimap<Attribute, AttributeModifier>> oldItemCache = new WeakHashMap<EquipmentSlot, Multimap<Attribute, AttributeModifier>>();
    public static Map<EquipmentSlot, Multimap<Attribute, AttributeModifier>> compareItemCache = new WeakHashMap<EquipmentSlot, Multimap<Attribute, AttributeModifier>>();
    public AttributeModifier.Operation operation = AttributeModifier.Operation.ADD_VALUE;
    final Attribute attribute;
    final EquipmentSlot slot;
    double defaultValue;
    double fallbackValue;
    public SingleStatDisplayDouble.StatReaderHelper valueReader = new SingleStatDisplayDouble.StatReaderHelper(){

        @Override
        public double getValue(ItemStack itemStack) {
            return AttributeSingleDisplay.this.getValueFunction(itemStack);
        }

        @Override
        public boolean hasValue(ItemStack itemStack) {
            return AttributeSingleDisplay.this.hasAttribute(itemStack);
        }
    };

    private AttributeSingleDisplay(Attribute attribute, EquipmentSlot slot, StatListWidget.TextGetter text, StatListWidget.TextGetter hover, double defaultValue, DecimalFormat modifierFormat) {
        super(0, 0, 51, 19, text, hover);
        attributesWithDisplay.add(attribute);
        this.slot = slot;
        this.attribute = attribute;
        this.defaultValue = defaultValue;
        this.modifierFormat = modifierFormat;
    }

    @Override
    public double getValue(ItemStack stack) {
        double value = this.valueReader.getValue(stack);
        if (!this.valueReader.hasValue(stack) || Double.isNaN(value)) {
            return this.attribute.getDefaultValue();
        }
        return value;
    }

    public double getValueFunction(ItemStack stack) {
        Map<EquipmentSlot, Multimap<Attribute, AttributeModifier>> attributeCache = compareItemCache;
        if (stack.equals(this.original)) {
            attributeCache = oldItemCache;
        }
        if (this.slot == null) {
            Double value = null;
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                Multimap<Attribute, AttributeModifier> currentSlot = attributeCache.get(equipmentSlot);
                if (!attributeCache.get(equipmentSlot).containsKey((Object)this.attribute)) continue;
                switch (this.operation) {
                    case ADD_VALUE: {
                        value = this.defaultValue;
                        for (AttributeModifier modifier : currentSlot.get((Object)this.attribute).stream().filter(a -> a.operation().equals((Object)this.operation)).toList()) {
                            value = value + modifier.amount();
                        }
                        return value;
                    }
                    case ADD_MULTIPLIED_BASE: {
                        value = 0.0;
                        for (AttributeModifier modifier : currentSlot.get((Object)this.attribute).stream().filter(a -> a.operation().equals((Object)AttributeModifier.Operation.ADD_MULTIPLIED_BASE)).toList()) {
                            value = value + modifier.amount();
                        }
                        for (AttributeModifier modifier : currentSlot.get((Object)this.attribute).stream().filter(a -> a.operation().equals((Object)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)).toList()) {
                            value = (value + 1.0) * (modifier.amount() + 1.0) - 1.0;
                        }
                        return value * 100.0;
                    }
                    case ADD_MULTIPLIED_TOTAL: {
                        value = 1.0;
                        for (AttributeModifier modifier : currentSlot.get((Object)this.attribute).stream().filter(a -> a.operation().equals((Object)this.operation)).toList()) {
                            value = value * modifier.amount();
                        }
                        return value * 100.0;
                    }
                }
            }
            return this.fallbackValue;
        }
        return AttributeUtil.getActualValue(attributeCache.get(this.slot), this.attribute, this.fallbackValue);
    }

    @Override
    public boolean shouldRender(ItemStack original, ItemStack compareTo) {
        super.shouldRender(original, compareTo);
        if (this.valueReader.hasValue(original)) {
            return true;
        }
        return this.valueReader.hasValue(compareTo);
    }

    public boolean hasAttribute(ItemStack itemStack) {
        return ((ItemAttributeModifiers)itemStack.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.EMPTY)).modifiers().stream().anyMatch(a -> ((Attribute)a.attribute().value()).equals(this.attribute) && a.modifier().amount() != 0.0 && (a.modifier().operation().equals((Object)this.operation) || this.operation.equals((Object)AttributeModifier.Operation.ADD_MULTIPLIED_BASE) && a.modifier().operation().equals((Object)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)));
    }

    public boolean hasValue(Collection<AttributeModifier> list) {
        list = list.stream().filter(attribute -> attribute.operation().equals((Object)this.operation)).toList();
        if (this.operation.equals((Object)AttributeModifier.Operation.ADD_VALUE)) {
            double value = AttributeUtil.getActualValue(list, this.attribute.getDefaultValue());
            return value != this.attribute.getDefaultValue() && !Double.isNaN(value);
        }
        return !list.isEmpty();
    }

    @Override
    public DoubleOperationResolvable getResolvable(ItemStack stack) {
        Optional optional = AttributeProperty.property.getData(stack);
        if (optional.isPresent()) {
            Map resolvableMap;
            Map operationMap;
            Map attributeMap = (Map)optional.get();
            ResourceLocation attributeKey = BuiltInRegistries.ATTRIBUTE.getKey((Object)this.attribute);
            if (attributeKey != null && (operationMap = (Map)attributeMap.get(attributeKey)) != null && (resolvableMap = (Map)operationMap.get(this.operation)) != null) {
                for (Map.Entry entry : resolvableMap.entrySet()) {
                    Either either = (Either)entry.getKey();
                    if (!either.left().isPresent()) continue;
                    EquipmentSlotGroup group = (EquipmentSlotGroup)either.left().get();
                    if (this.slot != null && !group.test(this.slot)) continue;
                    return (DoubleOperationResolvable)entry.getValue();
                }
            }
        }
        return null;
    }

    public static Builder builder(Holder<Attribute> attribute) {
        return new Builder(attribute);
    }

    public static class Builder {
        Holder<Attribute> attribute;
        public EquipmentSlot slot;
        public double defaultValue = 1.0;
        public double fallbackValue;
        public StatListWidget.TextGetter name;
        public StatListWidget.TextGetter hoverDescription = stack -> Component.empty();
        public String translationKey = "";
        public Object[] descriptionArgs = new Object[0];
        public DecimalFormat modifierFormat;
        public double min = 0.0;
        public double max = 100.0;
        public boolean inverse = false;
        public ValueGetter valueGetter;

        private Builder(Holder<Attribute> attribute) {
            this.attribute = attribute;
            if (attribute != null) {
                this.name = itemStack -> Component.translatable((String)((Attribute)attribute.value()).getDescriptionId());
            }
            this.modifierFormat = (DecimalFormat)Util.make((Object)new DecimalFormat("##.##"), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
            this.defaultValue = ((Attribute)attribute.value()).getDefaultValue();
            this.fallbackValue = ((Attribute)attribute.value()).getDefaultValue();
            this.max = Math.min(2048.0, ((Attribute)attribute.value()).sanitizeValue(Double.MAX_VALUE));
            this.min = Math.max(-2048.0, ((Attribute)attribute.value()).sanitizeValue(Double.MIN_VALUE));
        }

        public Builder setMax(double maxValue) {
            this.max = maxValue;
            return this;
        }

        public Builder setMin(double minValue) {
            this.min = minValue;
            return this;
        }

        public Builder setDefault(double defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder setFallback(double defaultValue) {
            this.fallbackValue = defaultValue;
            return this;
        }

        public Builder setTranslationKey(String key) {
            this.translationKey = key;
            this.name = stack -> Component.translatable((String)("miapi.stat." + key));
            this.hoverDescription = stack -> Component.translatable((String)("miapi.stat." + key + ".description"), (Object[])this.descriptionArgs);
            return this;
        }

        public Builder setName(Component name) {
            this.name = stack -> name;
            return this;
        }

        public Builder setName(StatListWidget.TextGetter name) {
            this.name = name;
            return this;
        }

        public Builder inverseNumber(boolean inverse) {
            this.inverse = inverse;
            return this;
        }

        public Builder setSlot(EquipmentSlot slot) {
            this.slot = slot;
            return this;
        }

        public Builder setHoverDescription(Component hoverDescription) {
            this.hoverDescription = stack -> hoverDescription;
            return this;
        }

        public Builder setHoverDescription(StatListWidget.TextGetter hoverDescription) {
            this.hoverDescription = hoverDescription;
            return this;
        }

        public Builder setFormat(String format) {
            this.modifierFormat = (DecimalFormat)Util.make((Object)new DecimalFormat(format), decimalFormat -> decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
            return this;
        }

        public Builder setValueGetter(ValueGetter reader) {
            this.valueGetter = reader;
            return this;
        }

        public AttributeSingleDisplay[] build() {
            AttributeSingleDisplay[] displays = new AttributeSingleDisplay[2];
            if (this.name == null) {
                throw new IllegalStateException("Name is required");
            }
            if (this.attribute == null) {
                Miapi.LOGGER.error("Attribute is required for Attribute Stat Display!");
                return new AttributeSingleDisplay[0];
            }
            final AttributeSingleDisplay display = new AttributeSingleDisplay((Attribute)this.attribute.value(), this.slot, this.name, this.hoverDescription, this.defaultValue, this.modifierFormat);
            display.minValue = this.min;
            display.maxValue = this.max;
            display.fallbackValue = this.fallbackValue;
            display.setInverse(this.inverse);
            if (this.valueGetter != null) {
                display.valueReader = new SingleStatDisplayDouble.StatReaderHelper(){

                    @Override
                    public double getValue(ItemStack itemStack) {
                        return valueGetter.getValue(itemStack);
                    }

                    @Override
                    public boolean hasValue(ItemStack itemStack) {
                        return display.hasAttribute(itemStack);
                    }
                };
            }
            display.operation = AttributeModifier.Operation.ADD_VALUE;
            displays[0] = display;
            final AttributeSingleDisplay displayMulBase = new AttributeSingleDisplay((Attribute)this.attribute.value(), this.slot, this.name, this.hoverDescription, this.defaultValue, this.modifierFormat);
            displayMulBase.minValue = 0.0;
            displayMulBase.maxValue = 100.0;
            displayMulBase.setInverse(this.inverse);
            if (this.valueGetter != null) {
                displayMulBase.valueReader = new SingleStatDisplayDouble.StatReaderHelper(){

                    @Override
                    public double getValue(ItemStack itemStack) {
                        return valueGetter.getValue(itemStack);
                    }

                    @Override
                    public boolean hasValue(ItemStack itemStack) {
                        return displayMulBase.hasAttribute(itemStack);
                    }
                };
            }
            displayMulBase.operation = AttributeModifier.Operation.ADD_MULTIPLIED_BASE;
            displayMulBase.postfix = Component.literal((String)"%");
            displays[1] = displayMulBase;
            final AttributeSingleDisplay displayMulTotal = new AttributeSingleDisplay((Attribute)this.attribute.value(), this.slot, this.name, this.hoverDescription, this.defaultValue, this.modifierFormat);
            displayMulTotal.minValue = 0.0;
            displayMulTotal.maxValue = 100.0;
            displayMulTotal.setInverse(this.inverse);
            if (this.valueGetter != null) {
                displayMulTotal.valueReader = new SingleStatDisplayDouble.StatReaderHelper(){

                    @Override
                    public double getValue(ItemStack itemStack) {
                        return valueGetter.getValue(itemStack);
                    }

                    @Override
                    public boolean hasValue(ItemStack itemStack) {
                        return displayMulTotal.hasAttribute(itemStack);
                    }
                };
            }
            displayMulTotal.operation = AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL;
            displayMulTotal.postfix = Component.literal((String)"%");
            return displays;
        }

        static interface ValueGetter {
            public double getValue(ItemStack var1);
        }
    }
}

