/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.statdisplay;

import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.client.gui.crafting.statdisplay.SingleStatDisplayBoolean;
import smartin.miapi.client.gui.crafting.statdisplay.StatListWidget;
import smartin.miapi.modules.properties.util.ComplexBooleanProperty;

@OnlyIn(value=Dist.CLIENT)
public class BooleanStatDisplay
extends SingleStatDisplayBoolean {
    public ComplexBooleanProperty property;

    public BooleanStatDisplay(StatListWidget.TextGetter title, StatListWidget.TextGetter hover, ComplexBooleanProperty property) {
        super(0, 0, 51, 19, title, hover);
        this.property = property;
    }

    @Override
    public double getValue(ItemStack stack) {
        return this.property.isTrue(stack) ? 1.0 : 0.0;
    }

    @Override
    public boolean shouldRender(ItemStack original, ItemStack compareTo) {
        return super.shouldRender(original, compareTo);
    }

    @Override
    public boolean getValueItemStack(ItemStack itemStack) {
        return this.property.isTrue(itemStack);
    }

    @Override
    public boolean hasValueItemStack(ItemStack itemStack) {
        return this.property.hasValue(itemStack);
    }

    public static Builder builder(ComplexBooleanProperty property) {
        return new Builder(property);
    }

    public static class Builder {
        ComplexBooleanProperty property;
        public StatListWidget.TextGetter name;
        public StatListWidget.TextGetter hoverDescription = stack -> Component.empty();
        public String translationKey = "";
        public Object[] descriptionArgs = new Object[0];

        private Builder(ComplexBooleanProperty property) {
            this.property = property;
        }

        public Builder setName(Component name) {
            this.name = stack -> name;
            return this;
        }

        public Builder setName(StatListWidget.TextGetter name) {
            this.name = name;
            return this;
        }

        public Builder setTranslationKey(String key) {
            this.translationKey = key;
            this.name = stack -> Component.translatable((String)("miapi.stat." + key), (Object[])new Object[]{SingleStatDisplayBoolean.getText(this.property.isTrue(stack))});
            this.hoverDescription = stack -> Component.translatable((String)("miapi.stat." + key + ".description" + String.valueOf(SingleStatDisplayBoolean.getText(this.property.isTrue(stack)))));
            return this;
        }

        public Builder setHoverDescription(Component hoverDescription) {
            this.hoverDescription = stack -> hoverDescription;
            return this;
        }

        public Builder setHoverDescription(StatListWidget.TextGetter hoverDescription) {
            this.hoverDescription = hoverDescription;
            return this;
        }

        public BooleanStatDisplay build() {
            if (this.name == null) {
                throw new IllegalStateException("Name is required");
            }
            if (this.property == null) {
                throw new IllegalStateException("Property is required");
            }
            BooleanStatDisplay display = new BooleanStatDisplay(this.name, this.hoverDescription, this.property);
            return display;
        }
    }
}

