/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.statdisplay;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.Miapi;
import smartin.miapi.client.gui.crafting.statdisplay.SingleStatDisplayBoolean;
import smartin.miapi.client.gui.crafting.statdisplay.StatListWidget;
import smartin.miapi.modules.properties.util.ComplexBooleanProperty;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;

@OnlyIn(value=Dist.CLIENT)
public class ComplexBooleanStatDisplay
extends SingleStatDisplayBoolean {
    public ComplexBooleanProperty property;

    public ComplexBooleanStatDisplay(StatListWidget.TextGetter title, StatListWidget.TextGetter hover, ComplexBooleanProperty property) {
        super(0, 0, 51, 19, title, hover);
        this.property = property;
    }

    @Override
    public boolean getValueItemStack(ItemStack itemStack) {
        return this.property.isTrue(itemStack);
    }

    @Override
    public boolean hasValueItemStack(ItemStack itemStack) {
        return this.property.hasValue(itemStack);
    }

    @Override
    public DoubleOperationResolvable getResolvable(ItemStack stack) {
        return this.property.getData(stack).orElse(null);
    }

    public static Builder builder(ComplexBooleanProperty property) {
        return new Builder(property);
    }

    public static class Builder {
        ComplexBooleanProperty property;
        public StatListWidget.TextGetter name;
        public StatListWidget.TextGetter hoverDescription = stack -> Component.empty();
        public String translationKey = "";
        public Object[] descriptionArgs = new Object[0];

        private Builder(ComplexBooleanProperty property) {
            this.property = property;
        }

        public Builder setName(Component name) {
            this.name = stack -> name;
            return this;
        }

        public Builder setName(StatListWidget.TextGetter name) {
            this.name = name;
            return this;
        }

        public Builder setTranslationKey(ResourceLocation key) {
            this.translationKey = Miapi.toLangString(key);
            this.name = stack -> Component.translatable((String)("miapi.stat." + this.translationKey), (Object[])new Object[]{SingleStatDisplayBoolean.getText(this.property.getValue(stack).orElse(0.0))});
            this.hoverDescription = stack -> Component.translatable((String)("miapi.stat." + this.translationKey + ".description"), (Object[])new Object[]{SingleStatDisplayBoolean.getText(this.property.getValue(stack).orElse(0.0))});
            return this;
        }

        public Builder setHoverDescription(Component hoverDescription) {
            this.hoverDescription = stack -> hoverDescription;
            return this;
        }

        public Builder setHoverDescription(StatListWidget.TextGetter hoverDescription) {
            this.hoverDescription = hoverDescription;
            return this;
        }

        public ComplexBooleanStatDisplay build() {
            if (this.name == null) {
                throw new IllegalStateException("Name is required");
            }
            if (this.property == null) {
                throw new IllegalStateException("Property is required");
            }
            return new ComplexBooleanStatDisplay(this.name, this.hoverDescription, this.property);
        }
    }
}

