/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.statdisplay;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.Miapi;
import smartin.miapi.client.gui.crafting.statdisplay.SingleStatDisplayDouble;
import smartin.miapi.client.gui.crafting.statdisplay.StatListWidget;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;

@OnlyIn(value=Dist.CLIENT)
public class DoubleResolvableStatDisplay
extends SingleStatDisplayDouble {
    protected Function<ItemStack, Optional<DoubleOperationResolvable>> resolvableGetter;
    public BiFunction<ItemStack, ItemStack, Boolean> condition = (old, compare) -> true;

    protected DoubleResolvableStatDisplay(StatListWidget.TextGetter title, StatListWidget.TextGetter hover, Function<ItemStack, Optional<DoubleOperationResolvable>> resolvableGetter) {
        super(0, 0, 51, 19, title, hover);
        this.resolvableGetter = resolvableGetter;
    }

    @Override
    public boolean shouldRender(ItemStack original, ItemStack compareTo) {
        super.shouldRender(original, compareTo);
        if (!this.condition.apply(original, compareTo).booleanValue()) {
            return false;
        }
        return this.resolvableGetter.apply(original).isPresent() && !this.resolvableGetter.apply((ItemStack)original).get().operations.isEmpty() && this.resolvableGetter.apply(original).get().getValue() != this.resolvableGetter.apply(original).get().getFallback() || this.resolvableGetter.apply(compareTo).isPresent() && !this.resolvableGetter.apply((ItemStack)compareTo).get().operations.isEmpty() && this.resolvableGetter.apply(compareTo).get().getValue() != this.resolvableGetter.apply(compareTo).get().getFallback();
    }

    @Override
    public double getValue(ItemStack stack) {
        return this.resolvableGetter.apply(stack).map(DoubleOperationResolvable::getValue).orElse(0.0);
    }

    @Override
    public DoubleOperationResolvable getResolvable(ItemStack stack) {
        return this.resolvableGetter.apply(stack).orElse(null);
    }

    public static String getStringName(AttributeModifier.Operation operation) {
        return switch (operation) {
            default -> throw new MatchException(null, null);
            case AttributeModifier.Operation.ADD_VALUE -> "+";
            case AttributeModifier.Operation.ADD_MULTIPLIED_BASE -> "*";
            case AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL -> "**";
        };
    }

    public static Builder builder(Function<ItemStack, Optional<DoubleOperationResolvable>> getter) {
        return new Builder(getter);
    }

    public static class Builder {
        Function<ItemStack, Optional<DoubleOperationResolvable>> getter;
        public StatListWidget.TextGetter name;
        public StatListWidget.TextGetter hoverDescription = stack -> Component.empty();
        public DecimalFormat modifierFormat;
        public DecimalFormat hoverFormat;
        public double min = 0.0;
        public double max = 100.0;
        public boolean inverse = false;
        public BiFunction<ItemStack, ItemStack, Boolean> condition = (old, compare) -> this.getter.apply((ItemStack)old).isPresent() && !this.getter.apply((ItemStack)old).get().operations.isEmpty() || this.getter.apply((ItemStack)compare).isPresent() && !this.getter.apply((ItemStack)compare).get().operations.isEmpty();

        private Builder(Function<ItemStack, Optional<DoubleOperationResolvable>> getter) {
            this.getter = getter;
            this.modifierFormat = (DecimalFormat)Util.make((Object)new DecimalFormat("##.##"), df -> df.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
        }

        public Builder setInverse(boolean inverse) {
            this.inverse = inverse;
            return this;
        }

        public Builder setCondition(BiFunction<ItemStack, ItemStack, Boolean> condition) {
            this.condition = condition;
            return this;
        }

        public Builder setMax(double maxValue) {
            this.max = maxValue;
            return this;
        }

        public Builder setMin(double minValue) {
            this.min = minValue;
            return this;
        }

        public Builder setName(Component name) {
            this.name = stack -> name;
            return this;
        }

        public Builder setName(StatListWidget.TextGetter name) {
            this.name = name;
            return this;
        }

        public Builder setTranslationKey(ResourceLocation key) {
            String translationKey = Miapi.toLangString(key);
            this.name = stack -> Component.translatable((String)("miapi.stat." + translationKey), (Object[])new Object[]{this.modifierFormat.format(this.getter.apply(stack).map(DoubleOperationResolvable::getValue).orElse(0.0))});
            this.hoverDescription = stack -> Component.translatable((String)("miapi.stat." + translationKey + ".description"), (Object[])new Object[]{this.modifierFormat.format(this.getter.apply(stack).map(DoubleOperationResolvable::getValue).orElse(0.0))});
            return this;
        }

        public Builder setHoverDescription(Component hoverDescription) {
            this.hoverDescription = stack -> hoverDescription;
            return this;
        }

        public Builder setHoverDescription(StatListWidget.TextGetter hoverDescription) {
            this.hoverDescription = hoverDescription;
            return this;
        }

        public Builder setFormat(String format) {
            this.modifierFormat = (DecimalFormat)Util.make((Object)new DecimalFormat(format), df -> df.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
            return this;
        }

        public Builder setHoverFormat(String format) {
            this.hoverFormat = (DecimalFormat)Util.make((Object)new DecimalFormat(format), df -> df.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));
            return this;
        }

        public DoubleResolvableStatDisplay build() {
            if (this.name == null) {
                throw new IllegalStateException("Name is required");
            }
            if (this.getter == null) {
                throw new IllegalStateException("Resolvable getter is required");
            }
            DoubleResolvableStatDisplay display = new DoubleResolvableStatDisplay(this.name, this.hoverDescription, this.getter);
            display.maxValue = this.max;
            display.minValue = this.min;
            display.modifierFormat = this.modifierFormat;
            display.inverse = this.inverse;
            display.condition = this.condition;
            display.hoverFormat = this.hoverFormat != null ? this.hoverFormat : this.modifierFormat;
            return display;
        }
    }
}

