/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.statdisplay;

import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import smartin.miapi.attributes.AttributeRegistry;
import smartin.miapi.client.gui.crafting.statdisplay.SingleStatDisplayDouble;
import smartin.miapi.modules.properties.attributes.AttributeUtil;

@OnlyIn(value=Dist.CLIENT)
public class DpsStatDisplay
extends SingleStatDisplayDouble {
    public DpsStatDisplay() {
        super(0, 0, 51, 19, stack -> Component.translatable((String)"miapi.stat.miapi.dps"), stack -> Component.translatable((String)"miapi.stat.miapi.dps.description"));
        this.maxValue = 25.0;
    }

    @Override
    public boolean shouldRender(ItemStack original, ItemStack compareTo) {
        if (this.hasAttackDamage(original) || this.hasAttackDamage(compareTo)) {
            super.shouldRender(original, compareTo);
            return this.getValue(original) != 4.0 || this.getValue(compareTo) != 4.0;
        }
        return false;
    }

    private boolean hasAttackDamage(ItemStack itemStack) {
        return AttributeUtil.getActualValue(itemStack, EquipmentSlot.MAINHAND, (Attribute)Attributes.ATTACK_DAMAGE.value()) != 0.0;
    }

    @Override
    public double getValue(ItemStack stack) {
        double attackDamage = AttributeRegistry.getAttribute(stack, (Attribute)Attributes.ATTACK_DAMAGE.value(), EquipmentSlot.MAINHAND, 1.0);
        double attackSpeed = AttributeRegistry.getAttribute(stack, (Attribute)Attributes.ATTACK_SPEED.value(), EquipmentSlot.MAINHAND, 4.0);
        return attackDamage * attackSpeed;
    }
}

