/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.statdisplay;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import smartin.miapi.client.gui.crafting.statdisplay.SingleStatDisplayDouble;
import smartin.miapi.modules.properties.LoreProperty;
import smartin.miapi.modules.properties.mining.MiningLevelProperty;
import smartin.miapi.modules.properties.util.DoubleOperationResolvable;

public class MiningPropertyStatDisplay
extends SingleStatDisplayDouble {
    public final String type;

    public MiningPropertyStatDisplay(String type) {
        super(0, 0, 51, 19, stack -> Component.translatable((String)("miapi.stat.miapi.mining.level." + type)), s -> Component.translatable((String)("miapi.stat.miapi.mining.level." + type + ".description")));
        this.type = type;
        this.maxValue = 15.0;
    }

    @Override
    public double getValue(ItemStack stack) {
        MiningLevelProperty.MiningRule rule = (MiningLevelProperty.MiningRule)((Map)MiningLevelProperty.property.getData(stack).orElse(new HashMap())).get(this.type);
        if (rule != null) {
            return rule.speed().getValue();
        }
        return 0.0;
    }

    @Override
    public boolean shouldRender(ItemStack original, ItemStack compareTo) {
        super.shouldRender(original, compareTo);
        return ((Map)MiningLevelProperty.property.getData(original).orElse(new HashMap())).containsKey(this.type) && ((MiningLevelProperty.MiningRule)((Map)MiningLevelProperty.property.getData(original).orElse(new HashMap())).get(this.type)).speed().getValue() != 1.0 && ((MiningLevelProperty.MiningRule)((Map)MiningLevelProperty.property.getData(original).orElse(new HashMap())).get(this.type)).speed().getValue() != 0.0 || ((Map)MiningLevelProperty.property.getData(compareTo).orElse(new HashMap())).containsKey(this.type) && ((MiningLevelProperty.MiningRule)((Map)MiningLevelProperty.property.getData(compareTo).orElse(new HashMap())).get(this.type)).speed().getValue() != 1.0 && ((MiningLevelProperty.MiningRule)((Map)MiningLevelProperty.property.getData(compareTo).orElse(new HashMap())).get(this.type)).speed().getValue() != 0.0;
    }

    @Override
    public DoubleOperationResolvable getResolvable(ItemStack stack) {
        MiningLevelProperty.MiningRule rule = (MiningLevelProperty.MiningRule)((Map)MiningLevelProperty.property.getData(this.compareTo == null ? this.original : this.compareTo).orElse(new HashMap())).get(this.type);
        if (rule != null) {
            return rule.speed();
        }
        return null;
    }

    @Override
    public List<Component> additionalHoverLines() {
        ArrayList<Component> lines = new ArrayList<Component>();
        MiningLevelProperty.MiningRule rule = (MiningLevelProperty.MiningRule)((Map)MiningLevelProperty.property.getData(this.compareTo == null ? this.original : this.compareTo).orElse(new HashMap())).get(this.type);
        if (rule != null) {
            rule.respectMaterialBlacklists().stream().distinct().forEach(m -> {
                lines.add((Component)Component.translatable((String)"miapi.stat.miapi.mining.level.material.source", (Object[])new Object[]{m.getTranslation()}).withStyle(ChatFormatting.GRAY));
                m.getMiningLevelToolTip().forEach(c -> lines.add(LoreProperty.format(c, ChatFormatting.DARK_GRAY)));
            });
        }
        return lines;
    }
}

