/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.gui.crafting.statdisplay.material;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import smartin.miapi.Miapi;
import smartin.miapi.client.gui.InteractAbleWidget;
import smartin.miapi.client.gui.ScrollList;
import smartin.miapi.client.gui.crafting.statdisplay.StatListWidget;
import smartin.miapi.client.gui.crafting.statdisplay.material.MaterialGroupTitleWidget;
import smartin.miapi.material.MaterialProperty;
import smartin.miapi.material.base.Material;
import smartin.miapi.mixin.RegistryOpsAccessor;
import smartin.miapi.modules.ItemModule;
import smartin.miapi.modules.ModuleDataPropertiesManager;
import smartin.miapi.modules.ModuleInstance;
import smartin.miapi.registries.RegistryInventory;

@OnlyIn(value=Dist.CLIENT)
public class MaterialStatWidget
extends InteractAbleWidget {
    ScrollList list;
    Material original;

    public MaterialStatWidget(Material original, Material compareTo, int x, int y, int width, int height, Component message) {
        super(x, y, width, height, message);
        this.original = original;
        this.list = new ScrollList(this.getX(), this.getY(), this.getWidth(), this.getHeight(), List.of());
        this.list.alwaysEnableScrollbar = true;
        this.list.altDesign = true;
        this.addChild(this.list);
        this.setup(original, compareTo);
    }

    private void setup(Material original, Material compareTo) {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        keys.addAll(original.getAllDisplayPropertyKeys());
        keys.addAll(compareTo.getAllDisplayPropertyKeys());
        ArrayList<InteractAbleWidget> widgets = new ArrayList<InteractAbleWidget>();
        for (String propertyKey : keys) {
            ItemStack compareStack;
            ItemStack originalStack = MaterialStatWidget.getDisplayStack(original, propertyKey);
            List<InteractAbleWidget> stats = StatListWidget.collectWidgets(originalStack, compareStack = MaterialStatWidget.getDisplayStack(compareTo, propertyKey));
            if (stats.isEmpty()) continue;
            widgets.add(new MaterialGroupTitleWidget(0, 0, this.width, propertyKey, stats, originalStack, compareStack));
            widgets.addAll(stats);
        }
        this.list.setList(widgets);
    }

    public void setCompareTo(ItemStack compareTo) {
        Material compareToMaterial = MaterialProperty.getMaterialFromIngredient(compareTo);
        if (compareToMaterial != null) {
            this.setup(this.original, compareToMaterial);
        }
    }

    @NotNull
    private static ItemStack getDisplayStack(Material original, String propertyKey) {
        ModuleInstance moduleInstance = new ModuleInstance(ItemModule.internal);
        ItemStack compareMaterial = RegistryInventory.modularStackableItem.getDefaultInstance();
        ModuleDataPropertiesManager.setProperties(moduleInstance, original.getDisplayMaterialProperties(propertyKey));
        moduleInstance.clearCaches();
        moduleInstance.writeToItem(compareMaterial);
        moduleInstance.lookup = ((RegistryOpsAccessor)RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)Miapi.registryAccess)).getLookupProvider();
        moduleInstance.contextStack = compareMaterial;
        moduleInstance.registryAccess = Miapi.registryAccess;
        StatListWidget.setAttributeCaches(compareMaterial, compareMaterial);
        return compareMaterial;
    }
}

