/*
 * Decompiled with CFR 0.152.
 */
package smartin.miapi.client.model;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.BuiltInModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import smartin.miapi.Miapi;
import smartin.miapi.client.model.ColorUtil;
import smartin.miapi.client.model.ModelLoadAccessor;
import smartin.miapi.client.model.item.BakedSingleModel;
import smartin.miapi.client.model.item.BakedSingleModelOverrides;
import smartin.miapi.item.modular.Transform;
import smartin.miapi.modules.properties.render.ModelProperty;

@OnlyIn(value=Dist.CLIENT)
public class DynamicBakery {
    public static ModelBaker dynamicBaker;
    static final ItemModelGenerator ITEM_MODEL_GENERATOR;
    private static final FaceBakery QUAD_FACTORY;

    private DynamicBakery() {
    }

    public static BakedSingleModel bakeModel(BlockModel unbakedModel, Function<Material, TextureAtlasSprite> textureGetter, int color, Transform settings) {
        try {
            ModelBakery modelLoader = ModelLoadAccessor.getLoader();
            AtomicReference<BlockModel> actualModel = new AtomicReference<BlockModel>(unbakedModel);
            unbakedModel.getDependencies().stream().filter(identifier -> identifier.toString().equals("minecraft:item/generated") || identifier.toString().contains("handheld")).findFirst().ifPresent(identifier -> actualModel.set(ITEM_MODEL_GENERATOR.generateBlockModel(ModelProperty.textureGetter, unbakedModel)));
            BakedSingleModel model = DynamicBakery.bake(actualModel.get(), modelLoader, unbakedModel.getRootModel(), textureGetter, Transform.toModelTransformation(settings), ResourceLocation.parse((String)unbakedModel.name), true, color);
            for (Direction direction : Direction.values()) {
                if (model.getQuads(null, direction, RandomSource.create()).isEmpty()) continue;
                return model;
            }
            try {
                actualModel.set(ITEM_MODEL_GENERATOR.generateBlockModel(ModelProperty.textureGetter, unbakedModel));
                return DynamicBakery.bake(actualModel.get(), modelLoader, unbakedModel.getRootModel(), textureGetter, Transform.toModelTransformation(settings), ResourceLocation.parse((String)unbakedModel.name), true, color);
            }
            catch (Exception exception) {
                return model;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BakedSingleModel bake(BlockModel model, ModelBakery loader, BlockModel parent, Function<Material, TextureAtlasSprite> textureGetter, Transform settings, ResourceLocation id, boolean hasDepth, int color) {
        TextureAtlasSprite sprite = textureGetter.apply(model.getMaterial("particle"));
        if (model.getRootModel() == ModelBakery.BLOCK_ENTITY_MARKER) {
            BuiltInModel model1 = new BuiltInModel(model.getTransforms(), DynamicBakery.compileOverrides(model, loader, parent, textureGetter, (ModelState)BlockModelRotation.X0_Y0, color), sprite, model.getGuiLight().lightLikeBlock());
            return DynamicBakery.dynamicBakedModel(DynamicBakery.rotate((BakedModel)model1, settings));
        }
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(model, DynamicBakery.compileOverrides(model, loader, parent, textureGetter, (ModelState)BlockModelRotation.X0_Y0, color), hasDepth).particle(sprite);
        for (BlockElement modelElement : model.getElements()) {
            for (Direction direction : modelElement.faces.keySet()) {
                BlockElementFace modelElementFace = (BlockElementFace)modelElement.faces.get(direction);
                try {
                    if (modelElementFace.texture() == null || model.getMaterial(modelElementFace.texture()).texture().toString().equals("miapi:block/texture/modular_workbench") || model.getMaterial(modelElementFace.texture()).texture().toString().equals("miapi:texture/block/modular_workbench")) continue;
                    TextureAtlasSprite sprite2 = textureGetter.apply(model.getMaterial(modelElementFace.texture()));
                    if (modelElementFace.cullForDirection() == null) {
                        builder.addUnculledFace(DynamicBakery.createQuad(modelElement, modelElementFace, sprite2, direction, (ModelState)BlockModelRotation.X0_Y0, id, color));
                        continue;
                    }
                    builder.addCulledFace(Direction.rotate((Matrix4f)BlockModelRotation.X0_Y0.getRotation().getMatrix(), (Direction)modelElementFace.cullForDirection()), DynamicBakery.createQuad(modelElement, modelElementFace, sprite2, direction, (ModelState)BlockModelRotation.X0_Y0, id, color));
                }
                catch (RuntimeException e) {
                    Miapi.LOGGER.info("could not find texture for model " + String.valueOf(id));
                }
            }
        }
        return DynamicBakery.dynamicBakedModel(DynamicBakery.rotate(builder.build(), settings));
    }

    public static BakedModel rotate(BakedModel model, Transform transform) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        HashMap directionBakedModelMap = new HashMap();
        for (Object direction : Direction.values()) {
            directionBakedModelMap.put((Direction)direction, new ArrayList());
        }
        for (BakedQuad quad : model.getQuads(null, null, RandomSource.create())) {
            quads.addAll(DynamicBakery.rotate(quad, transform));
        }
        for (Object direction : Direction.values()) {
            for (BakedQuad quad : model.getQuads(null, direction, RandomSource.create())) {
                quads.addAll(DynamicBakery.rotate(quad, transform));
            }
        }
        return new SimpleBakedModel(quads, directionBakedModelMap, model.useAmbientOcclusion(), model.usesBlockLight(), model.isGui3d(), model.getParticleIcon(), model.getTransforms(), model.getOverrides());
    }

    public static List<BakedQuad> rotate(BakedQuad quad, Transform transform) {
        int[] rotatedData = transform.rotateVertexData(quad.getVertices());
        for (int i = 0; i < 4; ++i) {
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        quads.add(new BakedQuad(rotatedData, quad.getTintIndex(), Direction.rotate((Matrix4f)transform.toMatrix(), (Direction)quad.getDirection()), quad.getSprite(), quad.isShade()));
        for (int i = 0; i < rotatedData.length; i += 8) {
            int endIndex = Math.min(i + 8, rotatedData.length);
            int[] nArray = Arrays.copyOfRange(rotatedData, i, endIndex);
        }
        return quads;
    }

    public static BakedSingleModel dynamicBakedModel(BakedModel model) {
        if (model instanceof BakedSingleModel) {
            BakedSingleModel bakedSIngleModel = (BakedSingleModel)model;
            new Exception().printStackTrace();
            return bakedSIngleModel;
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        quads.addAll(model.getQuads(null, null, RandomSource.create()));
        for (Direction dir : Direction.values()) {
            quads.addAll(model.getQuads(null, dir, RandomSource.create()));
        }
        BakedSingleModel model1 = new BakedSingleModel(quads);
        model1.overrideList = model.getOverrides();
        return model1;
    }

    private static ItemOverrides compileOverrides(BlockModel model, ModelBakery modelLoader, BlockModel parent, Function<Material, TextureAtlasSprite> textureGetter, ModelState rotation, int color) {
        if (model.getOverrides().isEmpty()) {
            return ItemOverrides.EMPTY;
        }
        Objects.requireNonNull(modelLoader);
        return new DynamicOverrideList(modelLoader, parent, model.getOverrides(), textureGetter, rotation, color);
    }

    private static BakedQuad createQuad(BlockElement element, BlockElementFace elementFace, TextureAtlasSprite sprite, Direction side, ModelState settings, ResourceLocation id, int color) {
        BakedQuad quad = QUAD_FACTORY.bakeQuad(element.from, element.to, elementFace, sprite, side, settings, element.rotation, element.shade);
        quad = ColorUtil.recolorBakedQuad(quad, color);
        return quad;
    }

    static {
        ITEM_MODEL_GENERATOR = new ItemModelGenerator();
        QUAD_FACTORY = new FaceBakery();
    }

    public static class DynamicOverrideList
    extends ItemOverrides {
        public final DynamicBakedOverride[] dynamicOverrides;
        public final ResourceLocation[] dynamicConditionTypes;
        public final List<ItemOverride> overrideList;

        public DynamicOverrideList(ModelBakery modelLoader, BlockModel parent, List<ItemOverride> overrides, Function<Material, TextureAtlasSprite> textureGetter, ModelState rotation, int color) {
            super(dynamicBaker, parent, overrides);
            this.dynamicConditionTypes = (ResourceLocation[])overrides.stream().flatMap(ItemOverride::getPredicates).map(ItemOverride.Predicate::getProperty).distinct().toArray(ResourceLocation[]::new);
            Object2IntOpenHashMap object2IntMap = new Object2IntOpenHashMap();
            this.overrideList = overrides;
            for (int i = 0; i < this.dynamicConditionTypes.length; ++i) {
                object2IntMap.put((Object)this.dynamicConditionTypes[i], i);
            }
            ArrayList list = Lists.newArrayList();
            for (int j = overrides.size() - 1; j >= 0; --j) {
                ItemOverride modelOverride = overrides.get(j);
                BlockModel model = ModelProperty.modelCache.get(modelOverride.getModel().toString()).model();
                BakedSingleModel bakedModel = DynamicBakery.bakeModel(model, textureGetter, color, Transform.IDENTITY);
                assert (bakedModel != null);
                bakedModel = (BakedSingleModel)ColorUtil.recolorModel(bakedModel, color);
                InlinedCondition[] inlinedConditions = (InlinedCondition[])modelOverride.getPredicates().map(arg_0 -> DynamicOverrideList.lambda$new$1((Object2IntMap)object2IntMap, arg_0)).toArray(InlinedCondition[]::new);
                list.add(new DynamicBakedOverride(inlinedConditions, bakedModel, overrides.get(j)));
            }
            this.dynamicOverrides = list.toArray(new DynamicBakedOverride[0]);
        }

        @Nullable
        public BakedModel resolve(BakedModel model, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
            if (this.dynamicOverrides.length != 0) {
                int i = this.dynamicConditionTypes.length;
                float[] fs = new float[i];
                for (int j = 0; j < i; ++j) {
                    ResourceLocation identifier = this.dynamicConditionTypes[j];
                    ItemPropertyFunction modelPredicateProvider = ItemProperties.getProperty((ItemStack)stack, (ResourceLocation)identifier);
                    fs[j] = modelPredicateProvider != null ? modelPredicateProvider.call(stack, world, entity, seed) : Float.NEGATIVE_INFINITY;
                }
                for (DynamicBakedOverride bakedOverride : this.dynamicOverrides) {
                    if (!bakedOverride.test(fs)) continue;
                    BakedModel bakedModel = bakedOverride.model;
                    if (bakedModel == null) {
                        return model;
                    }
                    return bakedModel;
                }
            }
            return model;
        }

        private static /* synthetic */ InlinedCondition lambda$new$1(Object2IntMap object2IntMap, ItemOverride.Predicate condition) {
            int i = object2IntMap.getInt((Object)condition.getProperty());
            return new InlinedCondition(i, condition.getValue());
        }

        @OnlyIn(value=Dist.CLIENT)
        private record InlinedCondition(int index, float threshold) {
        }

        @OnlyIn(value=Dist.CLIENT)
        public static class DynamicBakedOverride {
            public final InlinedCondition[] conditions;
            @Nullable
            public final BakedModel model;
            public final BakedSingleModelOverrides.ConditionHolder conditionHolder;

            DynamicBakedOverride(InlinedCondition[] conditions, @Nullable BakedModel model, ItemOverride override) {
                this.conditions = conditions;
                this.model = model;
                this.conditionHolder = new BakedSingleModelOverrides.ConditionHolder(override);
            }

            boolean test(float[] values) {
                for (InlinedCondition inlinedCondition : this.conditions) {
                    float f = values[inlinedCondition.index];
                    if (!(f < inlinedCondition.threshold)) continue;
                    return false;
                }
                return true;
            }
        }
    }
}

